/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.utils.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class MeModel {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public final boolean DEBUG = false;
    public final MTag motionScene;
    public final MTag layout;
    public final String layoutFileName;
    public final String motionSceneFileName;
    MotionEditorSelector.Type mSelectedType;
    public MTag[] mSelected;
    private float mProgress;
    private String[] mSelectedViewIDs = EMPTY_STRING_ARRAY;
    public Track myTrack;

    void clearViewInfo() {
        MTag[] view = this.layout.getChildTags();
        for (int i2 = 0; i2 < view.length; ++i2) {
            MTag tag = view[i2];
            tag.setClientData("motionLayoutProperties", null);
        }
    }

    public HashMap<String, MotionAttributes> populateViewInfo(MTag constraintSet) {
        ArrayList ids2 = new ArrayList();
        HashMap<String, MotionAttributes> viewBundles = new HashMap<String, MotionAttributes>();
        HashMap<String, MotionAttributes> filledBundles = new HashMap<String, MotionAttributes>();
        ArrayList<MTag> csetChain = new ArrayList<MTag>();
        MTag set = constraintSet;
        while (set != null) {
            csetChain.add(set);
            set = this.getDerivedFrom(set);
        }
        MTag[] view = this.layout.getChildTags();
        HashMap<String, MTag> viewMap = new HashMap<String, MTag>();
        for (int i2 = 0; i2 < view.length; ++i2) {
            String id = view[i2].getAttributeValue("id");
            if (id == null) continue;
            id = Utils.stripID(id);
            viewMap.put(id, view[i2]);
            viewBundles.put(id, new MotionAttributes(id, constraintSet));
        }
        for (MTag cset : csetChain) {
            String constraintSetId = Utils.stripID(cset.getAttributeValue("id"));
            MTag[] constraint = cset.getChildTags();
            for (int i3 = 0; i3 < constraint.length; ++i3) {
                int j;
                MotionAttributes bundle;
                String id = constraint[i3].getAttributeValue("id");
                if (id == null || (bundle = (MotionAttributes)viewBundles.get(id = Utils.stripID(id))) == null) continue;
                MTag[] subTags = constraint[i3].getChildTags();
                HashMap<String, MTag.Attribute> attr = constraint[i3].getAttrList();
                boolean allCustom = true;
                for (j = 0; j < subTags.length; ++j) {
                    if (subTags[j].getTagName().equals("CustomAttribute")) continue;
                    allCustom = false;
                    break;
                }
                if ((subTags.length == 0 || allCustom) && attr.size() > 1) {
                    bundle.loadAttrs(MotionAttributes.Section.ALL, constraintSetId, attr);
                    bundle.consume(true, true, true, true);
                    for (j = 0; j < subTags.length; ++j) {
                        MTag subTag = subTags[j];
                        bundle.addCustomAttrs(constraintSetId, subTag);
                    }
                    viewBundles.remove(id);
                    filledBundles.put(id, bundle);
                }
                block20: for (j = 0; j < subTags.length; ++j) {
                    String tagType;
                    switch (tagType = subTags[j].getTagName()) {
                        case "Motion": {
                            bundle.loadAttrs(MotionAttributes.Section.MOTION, constraintSetId, subTags[j].getAttrList());
                            continue block20;
                        }
                        case "Transform": {
                            bundle.loadAttrs(MotionAttributes.Section.TRANSFORM, constraintSetId, subTags[j].getAttrList());
                            continue block20;
                        }
                        case "PropertySet": {
                            bundle.loadAttrs(MotionAttributes.Section.PROPERTY_SET, constraintSetId, subTags[j].getAttrList());
                            continue block20;
                        }
                        case "Layout": {
                            bundle.loadAttrs(MotionAttributes.Section.LAYOUT, constraintSetId, subTags[j].getAttrList());
                            continue block20;
                        }
                        case "CustomAttribute": {
                            bundle.addCustomAttrs(constraintSetId, subTags[j]);
                            continue block20;
                        }
                        default: {
                            Debug.log("Unknown TAG! " + tagType);
                        }
                    }
                }
                if (!bundle.allFilled()) continue;
                viewBundles.remove(id);
                filledBundles.put(id, bundle);
            }
        }
        for (String id : new ArrayList(viewBundles.keySet())) {
            MotionAttributes bundle = (MotionAttributes)viewBundles.get(id);
            MTag viewTag = (MTag)viewMap.get(id);
            bundle.loadViewAttrs(viewTag);
            viewBundles.remove(id);
            filledBundles.put(id, bundle);
        }
        return filledBundles;
    }

    MTag getConstraint(MTag constraintSet, String stripedId) {
        MTag[] constraint = constraintSet.getChildTags("Constraint");
        for (int i2 = 0; i2 < constraint.length; ++i2) {
            String str = Utils.stripID(constraint[i2].getAttributeValue("id"));
            if (!stripedId.equals(str)) continue;
            return constraint[i2];
        }
        return null;
    }

    MTag getDerivedFrom(MTag cset) {
        String s = cset.getAttributeValue("deriveConstraintsFrom");
        if (s == null) {
            return null;
        }
        s = Utils.stripID(s);
        MTag[] constraintSets = this.motionScene.getChildTags("ConstraintSet");
        for (int i2 = 0; i2 < constraintSets.length; ++i2) {
            String str = Utils.stripID(constraintSets[i2].getAttributeValue("id"));
            if (!s.equals(str)) continue;
            return constraintSets[i2];
        }
        return null;
    }

    public MeModel(MTag motionScene, MTag layout2, String layoutFileName, String motionSceneFileName, Track track2) {
        this.layout = layout2;
        this.motionScene = motionScene;
        this.layoutFileName = layoutFileName;
        this.motionSceneFileName = motionSceneFileName;
        this.myTrack = track2;
    }

    public MeModel(MTag motionScene, MTag layout2, String layoutFileName, String motionSceneFileName) {
        this.layout = layout2;
        this.motionScene = motionScene;
        this.layoutFileName = layoutFileName;
        this.motionSceneFileName = motionSceneFileName;
    }

    public MTag getConstraintSet(String id) {
        MTag[] sets = this.motionScene.getChildTags("ConstraintSet", "id", id = Utils.stripID(id));
        if (sets.length == 1) {
            return sets[0];
        }
        return null;
    }

    public void setSelected(MotionEditorSelector.Type type, MTag[] tags2) {
        if (type == MotionEditorSelector.Type.CONSTRAINT_SET) {
            MTag[] views2;
            MTag[] constraints = tags2[0].getChildTags();
            HashMap<String, MTag> constraintMap = new HashMap<String, MTag>();
            for (int i2 = 0; i2 < constraints.length; ++i2) {
                MTag constraint = constraints[i2];
                String id = constraint.getAttributeValue("id");
                if (id == null) continue;
                constraintMap.put(Utils.stripID(id), constraint);
            }
            HashMap<String, MotionAttributes> motionAttributeSet = this.populateViewInfo(tags2[0]);
            for (MTag view : views2 = this.layout.getChildTags()) {
                String id = view.getAttributeValue("id");
                if (id == null) continue;
                id = Utils.stripID(id);
                view.setClientData("motionLayoutProperties", motionAttributeSet.get(id));
                view.setClientData("MotionTagForMotionScene", constraintMap.get(id));
            }
        } else if (type == MotionEditorSelector.Type.LAYOUT) {
            this.clearViewInfo();
        }
        this.mSelectedType = type;
        this.mSelected = tags2;
    }

    public MotionEditorSelector.Type getSelectedType() {
        return this.mSelectedType;
    }

    public MTag[] getSelected() {
        return this.mSelected;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
    }

    public float getCurrentProgress() {
        return this.mProgress;
    }

    public String[] getLayoutViewNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.layout == null) {
            return EMPTY_STRING_ARRAY;
        }
        MTag[] allViews = this.layout.getChildTags();
        for (int j = 0; j < allViews.length; ++j) {
            String[] row = new String[3];
            MTag view = allViews[j];
            String layoutId = Utils.stripID(view.getAttributeValue("id"));
            ret.add(layoutId);
        }
        return ret.toArray(EMPTY_STRING_ARRAY);
    }

    public MTag findStartConstraintSet(MTag transitionOrChild) {
        MTag transition = transitionOrChild;
        while (!"Transition".equals(transition.getTagName())) {
            if ((transition = transition.getParent()) != null) continue;
            return null;
        }
        String start = transition.getAttributeValue("constraintSetStart");
        return this.getConstraintSet(start);
    }

    public MTag findEndConstraintSet(MTag transitionOrChild) {
        MTag transition = transitionOrChild;
        while (!"Transition".equals(transition.getTagName())) {
            if ((transition = transition.getParent()) != null) continue;
            return null;
        }
        String end = transition.getAttributeValue("constraintSetEnd");
        return this.getConstraintSet(end);
    }

    public void findStartAndEndValues(MTag layout2, String attribute, MTag mTag, String[] values) {
        MTag transition = mTag.getParent().getParent();
        String target = mTag.getAttributeValue("motionTarget");
        String start = transition.getAttributeValue("constraintSetStart");
        String end = transition.getAttributeValue("constraintSetEnd");
        MTag startSet = this.getConstraintSet(start);
        String startValue = this.findAttribute(layout2, startSet, target, attribute);
        if (startValue == null) {
            values[0] = this.defaultValueForAttribute(attribute);
        }
        MTag endSet = this.getConstraintSet(end);
        String endValue = this.findAttribute(layout2, startSet, target, attribute);
        if (endValue == null) {
            values[1] = this.defaultValueForAttribute(attribute);
        }
    }

    private String defaultValueForAttribute(String attribute) {
        switch (attribute) {
            case "elevation": {
                return "0";
            }
            case "rotation": {
                return "0";
            }
            case "rotationX": {
                return "0";
            }
            case "rotationY": {
                return "0";
            }
            case "scaleX": {
                return "1";
            }
            case "scaleY": {
                return "1";
            }
            case "translationX": {
                return "0";
            }
            case "translationY": {
                return "0";
            }
            case "translationZ": {
                return "0";
            }
            case "transitionPathRotate": {
                return "0";
            }
            case "alpha": {
                return "1";
            }
            case "motionProgress": {
                return "0";
            }
        }
        return null;
    }

    String findAttribute(MTag layout2, MTag cSet, String id, String attribute) {
        if (cSet != null) {
            MTag[] derivedTag;
            String value2;
            MTag[] constraints = cSet.getChildTags("id", id);
            if (constraints != null && constraints.length > 0 && (value2 = constraints[0].getAttributeValue(attribute)) != null) {
                return value2;
            }
            String derivedStr = cSet.getAttributeValue("deriveConstraintsFrom");
            if (derivedStr != null && (derivedTag = cSet.getParent().getChildTags("ConstraintSet", "id", derivedStr)) != null && derivedTag.length > 0) {
                return this.findAttribute(layout2, derivedTag[0], id, attribute);
            }
        }
        if (layout2 == null) {
            return null;
        }
        MTag[] view = layout2.getChildTags("id", id);
        if (view == null || view.length == 0) {
            return null;
        }
        return view[0].getAttributeValue(attribute);
    }

    public MTag[] getViewNotInConstraintSet(MTag constraintSet) {
        HashSet<String> found = new HashSet<String>();
        MTag[] sets = constraintSet.getChildTags("Constraint");
        String derived = constraintSet.getAttributeValue("deriveConstraintsFrom");
        for (int i2 = 0; i2 < sets.length; ++i2) {
            MTag constraint = sets[i2];
            String id = Utils.stripID(constraint.getAttributeValue("id"));
            found.add(id);
        }
        ArrayList<MTag> tags2 = new ArrayList<MTag>();
        MTag[] allViews = this.layout.getChildTags();
        for (int j = 0; j < allViews.length; ++j) {
            Object[] row = new Object[4];
            MTag view = allViews[j];
            String layoutId = view.getAttributeValue("id");
            if (layoutId == null) {
                row[0] = view.getTagName().substring(1 + view.getTagName().lastIndexOf("/"));
                continue;
            }
            if (found.contains(layoutId = Utils.stripID(layoutId))) continue;
            tags2.add(view);
        }
        return tags2.toArray(new MTag[0]);
    }

    public MTag findTag(String type, String id) {
        if (this.mSelectedType == null || id == null) {
            return null;
        }
        if (this.mSelected == null || this.mSelected.length == 0) {
            return null;
        }
        MTag tag = this.mSelected[0];
        switch (this.mSelectedType) {
            case TRANSITION: 
            case KEY_FRAME_GROUP: {
                break;
            }
            case CONSTRAINT: {
                tag = tag.getParent();
            }
            case CONSTRAINT_SET: {
                MTag[] look = tag.getChildTags("id", id);
                if (look != null && look.length > 0) {
                    return look[0];
                }
                MTag[] layoutView = this.layout.getChildTags();
                for (int i2 = 0; i2 < layoutView.length; ++i2) {
                    MTag mTag = layoutView[i2];
                    String viewId = Utils.stripID(mTag.getAttributeValue("id"));
                    if (viewId == null || !id.equals(viewId)) continue;
                    return mTag;
                }
                break;
            }
        }
        return null;
    }

    public void setSelectedViewIDs(List<String> ids2) {
        this.mSelectedViewIDs = ids2.toArray(EMPTY_STRING_ARRAY);
    }

    public void setSelectedViewIDs(String[] ids2) {
        this.mSelectedViewIDs = ids2;
    }

    public String[] getSelectedViewIDs() {
        return this.mSelectedViewIDs;
    }
}

