/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.targets;

import com.android.SdkConstants;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.uibuilder.api.actions.ToggleAutoConnectAction;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainChecker;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutDragTarget
extends DragBaseTarget
implements MultiComponentTarget {
    protected int myOffsetX;
    protected int myOffsetY;
    private static final int ourSnapMarginDistance = 4;
    private DropHandler myDropHandler;

    @Override
    public void setComponent(@NotNull SceneComponent component3) {
        if (component3 == null) {
            MotionLayoutDragTarget.$$$reportNull$$$0(0);
        }
        super.setComponent(component3);
        this.myDropHandler = new DropHandler(this.myComponent);
    }

    @Override
    protected boolean isAutoConnectionEnabled() {
        return !SdkConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEqualsIgnoreCase(this.myComponent.getNlComponent().getTagName()) && ToggleAutoConnectAction.isAutoconnectOn();
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        if (attributes == null) {
            MotionLayoutDragTarget.$$$reportNull$$$0(1);
        }
        SceneComponent constraintLayoutComponent = this.myComponent.getParent();
        assert (constraintLayoutComponent != null);
        this.myDropHandler.updateAttributes(attributes, constraintLayoutComponent, x, y);
    }

    @Override
    public void fillComponentModification(ComponentModification modification) {
        MotionUtils.fillComponentModification(modification);
    }

    @Override
    public void applyComponentModification(ComponentModification modification) {
        MotionUtils.apply(modification);
    }

    @Override
    public void commitComponentModification(ComponentModification modification) {
        MotionUtils.commit(modification);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/editor/targets/MotionLayoutDragTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DropHandler {
        @NotNull
        private final SceneComponent myComponent;
        private final ChainChecker myChainChecker;

        public DropHandler(@NotNull SceneComponent component3) {
            if (component3 == null) {
                DropHandler.$$$reportNull$$$0(0);
            }
            this.myChainChecker = new ChainChecker();
            this.myComponent = component3;
        }

        public void updateAttributes(@NotNull NlAttributesHolder attributes, @NotNull SceneComponent parent, int x, int y) {
            int dx;
            MotionLayoutComponentHelper motionLayout;
            if (attributes == null) {
                DropHandler.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                DropHandler.$$$reportNull$$$0(2);
            }
            if ((motionLayout = MotionLayoutComponentHelper.create(parent.getNlComponent())).isInTransition()) {
                return;
            }
            NlAttributesHolder componentAttributes = attributes;
            this.myComponent.setPosition(x, y);
            SceneComponent targetStartComponent = this.getTargetComponent(componentAttributes, parent, ConstraintComponentUtilities.ourStartAttributes);
            SceneComponent targetEndComponent = this.getTargetComponent(componentAttributes, parent, ConstraintComponentUtilities.ourEndAttributes);
            SceneComponent targetLeftComponent = this.getTargetComponent(componentAttributes, parent, ConstraintComponentUtilities.ourLeftAttributes);
            SceneComponent targetRightComponent = this.getTargetComponent(componentAttributes, parent, ConstraintComponentUtilities.ourRightAttributes);
            String targetStartMargin = "layout_marginStart";
            String targetEndMargin = "layout_marginEnd";
            boolean useStartEnd = this.myComponent.useRtlAttributes();
            boolean isInRTL = this.myComponent.getScene().isInRTL();
            int dx1 = 0;
            int dx2 = 0;
            if (targetStartComponent == null && targetEndComponent == null) {
                targetStartComponent = targetLeftComponent;
                targetEndComponent = targetRightComponent;
                targetStartMargin = "layout_marginLeft";
                targetEndMargin = "layout_marginRight";
                useStartEnd = false;
                isInRTL = false;
                if (targetStartComponent != null) {
                    dx1 = this.getLeftTargetOrigin(componentAttributes, targetStartComponent) + this.getMarginValue(componentAttributes, targetStartMargin);
                }
                if (targetEndComponent != null) {
                    dx2 = this.getRightTargetOrigin(componentAttributes, targetEndComponent) - this.getMarginValue(componentAttributes, targetEndMargin);
                }
            } else {
                int margin;
                if (targetStartComponent != null) {
                    dx1 = this.getStartTargetOrigin(componentAttributes, targetStartComponent, isInRTL);
                    margin = this.getMarginValue(componentAttributes, targetStartMargin);
                    dx1 = isInRTL ? (dx1 -= margin) : (dx1 += margin);
                }
                if (targetEndComponent != null) {
                    dx2 = this.getEndTargetOrigin(componentAttributes, targetEndComponent, isInRTL);
                    margin = this.getMarginValue(componentAttributes, targetEndMargin);
                    dx2 = isInRTL ? (dx2 += margin) : (dx2 -= margin);
                }
            }
            this.myChainChecker.checkIsInChain(this.myComponent);
            if (targetStartComponent != null && targetEndComponent != null) {
                if (!this.myChainChecker.isInHorizontalChain()) {
                    float dw = dx2 - dx1 - this.myComponent.getDrawWidth();
                    float bias = (float)(x - dx1) / dw;
                    if (useStartEnd && isInRTL) {
                        dw = dx1 - dx2 - this.myComponent.getDrawWidth();
                        bias = (dw - (float)(x - dx2)) / dw;
                    }
                    if (bias < 0.0f) {
                        bias = 0.0f;
                    }
                    if (bias > 1.0f) {
                        bias = 1.0f;
                    }
                    String biasValue = null;
                    if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                        biasValue = null;
                    }
                    attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasValue);
                }
            } else if (targetStartComponent != null) {
                dx = x - this.getLeftTargetOrigin(componentAttributes, targetStartComponent);
                if (useStartEnd) {
                    dx = isInRTL ? this.getStartTargetOrigin(componentAttributes, targetStartComponent, true) - (x + this.myComponent.getDrawWidth()) : x - this.getStartTargetOrigin(componentAttributes, targetStartComponent, false);
                }
                this.applyMargin(attributes, targetStartMargin, dx);
            } else if (targetEndComponent != null) {
                dx = this.getRightTargetOrigin(componentAttributes, targetEndComponent) - (x + this.myComponent.getDrawWidth());
                if (useStartEnd) {
                    dx = isInRTL ? x - this.getEndTargetOrigin(componentAttributes, targetEndComponent, true) : this.getEndTargetOrigin(componentAttributes, targetEndComponent, false) - (x + this.myComponent.getDrawWidth());
                }
                this.applyMargin(attributes, targetEndMargin, dx);
            } else {
                String positionX = String.format(Locale.US, "%ddp", x - parent.getDrawX());
                attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
            }
            SceneComponent targetTopComponent = this.getTargetComponent(componentAttributes, parent, ConstraintComponentUtilities.ourTopAttributes);
            SceneComponent targetBottomComponent = this.getTargetComponent(componentAttributes, parent, ConstraintComponentUtilities.ourBottomAttributes);
            if (targetTopComponent != null && targetBottomComponent != null) {
                if (!this.myChainChecker.isInVerticalChain()) {
                    int dy2;
                    float dh;
                    int dy1 = this.getTopTargetOrigin(componentAttributes, targetTopComponent) + this.getMarginValue(componentAttributes, "layout_marginTop");
                    float bias = (float)(y - dy1) / (dh = (float)((dy2 = this.getBottomTargetOrigin(componentAttributes, targetBottomComponent) - this.getMarginValue(componentAttributes, "layout_marginBottom")) - dy1 - this.myComponent.getDrawHeight()));
                    if (bias < 0.0f) {
                        bias = 0.0f;
                    }
                    if (bias > 1.0f) {
                        bias = 1.0f;
                    }
                    String biasValue = null;
                    if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                        biasValue = null;
                    }
                    attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasValue);
                }
            } else if (targetTopComponent != null) {
                int dy = y - this.getTopTargetOrigin(componentAttributes, targetTopComponent);
                this.applyMargin(attributes, "layout_marginTop", dy);
            } else if (targetBottomComponent != null) {
                int dy = this.getBottomTargetOrigin(componentAttributes, targetBottomComponent) - (y + this.myComponent.getDrawHeight());
                this.applyMargin(attributes, "layout_marginBottom", dy);
            } else {
                String positionY = String.format(Locale.US, "%ddp", y - parent.getDrawY());
                attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
            }
            ConstraintComponentUtilities.cleanup(componentAttributes, this.myComponent.getNlComponent());
        }

        @Nullable
        private SceneComponent getTargetComponent(NlAttributesHolder holder, @NotNull SceneComponent parent, @NotNull ArrayList<String> attributes) {
            if (parent == null) {
                DropHandler.$$$reportNull$$$0(3);
            }
            if (attributes == null) {
                DropHandler.$$$reportNull$$$0(4);
            }
            int count = attributes.size();
            for (int i2 = 0; i2 < count; ++i2) {
                String target = holder.getAttribute("http://schemas.android.com/apk/res-auto", attributes.get(i2));
                if (target == null) continue;
                if (target.equalsIgnoreCase("parent")) {
                    return parent;
                }
                if ((target = NlComponent.extractId(target)) == null) continue;
                return this.myComponent.getScene().getSceneComponent(target);
            }
            return null;
        }

        private void applyMargin(NlAttributesHolder attributes, String attribute, int currentValue) {
            currentValue = Math.max(0, currentValue);
            currentValue = currentValue / 4 * 4;
            String marginString = attributes.getAttribute("http://schemas.android.com/apk/res-auto", attribute);
            int marginValue = -1;
            if (marginString != null) {
                marginValue = this.getMarginValue(attributes, attribute);
            }
            if (currentValue == 0) {
                attributes.removeAttribute("http://schemas.android.com/apk/res-auto", attribute);
                if ("layout_marginEnd".equals(attribute)) {
                    attributes.removeAttribute("http://schemas.android.com/apk/res-auto", "layout_marginRight");
                } else if ("layout_marginStart".equals(attribute)) {
                    attributes.removeAttribute("http://schemas.android.com/apk/res-auto", "layout_marginLeft");
                }
            } else if (marginValue != -1 && marginValue == currentValue) {
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", attribute, marginString);
                if ("layout_marginEnd".equals(attribute)) {
                    attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_marginRight", marginString);
                } else if ("layout_marginStart".equals(attribute)) {
                    attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_marginLeft", marginString);
                }
            } else {
                String marginY = String.format(Locale.US, "%ddp", currentValue);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", attribute, marginY);
                if ("layout_marginEnd".equals(attribute)) {
                    attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_marginRight", marginY);
                } else if ("layout_marginStart".equals(attribute)) {
                    attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_marginLeft", marginY);
                }
            }
        }

        private int getStartTargetOrigin(NlAttributesHolder attributes, @NotNull SceneComponent target, boolean isInRtl) {
            if (target == null) {
                DropHandler.$$$reportNull$$$0(5);
            }
            int origin = target.getDrawX();
            if (isInRtl) {
                origin += target.getDrawWidth();
            }
            if (attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toEndOf") != null) {
                origin = isInRtl ? target.getDrawX() : (origin += target.getDrawWidth());
            }
            return origin;
        }

        private int getEndTargetOrigin(NlAttributesHolder attributes, @NotNull SceneComponent target, boolean isInRtl) {
            if (target == null) {
                DropHandler.$$$reportNull$$$0(6);
            }
            int origin = target.getDrawX();
            if (isInRtl) {
                origin += target.getDrawWidth();
            }
            if (attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf") != null) {
                origin = isInRtl ? target.getDrawX() : (origin += target.getDrawWidth());
            }
            return origin;
        }

        private int getLeftTargetOrigin(NlAttributesHolder attributes, @NotNull SceneComponent target) {
            if (target == null) {
                DropHandler.$$$reportNull$$$0(7);
            }
            int origin = target.getDrawX();
            if (attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf") != null) {
                origin += target.getDrawWidth();
            }
            return origin;
        }

        private int getRightTargetOrigin(NlAttributesHolder attributes, @NotNull SceneComponent target) {
            if (target == null) {
                DropHandler.$$$reportNull$$$0(8);
            }
            int origin = target.getDrawX();
            if (attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf") != null) {
                origin += target.getDrawWidth();
            }
            return origin;
        }

        protected int getTopTargetOrigin(NlAttributesHolder attributes, @NotNull SceneComponent target) {
            if (target == null) {
                DropHandler.$$$reportNull$$$0(9);
            }
            int origin = target.getDrawY();
            if (attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf") != null) {
                origin += target.getDrawHeight();
            }
            return origin;
        }

        private int getBottomTargetOrigin(NlAttributesHolder attributes, @NotNull SceneComponent target) {
            if (target == null) {
                DropHandler.$$$reportNull$$$0(10);
            }
            int origin = target.getDrawY();
            if (attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf") != null) {
                origin += target.getDrawHeight();
            }
            return origin;
        }

        private int getMarginValue(NlAttributesHolder attributes, String attribute) {
            NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
            String margin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", attribute);
            return ConstraintComponentUtilities.getDpValue(nlComponent, margin);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/motion/editor/targets/MotionLayoutDragTarget$DropHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateAttributes";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTargetComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStartTargetOrigin";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEndTargetOrigin";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLeftTargetOrigin";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRightTargetOrigin";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTopTargetOrigin";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBottomTargetOrigin";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

