/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTagWriter;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.Track;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class MotionSceneTag
implements MTag {
    private static final boolean DEBUG = false;
    XmlTag myXmlTag;
    MotionSceneTag mParent;
    ArrayList<MTag> myChildren = new ArrayList();
    HashMap<String, MTag.Attribute> mAttrList = new HashMap();

    public MotionSceneTag(XmlTag tag, MotionSceneTag parent) {
        this.myXmlTag = tag;
        this.mParent = parent;
        if (tag == null) {
            return;
        }
        for (XmlTag xmlTag : tag.getSubTags()) {
            this.myChildren.add(new MotionSceneTag(xmlTag, this));
        }
        for (XmlTag xmlTag : tag.getAttributes()) {
            MTag.Attribute a = new MTag.Attribute();
            a.mAttribute = xmlTag.getName();
            a.mAttribute = a.mAttribute.substring(a.mAttribute.indexOf(":") + 1);
            a.mNamespace = xmlTag.getNamespacePrefix();
            a.mValue = xmlTag.getValue();
            this.mAttrList.put(a.mAttribute, a);
        }
    }

    @Override
    public String getTagName() {
        if (this.myXmlTag == null) {
            return null;
        }
        return this.myXmlTag.getName();
    }

    @Override
    public ArrayList<MTag> getChildren() {
        return this.myChildren;
    }

    @Override
    public HashMap<String, MTag.Attribute> getAttrList() {
        return this.mAttrList;
    }

    @Override
    public MTag[] getChildTags() {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.myChildren) {
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String type) {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.myChildren) {
            if (!child.getTagName().equals(type)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String attribute, String value2) {
        if (value2 == null) {
            return null;
        }
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.myChildren) {
            String childValue = child.getAttributeValue(attribute);
            if (childValue == null || !childValue.endsWith(value2)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag[] getChildTags(String type, String attribute, String value2) {
        ArrayList<MTag> filter2 = new ArrayList<MTag>();
        for (MTag child : this.myChildren) {
            String childValue;
            if (!child.getTagName().equals(type) || (childValue = child.getAttributeValue(attribute)) == null || !childValue.endsWith(value2)) continue;
            filter2.add(child);
        }
        return filter2.toArray(new MTag[0]);
    }

    @Override
    public MTag getChildTagWithTreeId(String type, String treeId) {
        if (treeId == null) {
            return null;
        }
        for (MTag child : this.myChildren) {
            String childValue;
            if (!child.getTagName().equals(type) || (childValue = child.getTreeId()) == null || !childValue.equals(treeId)) continue;
            return child;
        }
        return null;
    }

    @Override
    public String getTreeId() {
        switch (this.getTagName()) {
            case "ConstraintSet": {
                return Utils.stripID(this.getAttributeValue("id"));
            }
            case "Transition": {
                return String.format("%1$s|%2$s|%3$s", Utils.stripID(this.getAttributeValue("id")), Utils.stripID(this.getAttributeValue("constraintSetStart")), Utils.stripID(this.getAttributeValue("constraintSetEnd")));
            }
            case "KeyAttribute": 
            case "KeyPosition": 
            case "KeyCycle": 
            case "KeyTimeCycle": 
            case "KeyTrigger": {
                return this.computeKeyFrameTreeId();
            }
        }
        return null;
    }

    private String computeKeyFrameTreeId() {
        String tagName = this.getTagName();
        String target = this.getAttributeValue("motionTarget");
        String pos = this.getAttributeValue("framePosition");
        StringBuilder key = new StringBuilder();
        key.append(tagName);
        if (pos != null) {
            key.append(",").append(pos);
        }
        if (target != null) {
            if (target.startsWith("@")) {
                key.append("|Id:").append(Utils.stripID(target));
            } else {
                key.append("|Tag:").append(target);
            }
        }
        for (String keyAttribute : MotionSceneAttrs.KeyAttributeOptions) {
            if (this.getAttributeValue(keyAttribute) == null) continue;
            key.append(",").append(keyAttribute);
        }
        return key.toString();
    }

    @Override
    public String getAttributeValue(String attribute) {
        for (MTag.Attribute value2 : this.mAttrList.values()) {
            if (!value2.mAttribute.equals(attribute)) continue;
            return value2.mValue;
        }
        return null;
    }

    @Override
    public void print(String space) {
        System.out.println("\n" + space + "<" + this.getTagName() + ">");
        for (XmlAttribute value2 : this.myXmlTag.getAttributes()) {
            System.out.println(space + "   " + value2.getName() + "=\"" + value2.getValue() + "\"");
        }
        for (MTag child : this.myChildren) {
            child.print(space + "   ");
        }
        System.out.println(space + "</" + this.getTagName() + ">");
    }

    public XmlTag getXmlTag() {
        return this.myXmlTag != null && this.myXmlTag.isValid() ? this.myXmlTag : null;
    }

    @Override
    public String toXmlString() {
        return this.toFormalXmlString("");
    }

    @Override
    public String toFormalXmlString(String space) {
        Object ret = "";
        if (space == null) {
            ret = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
            space = "";
        }
        ret = (String)ret + "\n" + space + "<" + this.getTagName();
        for (XmlAttribute value2 : this.myXmlTag.getAttributes()) {
            ret = (String)ret + "\n" + space + "   " + value2.getNamespacePrefix() + ":" + value2.getName() + "=\"" + value2.getValue() + "\"";
            ret = (String)ret + " getValue() = " + value2.getValue();
            ret = (String)ret + " getNamespacePrefix() = " + value2.getNamespacePrefix();
            ret = (String)ret + " getNamespace() = " + value2.getNamespace();
            ret = (String)ret + " getName() = " + value2.getName();
            ret = (String)ret + " getValue() = " + value2.getLocalName();
            ret = (String)ret + " getValue() = " + value2.getDisplayValue();
        }
        ret = (String)ret + " >\n";
        for (MTag child : this.myChildren) {
            ret = (String)ret + child.toFormalXmlString(space + "  ");
        }
        ret = (String)ret + space + "</" + this.getTagName() + ">\n";
        return ret;
    }

    @Override
    public void printFormal(String space, PrintStream out) {
        if (space == null) {
            out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            space = "";
        }
        out.print("\n" + space + "<" + this.getTagName());
        for (XmlAttribute value2 : this.myXmlTag.getAttributes()) {
            out.print("\n" + space + "   " + value2.getName() + "=\"" + value2.getValue() + "\"");
            String string = "  ";
        }
        out.println(" >");
        for (MTag child : this.myChildren) {
            child.printFormal(space + "  ", out);
        }
        out.println(space + "</" + this.getTagName() + ">");
    }

    @Override
    public MTag getParent() {
        return this.mParent;
    }

    private static Root getRoot(MotionSceneTag tag) {
        while (!(tag instanceof Root)) {
            tag = tag.mParent;
            if (tag != null) continue;
            return null;
        }
        return (Root)tag;
    }

    @Override
    public void setClientData(String type, Object motionAttributes) {
    }

    @Override
    public Object getClientData(String type) {
        return null;
    }

    @Override
    public MTag.TagWriter getChildTagWriter(String name) {
        return new MotionSceneTagWriter(this, name);
    }

    @Override
    public MotionSceneTagWriter getTagWriter() {
        return new MotionSceneTagWriter(this);
    }

    public static Root parse(NlComponent motionLayout, Project project, VirtualFile virtualFile, XmlFile file, Track track2) {
        Root root2 = MotionSceneTag.parse(motionLayout, project, virtualFile, file);
        root2.myTrack = track2;
        return root2;
    }

    public static Root parse(NlComponent motionLayout, Project project, VirtualFile virtualFile, XmlFile file) {
        NlModel model2 = motionLayout.getModel();
        return new Root(file.getRootTag(), project, virtualFile, file, model2);
    }

    public static class Root
    extends MotionSceneTag {
        Project mProject;
        VirtualFile mVirtualFile;
        XmlFile mXmlFile;
        NlModel mModel;
        Track myTrack = null;

        public Root(XmlTag tag, Project project, VirtualFile virtualFile, XmlFile file, NlModel model2) {
            super(tag, null);
            this.mProject = project;
            this.mVirtualFile = virtualFile;
            this.mXmlFile = file;
            this.mModel = model2;
        }
    }
}

