/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCommand;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Arrays;

public class DrawMotionPath
implements DrawCommand {
    private final float[] mKeyFramesPos;
    private final int[] mKeyFramesType;
    private float[] mPath;
    private GeneralPath ourPath = new GeneralPath();
    private AffineTransform at = new AffineTransform();
    private static BasicStroke ourBasicStroke = new BasicStroke(1.0f);
    private static BasicStroke ourShadowStroke = new BasicStroke(1.0f);
    private int mViewX;
    private int mViewY;
    private int mViewWidth;
    private int mViewHeight;
    int[] xpath = new int[4];
    int[] ypath = new int[4];
    boolean mSelected = false;

    DrawMotionPath(boolean selected, float[] path2, int pathSize, int[] keyFramesType, float[] keyFramePos, int keyFramesSize, int vx, int vy, int vw, int vh) {
        this.mPath = Arrays.copyOf(path2, pathSize);
        this.ourPath.reset();
        this.mViewX = vx;
        this.mViewY = vy;
        this.mViewWidth = vw;
        this.mViewHeight = vh;
        this.mSelected = selected;
        for (int i2 = 0; i2 < pathSize; i2 += 2) {
            float x = this.mPath[i2];
            float y = this.mPath[i2 + 1];
            if ((i2 & 2) == 0) {
                this.ourPath.moveTo(x, y);
                continue;
            }
            this.ourPath.lineTo(x, y);
        }
        if (keyFramesSize > 0) {
            this.mKeyFramesPos = Arrays.copyOf(keyFramePos, keyFramesSize * 2);
            this.mKeyFramesType = Arrays.copyOf(keyFramesType, keyFramesSize);
        } else {
            this.mKeyFramesPos = null;
            this.mKeyFramesType = null;
        }
    }

    @Override
    public int getLevel() {
        return 10;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        double scale = sceneContext.getScale();
        double vx = sceneContext.getSwingXDip(this.mViewX);
        double vy = sceneContext.getSwingYDip(this.mViewY);
        Graphics2D g2 = (Graphics2D)g.create();
        this.at.setToIdentity();
        this.at.translate(vx, vy);
        this.at.scale(scale, scale);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float lineWidth = 2.0f / (float)scale;
        g2.transform(this.at);
        if ((double)Math.abs(ourShadowStroke.getLineWidth() - lineWidth) > 0.01) {
            ourShadowStroke = new BasicStroke(lineWidth);
            ourBasicStroke = new BasicStroke(lineWidth / 2.0f);
        }
        g2.setStroke(ourShadowStroke);
        g2.setColor(Color.BLACK);
        g2.draw(this.ourPath);
        int diamond = (int)(1.0 + 5.0 / scale);
        g2.setStroke(ourBasicStroke);
        g2.setColor(Color.white);
        g2.draw(this.ourPath);
        if (this.mKeyFramesPos != null && this.mSelected) {
            for (int i2 = 0; i2 < this.mKeyFramesPos.length; i2 += 2) {
                int type = this.mKeyFramesType[i2 / 2];
                if (type / 1000 != 2) continue;
                int posx = (int)this.mKeyFramesPos[i2];
                int posy = (int)this.mKeyFramesPos[i2 + 1];
                this.xpath[0] = posx;
                this.xpath[1] = posx + diamond + 1;
                this.xpath[2] = posx;
                this.xpath[3] = posx - diamond - 1;
                this.ypath[0] = posy - diamond - 1;
                this.ypath[1] = posy;
                this.ypath[2] = posy + diamond + 1;
                this.ypath[3] = posy;
                g2.setColor(Color.BLACK);
                g2.fillPolygon(this.xpath, this.ypath, 4);
                this.xpath[1] = this.xpath[1] - 1;
                this.ypath[2] = this.ypath[2] - 1;
                this.xpath[3] = this.xpath[3] + 1;
                this.ypath[0] = this.ypath[0] + 1;
                g2.setColor(Color.WHITE);
                g2.fillPolygon(this.xpath, this.ypath, 4);
            }
        }
    }

    @Override
    public String serialize() {
        return null;
    }

    public static void buildDisplayList(boolean selected, DisplayList list, float[] path2, int pathSize, int[] keyFrameType, float[] keyFramePos, int keyFrameSize, int x, int y, int w, int h) {
        list.add(new DrawMotionPath(selected, path2, pathSize, keyFrameType, keyFramePos, keyFrameSize, x, y, w, h));
    }
}

