/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearDragTarget;
import com.android.tools.idea.uibuilder.handlers.linear.targets.LinearSeparatorTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinearDragHandler
extends DragHandler {
    private final SceneComponent myComponent;
    private final LinearDragTarget myDragTarget;
    private static final List<Target> ourEmptyTargetList = ImmutableList.of();

    public LinearDragHandler(@NotNull ViewEditor editor2, @NotNull LinearLayoutHandler handler, @NotNull SceneComponent layout2, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor2 == null) {
            LinearDragHandler.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            LinearDragHandler.$$$reportNull$$$0(1);
        }
        if (layout2 == null) {
            LinearDragHandler.$$$reportNull$$$0(2);
        }
        if (components == null) {
            LinearDragHandler.$$$reportNull$$$0(3);
        }
        if (type == null) {
            LinearDragHandler.$$$reportNull$$$0(4);
        }
        super(editor2, handler, layout2, components, type);
        assert (!components.isEmpty());
        NlComponent dragged = components.get(0);
        LinearDragTarget dragTarget = null;
        SceneComponent component3 = layout2.getScene().getSceneComponent(dragged);
        if (component3 != null) {
            dragTarget = LinearDragHandler.findExistingDragTarget(component3);
        } else {
            component3 = new TemporarySceneComponent(layout2.getScene(), components.get(0));
            component3.setSize(editor2.pxToDp(NlComponentHelperKt.getW(dragged)), editor2.pxToDp(NlComponentHelperKt.getH(dragged)));
        }
        if (dragTarget == null) {
            dragTarget = new LinearDragTarget(handler, type.equals((Object)DragType.CREATE));
        }
        this.myDragTarget = dragTarget;
        this.myComponent = component3;
        component3.setTargetProvider(sceneComponent -> ImmutableList.of((Object)this.myDragTarget));
        component3.updateTargets();
        this.myComponent.setDrawState(SceneComponent.DrawState.DRAG);
        layout2.addChild(this.myComponent);
    }

    @Nullable
    private static LinearDragTarget findExistingDragTarget(@NotNull SceneComponent component3) {
        if (component3 == null) {
            LinearDragHandler.$$$reportNull$$$0(5);
        }
        for (Target target : component3.getTargets()) {
            if (!(target instanceof LinearDragTarget)) continue;
            return (LinearDragTarget)target;
        }
        return null;
    }

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        this.myDragTarget.mouseDown(x, y);
    }

    @Override
    public void cancel() {
        Scene scene = this.editor.getScene();
        scene.removeComponent(this.myComponent);
        this.myDragTarget.mouseCancel();
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String result2 = super.update(x, y, modifiers);
        int dx = x + this.startX - this.myComponent.getDrawWidth() / 2;
        int dy = y + this.startY - this.myComponent.getDrawHeight() / 2;
        this.myDragTarget.mouseDrag(dx, dy, ourEmptyTargetList);
        return result2;
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            LinearDragHandler.$$$reportNull$$$0(6);
        }
        Scene scene = this.editor.getScene();
        if (this.myComponent != null) {
            this.myDragTarget.mouseCancel();
            scene.removeComponent(this.myComponent);
            LinearSeparatorTarget closest = this.myDragTarget.getClosest();
            int index = closest != null ? closest.getInsertionIndex() : -1;
            this.editor.insertChildren(this.layout.getNlComponent(), this.components, index, insertType);
            scene.requestLayoutIfNeeded();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/linear/LinearDragHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingDragTarget";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

