/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.coordinator;

import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorSnapTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J&\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0004H\u0016J\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001eJ&\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0004H\u0016J\b\u0010 \u001a\u00020\u0015H\u0002J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000fH\u0016J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'H\u0002J \u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0014J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorDragTarget;", "Lcom/android/tools/idea/common/scene/target/DragBaseTarget;", "()V", "myAttributes", "", "", "myOriginalAttributes", "Ljava/util/HashMap;", "mySnapTarget", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorSnapTarget;", "getPreferenceLevel", "", "layout", "", "context", "Lcom/android/tools/idea/common/scene/SceneContext;", "left", "top", "right", "bottom", "mouseCancel", "", "mouseDown", "x", "y", "mouseDrag", "closestTarget", "Lcom/android/tools/idea/common/scene/target/Target;", "mouseRelease", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "closestTargets", "rememberAttributes", "render", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "sceneContext", "restoreAttributes", "transaction", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "updateAttributes", "attributes", "updateInteractionState", "interactionState", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorLayoutHandler$InteractionState;", "intellij.android.designer"})
public final class CoordinatorDragTarget
extends DragBaseTarget {
    private CoordinatorSnapTarget mySnapTarget;
    private List<String> myAttributes = CollectionsKt.listOf((Object[])new String[]{"layout_anchor", "layout_anchorGravity"});
    private HashMap<String, String> myOriginalAttributes = new HashMap();

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int left2, int top, int right2, int bottom2) {
        int d;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int minWidth = 16;
        int minHeight = 16;
        int l = left2;
        int t = top;
        int r = right2;
        int b = bottom2;
        if (r - l < minWidth) {
            d = (minWidth - (r - l)) / 2;
            l -= d;
            r += d;
        }
        if (b - t < minHeight) {
            d = (minHeight - (b - t)) / 2;
            t -= d;
            b += d;
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
    }

    private final void rememberAttributes() {
        this.myOriginalAttributes.clear();
        for (String attribute : this.myAttributes) {
            SceneComponent sceneComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"myComponent");
            String value2 = sceneComponent.getNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", attribute);
            if (value2 == null) continue;
            ((Map)this.myOriginalAttributes).put(attribute, value2);
        }
    }

    private final void restoreAttributes(NlAttributesHolder transaction) {
        for (String attribute : this.myAttributes) {
            String value2 = this.myOriginalAttributes.get(attribute);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", attribute, value2);
        }
    }

    private final void updateInteractionState(CoordinatorLayoutHandler.InteractionState interactionState) {
        block2: {
            SceneComponent sceneComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"myComponent");
            Object object = sceneComponent.getParent();
            if (object == null || (object = ((SceneComponent)object).getNlComponent()) == null || (object = NlComponentHelperKt.getViewHandler((NlComponent)object)) == null) {
                return;
            }
            Object handler = object;
            if (!(handler instanceof CoordinatorLayoutHandler)) break block2;
            ((CoordinatorLayoutHandler)handler).setInteractionState(interactionState);
            SceneComponent sceneComponent2 = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)sceneComponent2, (String)"myComponent");
            SceneComponent sceneComponent3 = sceneComponent2.getParent();
            if (sceneComponent3 != null) {
                sceneComponent3.updateTargets();
            }
        }
    }

    @Override
    public void mouseDown(int x, int y) {
        super.mouseDown(x, y);
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"myComponent");
        if (sceneComponent.getParent() == null) {
            return;
        }
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.DRAGGING);
        this.rememberAttributes();
    }

    public void mouseDrag(int x, int y, @NotNull List<? extends Target> closestTarget) {
        Object v2;
        block4: {
            Intrinsics.checkNotNullParameter(closestTarget, (String)"closestTarget");
            SceneComponent sceneComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"myComponent");
            if (sceneComponent.getParent() == null) {
                return;
            }
            CoordinatorSnapTarget coordinatorSnapTarget = this.mySnapTarget;
            if (coordinatorSnapTarget != null) {
                coordinatorSnapTarget.setMouseHovered(false);
            }
            this.mySnapTarget = null;
            Iterable $this$firstOrNull$iv = closestTarget;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Target it = (Target)element$iv;
                boolean bl = false;
                if (!(it instanceof CoordinatorSnapTarget)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Target snapTarget = v2;
        if (snapTarget instanceof CoordinatorSnapTarget) {
            this.mySnapTarget = (CoordinatorSnapTarget)snapTarget;
            snapTarget.setMouseHovered(true);
        }
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"myComponent");
        sceneComponent.setDragging(true);
        this.myComponent.setPosition(x - this.myOffsetX, y - this.myOffsetY);
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkNotNullExpressionValue((Object)sceneComponent2, (String)"myComponent");
        sceneComponent2.getScene().repaint();
        this.myChangedComponent = true;
    }

    public void mouseRelease(int x, int y, @NotNull List<? extends Target> closestTargets) {
        Intrinsics.checkNotNullParameter(closestTargets, (String)"closestTargets");
        super.mouseRelease(x, y, closestTargets);
        if (this.myChangedComponent) {
            SceneComponent sceneComponent = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"myComponent");
            sceneComponent.getScene().markNeedsLayout(1);
        }
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.NORMAL);
    }

    @Override
    protected void updateAttributes(@NotNull NlAttributesHolder attributes, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (this.mySnapTarget != null) {
            CoordinatorSnapTarget coordinatorSnapTarget = this.mySnapTarget;
            Intrinsics.checkNotNull((Object)coordinatorSnapTarget);
            coordinatorSnapTarget.snap(attributes);
        } else {
            this.restoreAttributes(attributes);
        }
    }

    @Override
    public void mouseCancel() {
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.NORMAL);
        super.mouseCancel();
    }

    public final void mouseRelease(int x, int y, @NotNull NlComponent component3) {
        Intrinsics.checkNotNullParameter((Object)component3, (String)"component");
        SceneComponent sceneComponent = this.myComponent;
        Intrinsics.checkNotNullExpressionValue((Object)sceneComponent, (String)"myComponent");
        sceneComponent.setDragging(false);
        SceneComponent sceneComponent2 = this.myComponent;
        Intrinsics.checkNotNullExpressionValue((Object)sceneComponent2, (String)"myComponent");
        if (sceneComponent2.getParent() != null) {
            AttributesTransaction attributesTransaction = component3.startAttributeTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)attributesTransaction, (String)"component.startAttributeTransaction()");
            AttributesTransaction attributes = attributesTransaction;
            this.updateAttributes(attributes, x, y);
            attributes.apply();
            if (Math.abs(x - this.myFirstMouseX) > 1 || Math.abs(y - this.myFirstMouseY) > 1) {
                NlWriteCommandActionUtil.run(component3, "Dragged " + StringUtil.getShortName((String)component3.getTagName()), new Runnable(attributes){
                    final /* synthetic */ AttributesTransaction $attributes;

                    public final void run() {
                        this.$attributes.commit();
                    }
                    {
                        this.$attributes = attributesTransaction;
                    }
                });
            }
        }
        if (this.myChangedComponent) {
            SceneComponent sceneComponent3 = this.myComponent;
            Intrinsics.checkNotNullExpressionValue((Object)sceneComponent3, (String)"myComponent");
            sceneComponent3.getScene().markNeedsLayout(1);
        }
        this.updateInteractionState(CoordinatorLayoutHandler.InteractionState.NORMAL);
    }
}

