/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.WidgetDecorator;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class WebViewWidget
extends WidgetDecorator {
    protected int mPadding = 5;
    private Font mFont = new Font("Helvetica", 0, 12);

    public WebViewWidget(ConstraintWidget widget) {
        super(widget);
        this.wrapContent();
    }

    protected void wrapContent() {
        this.mWidget.setMinWidth(100);
        this.mWidget.setMinHeight(100);
        int tw = this.mWidget.getMinWidth();
        int th = this.mWidget.getMinHeight();
        if (this.mWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            this.mWidget.setWidth(tw);
        }
        if (this.mWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            this.mWidget.setHeight(th);
        }
        if (this.mWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED && this.mWidget.getWidth() <= this.mWidget.getMinWidth()) {
            this.mWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        }
        if (this.mWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED && this.mWidget.getHeight() <= this.mWidget.getMinHeight()) {
            this.mWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        }
        this.mWidget.setBaselineDistance(0);
    }

    @Override
    public void onPaintBackground(ViewTransform transform, Graphics2D g) {
        super.onPaintBackground(transform, g);
        if (this.mColorSet.drawBackground()) {
            this.fakeUIPaint(transform, g, this.mWidget.getDrawX(), this.mWidget.getDrawY());
        }
    }

    protected void fakeUIPaint(ViewTransform transform, Graphics2D g, int x, int y) {
        int tx = transform.getSwingX(x);
        int ty = transform.getSwingY(y);
        int w = transform.getSwingDimension(this.mWidget.getDrawWidth());
        int h = transform.getSwingDimension(this.mWidget.getDrawHeight());
        int padding = transform.getSwingDimension(this.mPadding);
        int originalSize = this.mFont.getSize();
        int scaleSize = transform.getSwingDimension(originalSize);
        g.setFont(this.mFont.deriveFont((float)scaleSize));
        FontMetrics fontMetrics = g.getFontMetrics();
        g.setColor(Color.WHITE);
        g.drawString("WWW", tx + padding, ty + fontMetrics.getAscent() + padding);
        String text = "WebView";
        Rectangle2D bounds = fontMetrics.getStringBounds(text, g);
        g.drawString(text, tx + (int)(((double)w - bounds.getWidth()) / 2.0), ty + (int)(((double)h - bounds.getHeight()) / 2.0));
    }
}

