/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator.WidgetDecorator;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TextWidget
extends WidgetDecorator {
    static boolean DO_WRAP = false;
    protected int mHorizontalPadding = 0;
    protected int mVerticalPadding = 0;
    protected int mVerticalMargin = 0;
    protected int mHorizontalMargin = 0;
    protected boolean mToUpperCase = false;
    public static final int TEXT_ALIGNMENT_TEXT_START = 2;
    public static final int TEXT_ALIGNMENT_TEXT_END = 3;
    public static final int TEXT_ALIGNMENT_VIEW_START = 5;
    public static final int TEXT_ALIGNMENT_VIEW_END = 6;
    public static final int TEXT_ALIGNMENT_CENTER = 4;
    protected int mAlignmentX = 5;
    protected int mAlignmentY = 5;
    private String mText;
    protected Font mFont = new Font("Helvetica", 0, 12);
    private float mFontSize = 14.0f;
    private boolean mDisplayText = true;
    private boolean mSingleLine = false;
    JTextPane mTextPane = new JTextPane();

    public TextWidget(ConstraintWidget widget, String text) {
        super(widget);
        this.setText(text);
        this.mTextPane.setBackground(new Color(0, 0, 0, 0));
    }

    public void setTextAlignment(int textAlignment) {
        this.mAlignmentX = textAlignment;
    }

    public void setSingleLine(boolean singleLine) {
        this.mSingleLine = singleLine;
    }

    public float getTextSize() {
        return this.mFontSize;
    }

    public void setTextSize(float fontSize) {
        this.mFontSize = fontSize;
        int size = TextWidget.androidToSwingFontSize(this.mFontSize);
        this.mFont = new Font("Helvetica", 0, size);
        this.wrapContent();
    }

    public static int androidToSwingFontSize(float fontSize) {
        return Math.round((fontSize * 2.0f + 4.5f) / 2.41f);
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        this.mText = text;
        this.wrapContent();
    }

    protected void wrapContent() {
        if (!DO_WRAP) {
            return;
        }
        if (this.mText == null) {
            return;
        }
        Canvas c = new Canvas();
        c.setFont(this.mFont);
        FontMetrics fm = c.getFontMetrics(this.mFont);
        String string = this.getText();
        if (this.mToUpperCase) {
            string = StringUtil.toUpperCase((String)string);
        }
        int tw = fm.stringWidth(string) + 2 * (this.mHorizontalPadding + this.mHorizontalMargin);
        int th = fm.getMaxAscent() + 2 * fm.getMaxDescent() + 2 * (this.mVerticalPadding + this.mVerticalMargin);
        this.mWidget.setWrapWidth(tw);
        this.mWidget.setWrapHeight(th);
        if (tw > this.mWidget.getMinWidth()) {
            this.mWidget.setMinWidth(tw);
        }
        if (th > this.mWidget.getMinHeight()) {
            this.mWidget.setMinHeight(th);
        }
        if (this.mWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            this.mWidget.setWidth(tw);
        }
        if (this.mWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
            this.mWidget.setHeight(th);
        }
        if (this.mWidget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED && this.mWidget.getWidth() <= this.mWidget.getMinWidth()) {
            this.mWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        }
        if (this.mWidget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.FIXED && this.mWidget.getHeight() <= this.mWidget.getMinHeight()) {
            this.mWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
        }
        int baseline = fm.getAscent() + fm.getMaxDescent() + this.mVerticalPadding + this.mVerticalMargin;
        this.mWidget.setBaselineDistance(baseline);
    }

    @Override
    public void onPaintBackground(ViewTransform transform, Graphics2D g) {
        super.onPaintBackground(transform, g);
        if (this.mColorSet.drawBackground() && this.mDisplayText) {
            this.drawText(transform, g, this.mWidget.getDrawX(), this.mWidget.getDrawY());
        }
    }

    protected void drawText(ViewTransform transform, Graphics2D g, int x, int y) {
        int tx = transform.getSwingX(x);
        int ty = transform.getSwingY(y);
        int h = transform.getSwingDimension(this.mWidget.getDrawHeight());
        int w = transform.getSwingDimension(this.mWidget.getDrawWidth());
        int horizontalPadding = transform.getSwingDimension(this.mHorizontalPadding + this.mHorizontalMargin);
        int verticalPadding = transform.getSwingDimension(this.mVerticalPadding + this.mVerticalMargin);
        int originalSize = this.mFont.getSize();
        int scaleSize = transform.getSwingDimension(originalSize);
        g.setFont(this.mFont.deriveFont((float)scaleSize));
        FontMetrics fontMetrics = g.getFontMetrics();
        Color color = this.mTextColor.getColor();
        if (this.mWidget.getVisibility() == 4) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 100);
        }
        g.setColor(color);
        String string = this.getText();
        if (this.mToUpperCase) {
            string = StringUtil.toUpperCase((String)string);
        }
        int ftx = 0;
        int fty = 0;
        int stringWidth = fontMetrics.stringWidth(string);
        if (stringWidth > w && !this.mSingleLine) {
            this.mTextPane.setText(string);
            this.mTextPane.setForeground(color);
            this.mTextPane.setSize(w, h);
            this.mTextPane.setFont(this.mFont.deriveFont((float)scaleSize * 0.88f));
            StyledDocument doc = this.mTextPane.getStyledDocument();
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            switch (this.mAlignmentX) {
                case 2: 
                case 5: {
                    StyleConstants.setAlignment(attributeSet, 0);
                    break;
                }
                case 4: {
                    StyleConstants.setAlignment(attributeSet, 1);
                    break;
                }
                case 3: 
                case 6: {
                    StyleConstants.setAlignment(attributeSet, 2);
                }
            }
            switch (this.mAlignmentY) {
                case 5: {
                    this.mTextPane.setAlignmentY(0.0f);
                    break;
                }
                case 4: {
                    this.mTextPane.setAlignmentY(0.5f);
                    break;
                }
                case 6: {
                    this.mTextPane.setAlignmentY(1.0f);
                }
            }
            doc.setParagraphAttributes(0, doc.getLength(), attributeSet, false);
            g.translate(tx, ty);
            Shape clip = g.getClip();
            g.clipRect(0, 0, w, h);
            this.mTextPane.paint(g);
            g.setClip(clip);
            g.translate(-tx, -ty);
        } else {
            int alignX = TextWidget.switchAlignment(string, this.mAlignmentX);
            switch (alignX) {
                case 2: 
                case 5: {
                    ftx = tx + horizontalPadding;
                    break;
                }
                case 3: 
                case 4: {
                    int paddx = (w - stringWidth) / 2;
                    ftx = tx + paddx;
                    break;
                }
                case 6: {
                    int padd = w - stringWidth + horizontalPadding;
                    ftx = tx + padd;
                }
            }
            switch (this.mAlignmentY) {
                case 5: {
                    fty = ty + fontMetrics.getAscent() + fontMetrics.getMaxDescent() + verticalPadding;
                    break;
                }
                case 4: {
                    fty = ty + fontMetrics.getAscent() + (h - fontMetrics.getAscent()) / 2;
                    break;
                }
                case 6: {
                    fty = ty + h - fontMetrics.getMaxDescent() - verticalPadding;
                }
            }
            Shape clip = g.getClip();
            g.clipRect(tx, ty, w, h);
            g.drawString(string, ftx, fty);
            g.setClip(clip);
        }
    }

    private static int switchAlignment(String string, int alignmentX) {
        boolean flip_text;
        if (string.isEmpty()) {
            return alignmentX;
        }
        char c = string.charAt(0);
        boolean bl = flip_text = c >= '\u0590' && c <= '\u06ff';
        if (flip_text) {
            switch (alignmentX) {
                case 3: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
        }
        return alignmentX;
    }
}

