/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.animation.Animation;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.jetbrains.annotations.NotNull;

public class DrawAnchor
extends DrawRegion {
    private static final int PAINT_BACKGROUND_SIZE_PERCENT = 20;
    private static final int PAINT_HOVER_SIZE_PERCENT = 40;
    private static final int PAINT_INNER_CIRCLE_SIZE_PERCENT = 10;
    private static final int PAINT_DELETE_ICON_SIZE_PERCENT = 40;
    private static final int PAINT_BASELINE_HOVER_SIZE_PERCENT = 40;
    private static final int PAINT_BASELINE_FILL_SIZE_PERCENT = 40;
    private final Mode myMode;
    private final boolean myIsConnected;
    private final Type myType;

    public DrawAnchor(int x, int y, int width, int height, Type type, boolean isConnected, Mode mode) {
        super(x, y, width, height);
        this.myMode = mode;
        this.myIsConnected = isConnected;
        this.myType = type;
    }

    private static int getPulseAlpha(int deltaT) {
        return (int)Animation.EaseInOutinterpolator((double)Math.abs(deltaT - 500) / 500.0, 0.0, 255.0);
    }

    @Override
    public int getLevel() {
        if (this.myMode == Mode.OVER || this.myMode == Mode.DELETE) {
            return 80;
        }
        return 50;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        Color color;
        if (this.myType == Type.BASELINE) {
            this.paintBaseline(g, sceneContext);
            return;
        }
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getComponentObligatoryBackground();
        boolean willDelete = this.myMode == Mode.DELETE;
        Color color2 = color = willDelete ? colorSet.getAnchorDisconnectionCircle() : colorSet.getSelectedFrames();
        if (this.myMode == Mode.OVER || willDelete) {
            int overRingOffset = this.width * 40 / 100;
            int overRingWidth = this.width + overRingOffset * 2;
            g.setColor(color);
            g.fillRoundRect(this.x - overRingOffset, this.y - overRingOffset, overRingWidth, overRingWidth, overRingWidth, overRingWidth);
        }
        g.setColor(background);
        int whiteSpaceOffset = this.width * 20 / 100;
        int whiteSpaceWidth = this.width + whiteSpaceOffset * 2;
        g.fillRoundRect(this.x - whiteSpaceOffset, this.y - whiteSpaceOffset, whiteSpaceWidth, whiteSpaceWidth, whiteSpaceWidth, whiteSpaceWidth);
        g.setColor(color);
        g.fillRoundRect(this.x, this.y, this.width, this.width, this.width, this.width);
        if (willDelete) {
            g.setColor(background);
            this.paintDeleteConstraintIcon(g);
        }
        if (!this.myIsConnected) {
            int innerCircleOffset = this.width * 10 / 100;
            int innerCircleWidth = this.width - innerCircleOffset * 2;
            g.setColor(background);
            g.fillRoundRect(this.x + innerCircleOffset, this.y + innerCircleOffset, innerCircleWidth, innerCircleWidth, innerCircleWidth, innerCircleWidth);
        }
    }

    public void paintDeleteConstraintIcon(Graphics2D g) {
        int iconSizeOffset = this.width * 40 / 100;
        int iconX = this.x + iconSizeOffset;
        int iconY = this.y + iconSizeOffset;
        int iconSize = this.width - 1 - iconSizeOffset;
        g.drawLine(iconX, iconY, this.x + iconSize, this.y + iconSize);
        g.drawLine(iconX, this.y + iconSize, this.x + iconSize, iconY);
    }

    public void paintBaseline(Graphics2D g, SceneContext sceneContext) {
        int inset = this.width / 10;
        boolean willDelete = this.myMode == Mode.DELETE;
        boolean drawAsHover = this.myMode == Mode.OVER;
        ColorSet colorSet = sceneContext.getColorSet();
        Color background = colorSet.getComponentObligatoryBackground();
        Color color = willDelete ? colorSet.getAnchorDisconnectionCircle() : colorSet.getSelectedFrames();
        g.setColor(color);
        g.fillRect(this.x, this.y + this.height / 2, this.width, 1);
        int ovalX = this.x + inset;
        int ovalY = this.y;
        int ovalW = this.width - 2 * inset;
        int ovalH = this.height;
        int backgroundX = ovalX;
        int backgroundY = ovalY;
        int backgroundW = ovalW;
        int backgroundH = this.height;
        if (drawAsHover) {
            int baselineOffset = this.height * 40 / 100;
            backgroundX -= baselineOffset;
            backgroundY -= baselineOffset;
            backgroundW += baselineOffset * 2;
            backgroundH += baselineOffset * 2;
        }
        g.setColor(background);
        g.fillRoundRect(backgroundX, backgroundY, backgroundW, backgroundH, backgroundH, backgroundH);
        g.setColor(color);
        g.drawRoundRect(backgroundX, backgroundY, backgroundW, backgroundH, backgroundH, backgroundH);
        if (drawAsHover) {
            g.drawRoundRect(ovalX, ovalY, ovalW, this.height, this.height, this.height);
        }
        int delta = this.height * 40 / 100;
        int delta2 = delta * 2;
        if (this.myIsConnected) {
            g.fillRoundRect(ovalX + delta, ovalY + delta, ovalW - delta2, ovalH - delta2, ovalH - delta2, ovalH - delta2);
            g.drawRoundRect(ovalX + delta, ovalY + delta, ovalW - delta2, ovalH - delta2, ovalH - delta2, ovalH - delta2);
        }
    }

    private void paintPulsingAnchor(Graphics2D g, SceneContext sceneContext) {
        Composite comp;
        int alpha;
        ColorSet colorSet = sceneContext.getColorSet();
        if (this.myMode == Mode.CAN_CONNECT) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            g.setColor(colorSet.getAnchorConnectionCircle().darker());
            g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
        if (this.myMode == Mode.CANNOT_CONNECT) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            g.setColor(colorSet.getAnchorDisconnectionCircle());
            g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
        if (this.myMode == Mode.OVER) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            if (this.myIsConnected) {
                g.setColor(colorSet.getAnchorDisconnectionCircle());
            } else {
                g.setColor(colorSet.getAnchorConnectionCircle());
            }
            g.fillRoundRect(this.x, this.y, this.width, this.height, this.width, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
    }

    private void paintPulsingBaselineAnchor(Graphics2D g, SceneContext sceneContext, int ovalX, int ovalW) {
        Composite comp;
        int alpha;
        ColorSet colorSet = sceneContext.getColorSet();
        if (this.myMode == Mode.CAN_CONNECT) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            g.setColor(colorSet.getAnchorConnectionCircle());
            g.fillRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            g.drawRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
        if (this.myMode == Mode.OVER) {
            alpha = DrawAnchor.getPulseAlpha((int)(sceneContext.getTime() % 1000L));
            comp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            if (this.myIsConnected) {
                g.setColor(colorSet.getAnchorDisconnectionCircle());
            } else {
                g.setColor(colorSet.getAnchorConnectionCircle());
            }
            g.fillRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            g.drawRoundRect(ovalX, this.y, ovalW, this.height, this.height, this.height);
            sceneContext.repaint();
            g.setComposite(comp);
        }
    }

    @Override
    public String serialize() {
        return this.getClass().getSimpleName() + "," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + this.myMode.ordinal();
    }

    public static void add(@NotNull DisplayList list, @NotNull SceneContext transform, float x, float y, Type type, boolean isConnected, Mode mode) {
        if (list == null) {
            DrawAnchor.$$$reportNull$$$0(0);
        }
        if (transform == null) {
            DrawAnchor.$$$reportNull$$$0(1);
        }
        assert (type != Type.BASELINE);
        int swingX = transform.getSwingXDip(x);
        int swingY = transform.getSwingYDip(y);
        int l = swingX - AnchorTarget.ANCHOR_SIZE;
        int t = swingY - AnchorTarget.ANCHOR_SIZE;
        list.add(new DrawAnchor(l, t, AnchorTarget.ANCHOR_SIZE * 2, AnchorTarget.ANCHOR_SIZE * 2, type, isConnected, mode));
    }

    public static void addBaseline(@NotNull DisplayList list, @NotNull SceneContext transform, float x, float y, float componentWidth, Type type, boolean isConnected, Mode mode) {
        if (list == null) {
            DrawAnchor.$$$reportNull$$$0(2);
        }
        if (transform == null) {
            DrawAnchor.$$$reportNull$$$0(3);
        }
        assert (type == Type.BASELINE);
        int swingX = transform.getSwingXDip(x);
        int swingY = transform.getSwingYDip(y);
        int swingWidth = transform.getSwingDimensionDip(componentWidth);
        int l = swingX - swingWidth / 2 + AnchorTarget.ANCHOR_SIZE;
        int t = swingY - AnchorTarget.ANCHOR_SIZE / 2;
        int w = swingWidth - 2 * AnchorTarget.ANCHOR_SIZE;
        list.add(new DrawAnchor(l, t, w, AnchorTarget.ANCHOR_SIZE, type, isConnected, mode));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/draw/DrawAnchor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addBaseline";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Mode {
        NORMAL,
        OVER,
        DELETE,
        CAN_CONNECT,
        CANNOT_CONNECT,
        DO_NOT_DRAW;

    }

    public static enum Type {
        NORMAL,
        BASELINE;

    }
}

