/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.resources.ResourceType;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.uibuilder.handlers.constraint.ScrollToViewFocusListener;
import com.intellij.openapi.module.Module;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.EnumSet;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarginWidget
extends JComboBox<String> {
    private static final String POPUP_MENU = "@ ...";
    private static final String DEFAULT = "0";
    private static final String PICK_A_DIMENSION = "Pick a Dimension";
    private static final String[] MENU_LIST = new String[]{"0", "8", "16", "24", "32", "@ ..."};
    private final String myBaseToolTipText;
    private final JTextField myTextField;

    public MarginWidget(@NotNull String name, String tooltip) {
        if (name == null) {
            MarginWidget.$$$reportNull$$$0(0);
        }
        super(new CollectionComboBoxModel(Arrays.asList(MENU_LIST)));
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        this.setEditable(true);
        this.myTextField = (JTextField)this.getEditor().getEditorComponent();
        this.myTextField.setFont(this.myTextField.getFont().deriveFont((float)JBUIScale.scaleFontSize((float)12.0f)));
        this.myTextField.addFocusListener(new ScrollToViewFocusListener(this));
        this.initComboBox(name);
        this.setName(name);
        this.setToolTipText(tooltip);
        this.myBaseToolTipText = tooltip;
    }

    private void italicFont() {
        Font font = this.myTextField.getFont();
        int style = font.getStyle();
        font = font.deriveFont(style |= 2);
        this.myTextField.setFont(font);
    }

    private void normalFont() {
        Font font = this.myTextField.getFont();
        int style = font.getStyle();
        font = font.deriveFont(style &= 0xFFFFFFFD);
        this.myTextField.setFont(font);
    }

    private void updateToolTip(@Nullable String resourceName) {
        if (resourceName == null) {
            this.setToolTipText(this.myBaseToolTipText);
            return;
        }
        this.setToolTipText(this.myBaseToolTipText + " (" + resourceName + ")");
    }

    private void initComboBox(@NotNull String name) {
        if (name == null) {
            MarginWidget.$$$reportNull$$$0(1);
        }
        this.setAlignmentX(1.0f);
        this.setEditable(true);
        this.setName(name + "ComboBox");
    }

    public void setMargin(int margin) {
        String marginText = String.valueOf(margin);
        if (this.getSelectedItem().equals(marginText)) {
            return;
        }
        this.setSelectedItem(marginText);
    }

    public String getMargin(@Nullable NlComponent component3) {
        String toReturn;
        String item = (String)this.getSelectedItem();
        String string = toReturn = item != null ? item : DEFAULT;
        if (POPUP_MENU.equals(toReturn)) {
            toReturn = this.selectFromResourceDialog(component3);
        }
        if (toReturn.startsWith("@")) {
            this.italicFont();
            this.updateToolTip(toReturn);
        } else {
            this.normalFont();
            this.updateToolTip(null);
        }
        return toReturn;
    }

    @NotNull
    private String selectFromResourceDialog(@Nullable NlComponent component3) {
        String pickedResourceName;
        if (component3 == null) {
            return DEFAULT;
        }
        Module module = component3.getModel().getModule();
        XmlTag tag = component3.getBackend().getTag();
        if (tag == null) {
            return DEFAULT;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        assert (facet2 != null);
        ResourcePickerDialog dialog2 = ResourceChooserHelperKt.createResourcePickerDialog(PICK_A_DIMENSION, null, facet2, EnumSet.of(ResourceType.DIMEN), null, true, false, tag.getContainingFile().getVirtualFile());
        if (dialog2.showAndGet() && (pickedResourceName = dialog2.getResourceName()) != null) {
            String string = pickedResourceName;
            if (string == null) {
                MarginWidget.$$$reportNull$$$0(2);
            }
            return string;
        }
        return DEFAULT;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject != null && anObject.equals(this.getSelectedItem())) {
            return;
        }
        super.setSelectedItem(anObject);
        if (this.hasFocus()) {
            this.requestFocusInWindow();
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener2) {
        super.addActionListener(actionListener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/constraint/MarginWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/MarginWidget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFromResourceDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initComboBox";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Show {
        IN_WIDGET,
        OUT_WIDGET,
        OUT_PANEL;

    }
}

