/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressBarHandler
extends ViewHandler {
    private static final String DOT_PROGRESS_BAR_DOT = ".ProgressBar.";
    private static final String PROGRESS_BAR_STYLE = "progressBarStyle";
    private static final String LARGE = "Large";
    private static final String SMALL = "Small";
    private static final String HORIZONTAL = "Horizontal";

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"contentDescription", (Object)"style", (Object)"max", (Object)"progress", (Object)"indeterminate");
        if (immutableList == null) {
            ProgressBarHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component3) {
        String style;
        if (component3 == null) {
            ProgressBarHandler.$$$reportNull$$$0(1);
        }
        Object object = StringUtil.isEmpty((String)(style = ProgressBarHandler.getStyle(component3))) ? "" : "(" + style + ")";
        if (object == null) {
            ProgressBarHandler.$$$reportNull$$$0(2);
        }
        return object;
    }

    @Nullable
    private static String getStyle(@NotNull NlComponent component3) {
        String style;
        if (component3 == null) {
            ProgressBarHandler.$$$reportNull$$$0(3);
        }
        if ((style = component3.getAttribute(null, "style")) == null) {
            return null;
        }
        if (style.startsWith("@android:style/")) {
            return ProgressBarHandler.findProgressBarType(style, DOT_PROGRESS_BAR_DOT);
        }
        if (style.startsWith("?android:")) {
            return ProgressBarHandler.findProgressBarType(style, PROGRESS_BAR_STYLE);
        }
        if (style.startsWith("@style/")) {
            return ProgressBarHandler.findProgressBarType(style, DOT_PROGRESS_BAR_DOT);
        }
        return null;
    }

    @Nullable
    private static String findProgressBarType(@NotNull String style, @NotNull String prefix) {
        int index;
        if (style == null) {
            ProgressBarHandler.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            ProgressBarHandler.$$$reportNull$$$0(5);
        }
        return (index = style.indexOf(prefix)) >= 0 ? ProgressBarHandler.findProgressBarType(style.substring(index + prefix.length())) : null;
    }

    @Nullable
    private static String findProgressBarType(@NotNull String style) {
        if (style == null) {
            ProgressBarHandler.$$$reportNull$$$0(6);
        }
        if (style.startsWith(LARGE)) {
            return LARGE;
        }
        if (style.startsWith(SMALL)) {
            return SMALL;
        }
        if (style.startsWith(HORIZONTAL)) {
            return HORIZONTAL;
        }
        return null;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component3) {
        if (component3 == null) {
            ProgressBarHandler.$$$reportNull$$$0(7);
        }
        if (!component3.getTagName().equals("ProgressBar")) {
            Icon icon2 = super.getIcon(component3);
            if (icon2 == null) {
                ProgressBarHandler.$$$reportNull$$$0(8);
            }
            return icon2;
        }
        Icon icon3 = HORIZONTAL.equals(ProgressBarHandler.getStyle(component3)) ? StudioIcons.LayoutEditor.Palette.PROGRESS_BAR_HORIZONTAL : StudioIcons.LayoutEditor.Palette.PROGRESS_BAR;
        if (icon3 == null) {
            ProgressBarHandler.$$$reportNull$$$0(9);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ProgressBarHandler";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ProgressBarHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleAttributes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTitleAttributes";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStyle";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findProgressBarType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

