/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.SdkConstants;
import com.android.annotations.concurrency.UiThread;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.common.editor.ActionsToolbar;
import com.android.tools.idea.common.error.IssuePanelSplitter;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.uibuilder.editor.AnimationToolbar;
import com.android.tools.idea.uibuilder.editor.NlPreviewManager;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.palette.PaletteDefinition;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.SceneMode;
import com.android.tools.idea.uibuilder.type.AdaptiveIconFileType;
import com.android.tools.idea.util.SyncUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPreviewForm
implements Disposable,
CaretListener {
    public static final String PREVIEW_DESIGN_SURFACE = "NlPreviewFormDesignSurface";
    private final NlPreviewManager myManager;
    private final Project myProject;
    private final NlDesignSurface mySurface;
    private final WorkBench<DesignSurface> myWorkBench;
    private final JPanel myRoot = new JPanel(new BorderLayout());
    private final MergingUpdateQueue myRenderingQueue;
    private boolean myUseInteractiveSelector = true;
    private boolean myIgnoreListener;
    private RenderResult myRenderResult;
    private VirtualFile myFile;
    private boolean isActive = false;
    private ActionsToolbar myActionsToolbar;
    private JComponent myContentPanel;
    @Nullable
    private AnimationToolbar myAnimationToolbar;
    private NlModel myModel;
    private TextEditor myPendingEditor;
    private TextEditor myEditor;
    private CaretModel myCaretModel;
    private SceneMode mySceneMode;
    private AtomicBoolean myCancelPendingModelLoad = new AtomicBoolean(false);

    public NlPreviewForm(NlPreviewManager manager) {
        this.myManager = manager;
        this.myProject = this.myManager.getProject();
        this.mySurface = NlDesignSurface.builder(this.myProject, this).setIsPreview(true).build();
        Disposer.register((Disposable)this, (Disposable)this.mySurface);
        this.mySurface.setCentered(true);
        this.mySurface.setScreenMode(SceneMode.RENDER, false);
        this.mySurface.setName(PREVIEW_DESIGN_SURFACE);
        this.myRenderingQueue = new MergingUpdateQueue("android.layout.preview.caret", 250, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
        this.myRenderingQueue.setRestartTimerOnAdd(true);
        this.myWorkBench = new WorkBench(this.myProject, "Preview", null, (Disposable)this);
        this.myWorkBench.setLoadingText(CommonBundle.getLoadingTreeNodeText());
        this.myRoot.add((Component)((Object)new IssuePanelSplitter(this.mySurface, (JComponent)this.myWorkBench)));
    }

    private void createContentPanel() {
        this.myContentPanel = new JPanel(new BorderLayout());
        this.myContentPanel.add((Component)((Object)this.mySurface), "Center");
    }

    private void setEditor(@Nullable TextEditor editor2) {
        if (editor2 != this.myEditor) {
            this.myEditor = editor2;
            this.mySurface.setFileEditorDelegate((FileEditor)editor2);
            if (this.myCaretModel != null) {
                this.myCaretModel.removeCaretListener((CaretListener)this);
                this.myCaretModel = null;
            }
            if (editor2 != null) {
                this.myCaretModel = this.myEditor.getEditor().getCaretModel();
                this.myCaretModel.addCaretListener((CaretListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaret() {
        int offset;
        SceneView screenView;
        if (this.myCaretModel != null && !this.myIgnoreListener && this.myUseInteractiveSelector && (screenView = this.mySurface.getFocusedSceneView()) != null && (offset = this.myCaretModel.getOffset()) != -1) {
            NlComponent parent;
            NlComponent selectedComponent;
            ImmutableList views2 = screenView.getModel().findByOffset(offset);
            if (views2.isEmpty()) {
                views2 = screenView.getModel().getComponents();
            }
            if (this.mySurface.isPreviewSurface() && views2.size() == 1 && "intent".equals((selectedComponent = (NlComponent)views2.get(0)).getTagName()) && "PreferenceScreen".equals(selectedComponent.getRoot().getTagName()) && (parent = selectedComponent.getParent()) != null) {
                views2 = ImmutableList.of((Object)parent);
            }
            try {
                this.myIgnoreListener = true;
                SelectionModel selectionModel = screenView.getSelectionModel();
                selectionModel.setSelection((List<NlComponent>)views2);
                this.myRenderingQueue.queue(new Update("Preview update"){

                    public void run() {
                        NlPreviewForm.this.mySurface.repaint();
                    }

                    public boolean canEat(Update update2) {
                        return true;
                    }
                });
            }
            finally {
                this.myIgnoreListener = false;
            }
        }
    }

    @Nullable
    public JComponent getToolbarComponent() {
        return this.myActionsToolbar.getToolbarComponent();
    }

    public boolean hasFile() {
        return this.getFile() != null;
    }

    @NotNull
    public String getFileName() {
        XmlFile xmlFile = this.getFile();
        return xmlFile != null ? xmlFile.getName() : "";
    }

    @Nullable
    private XmlFile getFile() {
        if (this.myFile == null) {
            return null;
        }
        return this.myManager.getBoundXmlFile(PsiManager.getInstance((Project)this.myProject).findFile(this.myFile));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            NlPreviewForm.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void dispose() {
        this.deactivate();
        this.disposeActionsToolbar();
        this.disposeModel();
    }

    private void disposeModel() {
        if (this.myModel != null) {
            this.myModel.deactivate(this);
            Disposer.dispose((Disposable)this.myModel);
            this.myModel = null;
            this.mySurface.setModel(null);
        }
    }

    public void setUseInteractiveSelector(boolean useInteractiveSelector) {
        this.myUseInteractiveSelector = useInteractiveSelector;
    }

    public boolean setNextEditor(@NotNull TextEditor editor2) {
        if (editor2 == null) {
            NlPreviewForm.$$$reportNull$$$0(1);
        }
        if (this.myAnimationToolbar != null) {
            this.myAnimationToolbar.stop();
        }
        this.myPendingEditor = editor2;
        this.myFile = editor2.getFile();
        this.myCancelPendingModelLoad.set(true);
        if (this.isActive) {
            this.initPreviewForm();
        }
        return true;
    }

    public void clearRenderResult() {
        XmlFile file = this.getFile();
        if (file == null) {
            this.myRenderResult = null;
        } else if (this.myRenderResult != null && this.myRenderResult.getFile() != file) {
            this.myRenderResult = RenderResult.createBlank((PsiFile)file);
        }
    }

    private void initPreviewForm() {
        if (this.myContentPanel == null) {
            ClearResourceCacheAfterFirstBuild.getInstance(this.myProject).runWhenResourceCacheClean(this::initPreviewFormAfterInitialBuild, this::buildError);
        } else {
            this.initNeleModel();
        }
    }

    private void initPreviewFormAfterInitialBuild() {
        this.myWorkBench.setLoadingText("Waiting for build to finish...");
        SyncUtil.runWhenSmartAndSyncedOnEdt(this.myProject, this, result2 -> {
            if (result2.isSuccessful()) {
                this.initPreviewFormAfterBuildOnEventDispatchThread();
            } else {
                this.buildError();
                SyncUtil.listenUntilNextSync(this.myProject, this, ignore -> this.initPreviewFormAfterBuildOnEventDispatchThread());
            }
        });
    }

    private void buildError() {
        this.myWorkBench.loadingStopped("Preview is unavailable until after a successful project sync");
    }

    private void initPreviewFormAfterBuildOnEventDispatchThread() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (this.myContentPanel == null) {
            this.createContentPanel();
            ArrayList<PaletteDefinition> tools = new ArrayList<PaletteDefinition>(4);
            tools.add(new PaletteDefinition(this.myProject, Side.LEFT, Split.TOP, AutoHide.AUTO_HIDE));
            this.myWorkBench.init(this.myContentPanel, (Object)this.mySurface, tools, false);
        }
        this.initNeleModel();
    }

    private void initAnimationsToolbar() {
        boolean animationsBarEnabled;
        if (this.myAnimationToolbar != null) {
            this.myContentPanel.remove(this.myAnimationToolbar);
        }
        boolean bl = animationsBarEnabled = (Boolean)StudioFlags.NELE_ANIMATIONS_PREVIEW.get() != false || (Boolean)StudioFlags.NELE_MOTION_LAYOUT_ANIMATIONS.get() != false;
        if (!animationsBarEnabled || this.myModel == null) {
            this.myAnimationToolbar = null;
            return;
        }
        if (((Boolean)StudioFlags.NELE_MOTION_LAYOUT_ANIMATIONS.get()).booleanValue()) {
            long maxTimeMs;
            NlComponent transitionLayout = this.myModel.flattenComponents().filter(component3 -> NlComponentHelperKt.isOrHasSuperclass(component3, SdkConstants.MOTION_LAYOUT)).findAny().orElse(null);
            MotionLayoutComponentHelper helper2 = transitionLayout != null ? MotionLayoutComponentHelper.create(transitionLayout) : null;
            long l = maxTimeMs = helper2 != null ? helper2.getMaxTimeMs() : -1L;
            if (helper2 != null) {
                this.myAnimationToolbar = AnimationToolbar.createAnimationToolbar(this, timeMs -> {
                    LayoutlibSceneManager sceneManager = this.mySurface.getSceneManager();
                    if (this.myModel != null && sceneManager != null) {
                        sceneManager.setElapsedFrameTimeMs(timeMs);
                        helper2.setProgress((float)(timeMs - 500L) / (float)maxTimeMs);
                    }
                }, 16L, 500L, maxTimeMs + 500L);
            }
        }
        if (this.myAnimationToolbar == null) {
            this.myAnimationToolbar = AnimationToolbar.createUnlimitedAnimationToolbar(this, timeMs -> {
                LayoutlibSceneManager sceneManager = this.mySurface.getSceneManager();
                if (this.myModel != null && sceneManager != null) {
                    sceneManager.setElapsedFrameTimeMs(timeMs);
                    sceneManager.requestRender();
                }
            }, 16L, 500L);
        }
        this.myAnimationToolbar.setBackground((Color)StudioColorsKt.getPrimaryPanelBackground());
        this.myAnimationToolbar.setOpaque(true);
        this.myContentPanel.add((Component)this.myAnimationToolbar, "South");
    }

    private void initNeleModel() {
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> this.initNeleModelWhenSmart());
    }

    @UiThread
    private void initNeleModelWhenSmart() {
        AtomicBoolean isRequestCancelled;
        this.setActiveModel(null);
        XmlFile xmlFile = this.getFile();
        AndroidFacet facet2 = xmlFile != null ? AndroidFacet.getInstance((PsiElement)xmlFile) : null;
        this.myCancelPendingModelLoad.set(true);
        if (facet2 == null) {
            return;
        }
        this.myCancelPendingModelLoad = isRequestCancelled = new AtomicBoolean(false);
        CompletableFuture.supplyAsync(() -> NlModel.create(null, null, facet2, xmlFile.getVirtualFile(), this.mySurface.getComponentRegistrar())).thenAcceptAsync(model2 -> {
            Device device;
            if (model2.getType() == AdaptiveIconFileType.INSTANCE && (device = model2.getConfiguration().getCachedDevice()) != null && !"Custom Density".equals(device.getId())) {
                NlModelHelperKt.overrideConfigurationDensity(model2, Density.XXXHIGH);
            }
            if (isRequestCancelled.get()) {
                Disposer.dispose((Disposable)model2);
                return;
            }
            this.mySurface.setModel((NlModel)model2).thenRunAsync(() -> {
                if (!isRequestCancelled.get() && !facet2.isDisposed()) {
                    this.setActiveModel((NlModel)model2);
                } else {
                    Disposer.dispose((Disposable)model2);
                }
            }, (Executor)EdtExecutorService.getInstance());
        }, (Executor)EdtExecutorService.getInstance());
    }

    public void fileClosed(@NotNull FileEditorManager editorManager, @NotNull VirtualFile file) {
        if (editorManager == null) {
            NlPreviewForm.$$$reportNull$$$0(2);
        }
        if (file == null) {
            NlPreviewForm.$$$reportNull$$$0(3);
        }
        if (this.myEditor != null && file.equals(this.myFile) && ArrayUtil.find((Object[])editorManager.getAllEditors(file), (Object)this.myEditor) < 0) {
            this.setActiveModel(null);
        }
        if (this.myPendingEditor != null && file.equals(this.myPendingEditor.getFile()) && ArrayUtil.find((Object[])editorManager.getAllEditors(file), (Object)this.myPendingEditor) < 0) {
            this.myPendingEditor = null;
        }
    }

    public void setActiveModel(@Nullable NlModel model2) {
        this.myCancelPendingModelLoad.set(true);
        if (this.myModel != model2) {
            this.disposeModel();
            this.myModel = model2;
        }
        if (model2 == null) {
            this.setEditor(null);
            this.disposeActionsToolbar();
            this.myWorkBench.setToolContext(null);
            this.myWorkBench.setFileEditor(null);
        } else {
            this.myFile = model2.getVirtualFile();
            if (!this.mySurface.isCanvasResizing()) {
                this.mySurface.zoomToFit();
            } else {
                this.mySurface.updateScrolledAreaSize();
            }
            this.setEditor(this.myPendingEditor);
            this.myPendingEditor = null;
            model2.activate(this);
            this.myWorkBench.setToolContext((Object)this.mySurface);
            this.myWorkBench.setFileEditor((FileEditor)this.myEditor);
            this.disposeActionsToolbar();
            this.myActionsToolbar = new ActionsToolbar(this.mySurface, this.mySurface);
            this.myContentPanel.add((Component)this.myActionsToolbar.getToolbarComponent(), "North");
            if (!model2.getType().isEditable()) {
                this.mySceneMode = this.mySurface.getSceneMode();
                this.mySurface.setScreenMode(SceneMode.RENDER, false);
                this.myWorkBench.setMinimizePanelsVisible(false);
            } else if (this.mySceneMode != null && this.mySurface.getSceneMode() == SceneMode.RENDER) {
                this.mySurface.setScreenMode(this.mySceneMode, false);
                this.myWorkBench.setMinimizePanelsVisible(true);
            }
        }
        this.updateCaret();
        this.initAnimationsToolbar();
    }

    private void disposeActionsToolbar() {
        if (this.myActionsToolbar == null) {
            return;
        }
        this.myContentPanel.remove(this.myActionsToolbar.getToolbarComponent());
        Disposer.dispose((Disposable)this.myActionsToolbar);
        this.myActionsToolbar = null;
    }

    @NotNull
    public NlDesignSurface getSurface() {
        NlDesignSurface nlDesignSurface = this.mySurface;
        if (nlDesignSurface == null) {
            NlPreviewForm.$$$reportNull$$$0(4);
        }
        return nlDesignSurface;
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        if (e == null) {
            NlPreviewForm.$$$reportNull$$$0(5);
        }
        if (!this.myIgnoreListener) {
            this.updateCaret();
        }
    }

    public void activate() {
        if (this.isActive) {
            return;
        }
        this.isActive = true;
        this.initPreviewForm();
        this.mySurface.activate();
    }

    public void deactivate() {
        if (!this.isActive) {
            return;
        }
        this.myCancelPendingModelLoad.set(true);
        this.mySurface.deactivate();
        this.isActive = false;
        if (this.myContentPanel != null) {
            this.setActiveModel(null);
        }
    }

    @Nullable
    public final TextEditor getEditor() {
        return this.myEditor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/editor/NlPreviewForm";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlPreviewForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNextEditor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

