/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.editor.NlPreviewForm;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindowManager;
import com.intellij.designer.ToggleEditorModeAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NlAbstractWindowManager
extends LightToolWindowManager {
    private ToolWindowType myPreviousWindowType;
    private ToolWindowAnchor myPreviousWindowAnchor;
    private DesignSurface myDesignSurface;

    public NlAbstractWindowManager(@NotNull Project project) {
        if (project == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(0);
        }
        super(project);
    }

    protected void initToolWindow(final @NotNull String id, @NotNull Icon icon2) {
        if (id == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(1);
        }
        if (icon2 == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(2);
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(id, false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(icon2);
        this.myToolWindow.setAvailable(false);
        this.myToolWindow.setAutoHide(false);
        this.myPreviousWindowType = this.myToolWindow.getType();
        this.myPreviousWindowAnchor = this.getEditorMode();
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                if (toolWindowManager == null) {
                    1.$$$reportNull$$$0(0);
                }
                ToolWindow window = toolWindowManager.getToolWindow(id);
                ToolWindowType newWindowType = window.getType();
                ToolWindowAnchor newWindowAnchor = NlAbstractWindowManager.this.getEditorMode();
                if (newWindowType != NlAbstractWindowManager.this.myPreviousWindowType || newWindowAnchor != NlAbstractWindowManager.this.myPreviousWindowAnchor) {
                    if (NlAbstractWindowManager.this.myDesignSurface != null) {
                        NlAbstractWindowManager.this.myDesignSurface.getAnalyticsManager().trackUnknownEvent();
                    }
                    NlAbstractWindowManager.this.myPreviousWindowType = newWindowType;
                    NlAbstractWindowManager.this.myPreviousWindowAnchor = newWindowAnchor;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager$1", "stateChanged"));
            }
        });
        this.initGearActions();
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myDesignSurface = NlAbstractWindowManager.getDesignSurface(designer);
    }

    @Nullable
    protected DesignerEditorPanelFacade getDesigner(@Nullable FileEditor editor2) {
        return null;
    }

    protected ToggleEditorModeAction createToggleAction(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(3);
        }
        return new ToggleEditorModeAction(this, this.myProject, anchor){

            protected LightToolWindowManager getOppositeManager() {
                return null;
            }
        };
    }

    @Nullable
    protected static DesignSurface getDesignSurface(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(4);
        }
        if (designer instanceof DesignerEditorPanel) {
            DesignerEditorPanel editor2 = (DesignerEditorPanel)designer;
            return editor2.getSurface();
        }
        if (designer instanceof NlPreviewForm) {
            NlPreviewForm form = (NlPreviewForm)designer;
            return form.hasFile() ? form.getSurface() : null;
        }
        throw new RuntimeException(designer.getClass().getName());
    }

    protected void createWindowContent(@NotNull JComponent contentPane, @NotNull JComponent focusedComponent, @Nullable AnAction[] actions2) {
        if (contentPane == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(5);
        }
        if (focusedComponent == null) {
            NlAbstractWindowManager.$$$reportNull$$$0(6);
        }
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content2 = contentManager.getFactory().createContent(contentPane, null, false);
        content2.setCloseable(false);
        content2.setPreferredFocusableComponent(focusedComponent);
        if (actions2 != null) {
            ToolWindowEx toolWindow = (ToolWindowEx)this.myToolWindow;
            toolWindow.setTitleActions(actions2);
        }
        contentManager.addContent(content2);
        contentManager.setSelectedContent(content2, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPane";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusedComponent";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/editor/NlAbstractWindowManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initToolWindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createToggleAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getDesignSurface";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createWindowContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

