/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.ui;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.SketchLibrary;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignSymbol;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedSymbol;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayer;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.interfaces.SketchLayerable;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.meta.SketchMeta;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchArtboard;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPage;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchSymbolMaster;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SketchFile {
    private SketchDocument myDocument;
    private SketchMeta myMeta;
    private List<SketchPage> myPages = new ArrayList<SketchPage>();
    private SketchLibrary myLibrary = new SketchLibrary();

    public void addPage(@NotNull SketchPage page) {
        if (page == null) {
            SketchFile.$$$reportNull$$$0(0);
        }
        this.myPages.add(page);
        this.myLibrary.addSymbols(SketchFile.getAllSymbolMasters(page));
    }

    @NotNull
    private static ImmutableList<SketchStyle> getAllStyles(@NotNull SketchDocument document) {
        SketchSharedStyle[] sharedStyles;
        if (document == null) {
            SketchFile.$$$reportNull$$$0(1);
        }
        ImmutableList.Builder styles2 = new ImmutableList.Builder();
        SketchForeignStyle[] foreignStyles = document.getForeignLayerStyles();
        if (foreignStyles != null) {
            for (SketchForeignStyle sketchForeignStyle : foreignStyles) {
            }
        }
        if ((sharedStyles = document.getLayerStyles()) != null) {
            for (SketchSharedStyle sharedStyle : sharedStyles) {
                styles2.add((Object)sharedStyle.getValue());
            }
        }
        ImmutableList immutableList = styles2.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<SketchSymbolMaster> getAllSymbolMasters(@NotNull SketchDocument document) {
        SketchSharedSymbol[] sharedSymbols;
        if (document == null) {
            SketchFile.$$$reportNull$$$0(3);
        }
        ImmutableList.Builder masters = new ImmutableList.Builder();
        SketchForeignSymbol[] foreignSymbols = document.getForeignSymbols();
        if (foreignSymbols != null) {
            for (SketchForeignSymbol foreignSymbol : foreignSymbols) {
                masters.add((Object)foreignSymbol.getSymbolMaster());
            }
        }
        if ((sharedSymbols = document.getLayerSymbols()) != null) {
            for (SketchSharedSymbol sketchSharedSymbol : sharedSymbols) {
            }
        }
        ImmutableList immutableList = masters.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @NotNull
    public static ImmutableList<SketchArtboard> getArtboards(@NotNull SketchPage page) {
        if (page == null) {
            SketchFile.$$$reportNull$$$0(5);
        }
        ImmutableList.Builder artboards = new ImmutableList.Builder();
        for (SketchLayer layer : page.getLayers()) {
            if (!layer.getClassType().equals("artboard")) continue;
            artboards.add((Object)((SketchArtboard)layer));
        }
        ImmutableList immutableList = artboards.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @NotNull
    public static ImmutableList<SketchSymbolMaster> getAllSymbolMasters(@NotNull SketchPage page) {
        if (page == null) {
            SketchFile.$$$reportNull$$$0(7);
        }
        ImmutableList.Builder masters = new ImmutableList.Builder();
        for (SketchLayer layer : page.getLayers()) {
            masters.addAll(SketchFile.getSymbolMasters(layer));
        }
        ImmutableList immutableList = masters.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<SketchSymbolMaster> getSymbolMasters(@NotNull SketchLayer layer) {
        if (layer == null) {
            SketchFile.$$$reportNull$$$0(9);
        }
        ImmutableList.Builder masters = new ImmutableList.Builder();
        if (layer instanceof SketchLayerable) {
            if (layer instanceof SketchSymbolMaster) {
                masters.add((Object)((SketchSymbolMaster)layer));
            }
            for (SketchLayer subLayer : ((SketchLayerable)((Object)layer)).getLayers()) {
                masters.addAll(SketchFile.getSymbolMasters(subLayer));
            }
        }
        ImmutableList immutableList = masters.build();
        if (immutableList == null) {
            SketchFile.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    @NotNull
    public List<SketchPage> getPages() {
        List<SketchPage> list = this.myPages;
        if (list == null) {
            SketchFile.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public SketchDocument getDocument() {
        SketchDocument sketchDocument = this.myDocument;
        if (sketchDocument == null) {
            SketchFile.$$$reportNull$$$0(12);
        }
        return sketchDocument;
    }

    public void setDocument(@NotNull SketchDocument document) {
        if (document == null) {
            SketchFile.$$$reportNull$$$0(13);
        }
        this.myDocument = document;
        this.myLibrary.addSymbols(SketchFile.getAllSymbolMasters(document));
        this.myLibrary.addStyles(SketchFile.getAllStyles(document));
    }

    @NotNull
    public SketchMeta getMeta() {
        SketchMeta sketchMeta = this.myMeta;
        if (sketchMeta == null) {
            SketchFile.$$$reportNull$$$0(14);
        }
        return sketchMeta;
    }

    public void setMeta(@NotNull SketchMeta meta) {
        if (meta == null) {
            SketchFile.$$$reportNull$$$0(15);
        }
        this.myMeta = meta;
    }

    @NotNull
    public SketchLibrary getLibrary() {
        SketchLibrary sketchLibrary = this.myLibrary;
        if (sketchLibrary == null) {
            SketchFile.$$$reportNull$$$0(16);
        }
        return sketchLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/ui/SketchFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/ui/SketchFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllStyles";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSymbolMasters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtboards";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolMasters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMeta";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllStyles";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllSymbolMasters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getArtboards";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolMasters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDocument";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setMeta";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

