/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.builders.PathStringBuilder;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.DrawableAssetModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientStopModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.ShapeModel;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlTagValueImpl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Color;
import java.util.List;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceFileGenerator {
    public static final Logger LOG = Logger.getInstance(ResourceFileGenerator.class);
    private static final String ATTRIBUTE_AAPT = "xmlns:aapt";
    private static final String ATTRIBUTE_HEIGHT = "android:height";
    private static final String ATTRIBUTE_WIDTH = "android:width";
    private static final String ATTRIBUTE_VIEWPORT_HEIGHT = "android:viewportHeight";
    private static final String ATTRIBUTE_VIEWPORT_WIDTH = "android:viewportWidth";
    private static final String ATTRIBUTE_PATH_DATA = "android:pathData";
    private static final String ATTRIBUTE_FILL_COLOR = "android:fillColor";
    private static final String ATTRIBUTE_GRADIENT_ENDX = "android:endX";
    private static final String ATTRIBUTE_GRADIENT_ENDY = "android:endY";
    private static final String ATTRIBUTE_GRADIENT_STARTX = "android:startX";
    private static final String ATTRIBUTE_GRADIENT_STARTY = "android:startY";
    private static final String ATTRIBUTE_GRADIENT_CENTERX = "android:centerX";
    private static final String ATTRIBUTE_GRADIENT_CENTERY = "android:centerY";
    private static final String ATTRIBUTE_GRADIENT_RADIUS = "android:gradientRadius";
    private static final String ATTRIBUTE_GRADIENT_TYPE = "android:type";
    private static final String ATTRIBUTE_GRADIENT_STOP_COLOR = "android:color";
    private static final String ATTRIBUTE_GRADIENT_STOP_OFFSET = "android:offset";
    private static final String ATTRIBUTE_STROKE_COLOR = "android:strokeColor";
    private static final String ATTRIBUTE_STROKE_WIDTH = "android:strokeWidth";
    private static final String TAG_VECTOR_HEAD = "<vector xmlns:android=\"http://schemas.android.com/apk/res/android\"/>";
    private static final String TAG_PATH = "<path/>";
    private static final String TAG_AAPT_ATTR = "<aapt:attr name = \"android:fillColor\"/>";
    private static final String TAG_GRADIENT = "<gradient/>";
    private static final String TAG_ITEM = "<item/>";
    private static final String TAG_GROUP = "<group/>";
    private static final String TAG_CLIP_PATH = "<clip-path/>";
    private static final String TAG_RESOURCES = "<resources/>";
    private static final String TAG_COLOR = "<color/>";
    public static final int INVALID_COLOR_VALUE = 0;
    public static final int INVALID_BORDER_WIDTH_VALUE = -1;
    @NotNull
    private Project myProject;

    public ResourceFileGenerator(@NotNull Project project) {
        if (project == null) {
            ResourceFileGenerator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    private XmlTag createXmlTag(@NotNull String tag) {
        if (tag == null) {
            ResourceFileGenerator.$$$reportNull$$$0(1);
        }
        XmlTag xmlTag = XmlElementFactory.getInstance((Project)this.myProject).createTagFromText((CharSequence)tag);
        if (xmlTag == null) {
            ResourceFileGenerator.$$$reportNull$$$0(2);
        }
        return xmlTag;
    }

    private static void updateDimensionsFromVectorDrawable(@NotNull DrawableAssetModel vectorDrawable, @NotNull XmlTag root2) {
        if (vectorDrawable == null) {
            ResourceFileGenerator.$$$reportNull$$$0(3);
        }
        if (root2 == null) {
            ResourceFileGenerator.$$$reportNull$$$0(4);
        }
        root2.setAttribute(ATTRIBUTE_HEIGHT, vectorDrawable.getArtboardHeight() + "dp");
        root2.setAttribute(ATTRIBUTE_WIDTH, vectorDrawable.getArtboardWidth() + "dp");
        root2.setAttribute(ATTRIBUTE_VIEWPORT_HEIGHT, Double.toString(vectorDrawable.getViewportHeight()));
        root2.setAttribute(ATTRIBUTE_VIEWPORT_WIDTH, Double.toString(vectorDrawable.getViewportWidth()));
    }

    private void addArtboardPathForTesting(@NotNull DrawableAssetModel drawableAsset, @NotNull XmlTag root2) {
        if (drawableAsset == null) {
            ResourceFileGenerator.$$$reportNull$$$0(5);
        }
        if (root2 == null) {
            ResourceFileGenerator.$$$reportNull$$$0(6);
        }
        XmlTag pathTag = this.createXmlTag(TAG_PATH);
        PathStringBuilder pathStringBuilder = new PathStringBuilder();
        pathStringBuilder.startPath(0.0, 0.0);
        pathStringBuilder.createLine(drawableAsset.getArtboardWidth(), 0.0);
        pathStringBuilder.createLine(drawableAsset.getArtboardWidth(), drawableAsset.getArtboardHeight());
        pathStringBuilder.createLine(0.0, drawableAsset.getArtboardHeight());
        pathStringBuilder.endPath();
        pathTag.setAttribute(ATTRIBUTE_PATH_DATA, pathStringBuilder.build());
        pathTag.setAttribute(ATTRIBUTE_FILL_COLOR, "#FFFFFFFF");
        root2.addSubTag(pathTag, false);
    }

    private void addPath(@NotNull ShapeModel shape, @NotNull XmlTag parentTag) {
        if (shape == null) {
            ResourceFileGenerator.$$$reportNull$$$0(7);
        }
        if (parentTag == null) {
            ResourceFileGenerator.$$$reportNull$$$0(8);
        }
        XmlTag pathTag = this.createXmlTag(TAG_PATH);
        pathTag.setAttribute(ATTRIBUTE_PATH_DATA, shape.getPathString());
        if (shape.getBorderColor() != 0) {
            pathTag.setAttribute(ATTRIBUTE_STROKE_COLOR, ResourceFileGenerator.colorToHex(shape.getBorderColor()));
            pathTag.setAttribute(ATTRIBUTE_STROKE_WIDTH, Integer.toString(shape.getBorderWidth()));
        }
        if (shape.getGradient() != null) {
            parentTag.setAttribute(ATTRIBUTE_AAPT, "http://schemas.android.com/aapt");
            pathTag.addSubTag(this.generateGradientSubTag(shape.getGradient()), false);
        } else if (shape.getFill() != null) {
            pathTag.setAttribute(ATTRIBUTE_FILL_COLOR, ResourceFileGenerator.colorToHex(shape.getFillColor()));
        }
        parentTag.addSubTag(pathTag, false);
    }

    private void addClipPath(@NotNull String pathData, @NotNull XmlTag parentTag) {
        if (pathData == null) {
            ResourceFileGenerator.$$$reportNull$$$0(9);
        }
        if (parentTag == null) {
            ResourceFileGenerator.$$$reportNull$$$0(10);
        }
        XmlTag pathTag = this.createXmlTag(TAG_CLIP_PATH);
        pathTag.setAttribute(ATTRIBUTE_PATH_DATA, pathData);
        parentTag.addSubTag(pathTag, false);
    }

    private void addColor(@NotNull Pair<Color, String> colorToName, @NotNull XmlTag parentTag) {
        if (colorToName == null) {
            ResourceFileGenerator.$$$reportNull$$$0(11);
        }
        if (parentTag == null) {
            ResourceFileGenerator.$$$reportNull$$$0(12);
        }
        XmlTag colorTag = this.createXmlTag(TAG_COLOR);
        colorTag.setAttribute("name", (String)colorToName.getSecond());
        XmlTagValueImpl colorTagValue = new XmlTagValueImpl(XmlTagChild.EMPTY_ARRAY, colorTag);
        colorTagValue.setText(ResourceFileGenerator.colorToHex(((Color)colorToName.getFirst()).getRGB()));
        parentTag.addSubTag(colorTag, false);
    }

    @NotNull
    private XmlTag generateGradientSubTag(@NotNull GradientModel gradient) {
        if (gradient == null) {
            ResourceFileGenerator.$$$reportNull$$$0(13);
        }
        XmlTag aaptAttrTag = XmlElementFactory.getInstance((Project)this.myProject).createTagFromText((CharSequence)TAG_AAPT_ATTR);
        XmlTag gradientTag = XmlElementFactory.getInstance((Project)this.myProject).createTagFromText((CharSequence)TAG_GRADIENT);
        String gradientType = gradient.getDrawableGradientType();
        if (gradientType != null) {
            switch (gradient.getDrawableGradientType()) {
                case "linear": {
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_ENDX, gradient.getGradientEndX());
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_ENDY, gradient.getGradientEndY());
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_STARTX, gradient.getGradientStartX());
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_STARTY, gradient.getGradientStartY());
                    break;
                }
                case "radial": {
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_CENTERX, gradient.getGradientStartX());
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_CENTERY, gradient.getGradientStartY());
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_RADIUS, gradient.getGradientRadius());
                    break;
                }
                case "sweep": {
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_CENTERX, gradient.getGradientStartX());
                    gradientTag.setAttribute(ATTRIBUTE_GRADIENT_CENTERY, gradient.getSweepCenterY());
                }
            }
            gradientTag.setAttribute(ATTRIBUTE_GRADIENT_TYPE, gradient.getDrawableGradientType());
        }
        for (GradientStopModel item : gradient.getGradientStopModels()) {
            XmlTag itemTag = XmlElementFactory.getInstance((Project)this.myProject).createTagFromText((CharSequence)TAG_ITEM);
            itemTag.setAttribute(ATTRIBUTE_GRADIENT_STOP_COLOR, ResourceFileGenerator.colorToHex(item.getColor().getRGB()));
            itemTag.setAttribute(ATTRIBUTE_GRADIENT_STOP_OFFSET, Double.toString(item.getPosition()));
            gradientTag.addSubTag(itemTag, false);
        }
        aaptAttrTag.addSubTag(gradientTag, false);
        XmlTag xmlTag = aaptAttrTag;
        if (xmlTag == null) {
            ResourceFileGenerator.$$$reportNull$$$0(14);
        }
        return xmlTag;
    }

    @NotNull
    private XmlTag generateClippedGroup(@NotNull ShapeModel shape) {
        if (shape == null) {
            ResourceFileGenerator.$$$reportNull$$$0(15);
        }
        XmlTag group2 = this.createXmlTag(TAG_GROUP);
        this.addClipPath(shape.getPathString(), group2);
        XmlTag xmlTag = group2;
        if (xmlTag == null) {
            ResourceFileGenerator.$$$reportNull$$$0(16);
        }
        return xmlTag;
    }

    @Nullable
    private static XmlTag closeClippedGroup(@NotNull XmlTag groupTag, @NotNull XmlTag root2) {
        if (groupTag == null) {
            ResourceFileGenerator.$$$reportNull$$$0(17);
        }
        if (root2 == null) {
            ResourceFileGenerator.$$$reportNull$$$0(18);
        }
        root2.addSubTag(groupTag, false);
        return null;
    }

    @NotNull
    public LightVirtualFile generateDrawableFile(@Nullable DrawableAssetModel drawableAsset) {
        String name = drawableAsset == null ? "null.xml" : drawableAsset.getName() + ".xml";
        LightVirtualFile virtualFile = new LightVirtualFile(name);
        try {
            WriteAction.runAndWait(() -> {
                XmlTag root2 = this.createXmlTag(TAG_VECTOR_HEAD);
                if (drawableAsset != null) {
                    ResourceFileGenerator.updateDimensionsFromVectorDrawable(drawableAsset, root2);
                    ImmutableList<ShapeModel> shapeModels = drawableAsset.getShapeModels();
                    XmlTag groupTag = null;
                    for (ShapeModel shapeModel : shapeModels) {
                        if (shapeModel.hasClippingMask()) {
                            if (shapeModel == shapeModels.get(0)) {
                                this.addClipPath(shapeModel.getPathString(), root2);
                            } else {
                                groupTag = this.generateClippedGroup(shapeModel);
                            }
                        }
                        if (groupTag == null) {
                            this.addPath(shapeModel, root2);
                            continue;
                        }
                        if (shapeModel.shouldBreakMaskChain()) {
                            groupTag = ResourceFileGenerator.closeClippedGroup(groupTag, root2);
                            this.addPath(shapeModel, root2);
                        } else {
                            this.addPath(shapeModel, groupTag);
                        }
                        if (!shapeModel.isLastShape() || groupTag == null) continue;
                        groupTag = ResourceFileGenerator.closeClippedGroup(groupTag, root2);
                    }
                }
                virtualFile.setContent(null, (CharSequence)root2.getText(), false);
            });
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        LightVirtualFile lightVirtualFile = virtualFile;
        if (lightVirtualFile == null) {
            ResourceFileGenerator.$$$reportNull$$$0(19);
        }
        return lightVirtualFile;
    }

    @NotNull
    public LightVirtualFile generateColorsFile(@NotNull List<Pair<Color, String>> colorToNameList) {
        if (colorToNameList == null) {
            ResourceFileGenerator.$$$reportNull$$$0(20);
        }
        LightVirtualFile virtualFile = new LightVirtualFile("sketch_colors.xml");
        try {
            WriteAction.runAndWait(() -> {
                XmlTag resourcesTag = this.createXmlTag(TAG_RESOURCES);
                if (!colorToNameList.isEmpty()) {
                    for (Pair colorToName : colorToNameList) {
                        this.addColor((Pair<Color, String>)colorToName, resourcesTag);
                    }
                }
                virtualFile.setContent(null, (CharSequence)resourcesTag.getText(), false);
            });
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
        }
        LightVirtualFile lightVirtualFile = virtualFile;
        if (lightVirtualFile == null) {
            ResourceFileGenerator.$$$reportNull$$$0(21);
        }
        return lightVirtualFile;
    }

    @NotNull
    private static String colorToHex(int rgb) {
        String string = "#" + String.format("%08X", rgb);
        if (string == null) {
            ResourceFileGenerator.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/converter/builders/ResourceFileGenerator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vectorDrawable";
                break;
            }
            case 4: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawableAsset";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shape";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTag";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorToName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradient";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupTag";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorToNameList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/converter/builders/ResourceFileGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createXmlTag";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateGradientSubTag";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClippedGroup";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDrawableFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "generateColorsFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "colorToHex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createXmlTag";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateDimensionsFromVectorDrawable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addArtboardPathForTesting";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addClipPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addColor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateGradientSubTag";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateClippedGroup";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "closeClippedGroup";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "generateColorsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

