/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.ui.resourcemanager.ImageCache;
import com.android.tools.idea.ui.resourcemanager.explorer.DesignAssetCellRendererKt;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.FrameworkDrawableRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRenderer;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.DrawableIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.DrawableIconProvider$WhenMappings;
import com.android.tools.idea.ui.resourcemanager.rendering.DrawableIconProviderKt;
import com.android.tools.idea.ui.resourcemanager.rendering.FetchImageExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ui.ImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012F\b\u0002\u0010\b\u001a@\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0018\u00010\tj\u0002`\u0012\u00a2\u0006\u0002\u0010\u0013J>\u0010%\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020 0'2\u0006\u0010*\u001a\u00020\n2\b\b\u0002\u0010+\u001a\u00020 H\u0002J$\u0010,\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J<\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\f\u00102\u001a\b\u0012\u0004\u0012\u00020(0'2\f\u00103\u001a\b\u0012\u0004\u0012\u00020 0'H\u0016J\u001c\u00104\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\nH\u0002J,\u00108\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00102\u0006\u00109\u001a\u00020:2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\nH\u0002J\"\u0010;\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010<\u001a\u00020\u00112\u0006\u0010=\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u0010>\u001a\u00020 2\u0006\u0010?\u001a\u00020\u0015H\u0002RL\u0010\b\u001a@\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010\u0018\u00010\tj\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006@"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/DrawableIconProvider;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetIconProvider;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "resourceResolver", "Lcom/android/ide/common/resources/ResourceResolver;", "imageCache", "Lcom/android/tools/idea/ui/resourcemanager/ImageCache;", "alternateImageProvider", "Lkotlin/Function2;", "Ljava/awt/Dimension;", "Lkotlin/ParameterName;", "name", "dimension", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "designAsset", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/image/BufferedImage;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AsyncImageProvider;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/ide/common/resources/ResourceResolver;Lcom/android/tools/idea/ui/resourcemanager/ImageCache;Lkotlin/jvm/functions/Function2;)V", "contentRatio", "", "fetchImageExecutor", "Lcom/android/tools/idea/ui/resourcemanager/rendering/FetchImageExecutor;", "imageIcon", "Ljavax/swing/ImageIcon;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "supportsTransparency", "", "getSupportsTransparency", "()Z", "setSupportsTransparency", "(Z)V", "fetchImage", "refreshCallBack", "Lkotlin/Function0;", "", "isStillVisible", "targetSize", "forceImageRender", "getDrawableImage", "getIcon", "assetToRender", "width", "", "height", "refreshCallback", "shouldBeRendered", "getLayoutImage", "getScale", "target", "source", "renderFrameworkDrawable", "resolvedValue", "Lcom/android/ide/common/rendering/api/ResourceValue;", "renderImage", "scaleToFitIfNeeded", "image", "shouldScale", "scale", "intellij.android.core"})
public final class DrawableIconProvider
implements AssetIconProvider {
    private final FetchImageExecutor fetchImageExecutor;
    private final ImageIcon imageIcon;
    private final double contentRatio;
    private boolean supportsTransparency;
    @NotNull
    private final Project project;
    private final AndroidFacet facet;
    private final ResourceResolver resourceResolver;
    private final ImageCache imageCache;
    private final Function2<Dimension, DesignAsset, CompletableFuture<BufferedImage>> alternateImageProvider;

    @Override
    public boolean getSupportsTransparency() {
        return this.supportsTransparency;
    }

    public void setSupportsTransparency(boolean bl) {
        this.supportsTransparency = bl;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final CompletableFuture<? extends BufferedImage> getDrawableImage(Dimension dimension2, DesignAsset designAsset) {
        if (designAsset.getResourceItem() instanceof SampleDataResourceItem) {
            VirtualFile file = designAsset.getFile();
            return DesignAssetRendererManager.Companion.getInstance().getViewer(file).getImage(file, this.facet.getModule(), dimension2);
        }
        ResourceValue resourceValue2 = DesignAssetKt.resolveValue(this.resourceResolver, designAsset);
        if (resourceValue2 == null) {
            return null;
        }
        ResourceValue resolveValue2 = resourceValue2;
        if (resolveValue2.isFramework()) {
            return this.renderFrameworkDrawable(resolveValue2, designAsset, dimension2);
        }
        VirtualFile virtualFile = ResourceHelper.resolveDrawable((RenderResources)this.resourceResolver, resolveValue2, this.project);
        if (virtualFile == null) {
            virtualFile = designAsset.getFile();
        }
        VirtualFile file = virtualFile;
        return DesignAssetRendererManager.Companion.getInstance().getViewer(file).getImage(file, this.facet.getModule(), dimension2);
    }

    private final CompletableFuture<? extends BufferedImage> getLayoutImage(DesignAsset designAsset) {
        VirtualFile virtualFile = DrawableIconProviderKt.access$getResolvedLayoutFile(this.resourceResolver, designAsset);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        Module module = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
        PsiFile psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)module.getProject(), (VirtualFile)file);
        return psiFile2 instanceof XmlFile ? CompletableFuture.supplyAsync((Supplier)new Supplier<Configuration>(this, file){
            final /* synthetic */ DrawableIconProvider this$0;
            final /* synthetic */ VirtualFile $file;

            public final Configuration get() {
                return ConfigurationManager.getOrCreateInstance(DrawableIconProvider.access$getFacet$p(this.this$0)).getConfiguration(this.$file);
            }
            {
                this.this$0 = drawableIconProvider;
                this.$file = virtualFile;
            }
        }, PooledThreadExecutor.INSTANCE).thenCompose(new Function<Configuration, CompletionStage<BufferedImage>>(this, psiFile2){
            final /* synthetic */ DrawableIconProvider this$0;
            final /* synthetic */ PsiFile $psiFile;

            public final CompletionStage<BufferedImage> apply(Configuration configuration) {
                LayoutRenderer layoutRenderer = LayoutRenderer.Companion.getInstance(DrawableIconProvider.access$getFacet$p(this.this$0));
                XmlFile xmlFile = (XmlFile)this.$psiFile;
                Configuration configuration2 = configuration;
                Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
                return layoutRenderer.getLayoutRender(xmlFile, configuration2);
            }
            {
                this.this$0 = drawableIconProvider;
                this.$psiFile = psiFile2;
            }
        }) : null;
    }

    private final CompletableFuture<? extends BufferedImage> renderImage(Dimension dimension2, DesignAsset designAsset) {
        Object object;
        Object object2 = this.alternateImageProvider;
        if (object2 == null || (object2 = (CompletableFuture)object2.invoke((Object)dimension2, (Object)designAsset)) == null) {
            switch (DrawableIconProvider$WhenMappings.$EnumSwitchMapping$0[designAsset.getType().ordinal()]) {
                case 1: 
                case 2: {
                    object2 = this.getLayoutImage(designAsset);
                    break;
                }
                case 3: 
                case 4: {
                    object2 = this.getDrawableImage(dimension2, designAsset);
                    break;
                }
                default: {
                    object2 = object = null;
                }
            }
        }
        if (object2 == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            object = completableFuture;
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(null)");
        }
        return object;
    }

    @Override
    @NotNull
    public ImageIcon getIcon(@NotNull DesignAsset assetToRender, int width, int height, @NotNull Function0<Unit> refreshCallback, @NotNull Function0<Boolean> shouldBeRendered) {
        Intrinsics.checkNotNullParameter((Object)assetToRender, (String)"assetToRender");
        Intrinsics.checkNotNullParameter(refreshCallback, (String)"refreshCallback");
        Intrinsics.checkNotNullParameter(shouldBeRendered, (String)"shouldBeRendered");
        if (height > 0 && width > 0) {
            Dimension targetSize = new Dimension(width, height);
            BufferedImage image = DrawableIconProvider.fetchImage$default(this, assetToRender, refreshCallback, shouldBeRendered, targetSize, false, 16, null);
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            double scale = this.getScale(targetSize, new Dimension(imageWidth, imageHeight));
            if (Intrinsics.areEqual((Object)image, (Object)DesignAssetCellRendererKt.getEMPTY_ICON()) ^ true && Intrinsics.areEqual((Object)image, (Object)DesignAssetCellRendererKt.getERROR_ICON()) ^ true && this.shouldScale(scale)) {
                BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)image);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.toBufferedImage(image)");
                BufferedImage bufferedImage2 = bufferedImage;
                if (scale < 1.0) {
                    BufferedImage bufferedImage3 = ImageUtils.scale((BufferedImage)bufferedImage2, (double)scale, (double)scale);
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"ImageUtils.scale(bufferedImage, scale, scale)");
                    image = bufferedImage3;
                } else {
                    BufferedImage bufferedImage4 = ImageUtils.lowQualityFastScale((BufferedImage)bufferedImage2, (double)scale, (double)scale);
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage4, (String)"ImageUtils.lowQualityFas\u2026feredImage, scale, scale)");
                    image = bufferedImage4;
                    this.fetchImage(assetToRender, refreshCallback, shouldBeRendered, targetSize, true);
                }
            }
            this.imageIcon.setImage(Intrinsics.areEqual((Object)image, (Object)DesignAssetCellRendererKt.getERROR_ICON()) ? (Image)DesignAssetCellRendererKt.createFailedIcon(targetSize) : (Image)image);
            this.setSupportsTransparency(Intrinsics.areEqual((Object)image, (Object)DesignAssetCellRendererKt.getERROR_ICON()) ^ true);
        } else {
            this.imageIcon.setImage(DesignAssetCellRendererKt.getEMPTY_ICON());
        }
        return this.imageIcon;
    }

    private final boolean shouldScale(double scale) {
        double d = 1.0 - this.contentRatio;
        double d2 = 1.0 + this.contentRatio;
        double d3 = scale;
        return !(d3 >= d) || !(d3 <= d2);
    }

    private final double getScale(Dimension target, Dimension source) {
        double xScale = (double)target.width / source.getWidth();
        double yScale = (double)target.height / source.getHeight();
        boolean bl = false;
        return Math.min(xScale, yScale);
    }

    private final BufferedImage fetchImage(DesignAsset designAsset, Function0<Unit> refreshCallBack, Function0<Boolean> isStillVisible, Dimension targetSize, boolean forceImageRender) {
        return ImageCache.computeAndGet$default(this.imageCache, designAsset, DesignAssetCellRendererKt.getEMPTY_ICON(), forceImageRender, refreshCallBack, null, (Function0)new Function0<CompletableFuture<? extends BufferedImage>>(this, isStillVisible, targetSize, designAsset){
            final /* synthetic */ DrawableIconProvider this$0;
            final /* synthetic */ Function0 $isStillVisible;
            final /* synthetic */ Dimension $targetSize;
            final /* synthetic */ DesignAsset $designAsset;

            @NotNull
            public final CompletableFuture<? extends BufferedImage> invoke() {
                CompletableFuture<Object> completableFuture;
                if (((Boolean)this.$isStillVisible.invoke()).booleanValue()) {
                    CompletableFuture<U> completableFuture2 = CompletableFuture.supplyAsync((Supplier)new Supplier<BufferedImage>(this){
                        final /* synthetic */ fetchImage.1 this$0;

                        @Nullable
                        public final BufferedImage get() {
                            return (Boolean)this.this$0.$isStillVisible.invoke() != false ? (BufferedImage)((CompletableFuture)((CompletableFuture)((CompletableFuture)DrawableIconProvider.access$renderImage(this.this$0.this$0, this.this$0.$targetSize, this.this$0.$designAsset).thenApplyAsync((Function)fetchImage.1.INSTANCE)).thenApply(new Function<BufferedImage, BufferedImage>(this){
                                final /* synthetic */ fetchImage.1 this$0;

                                public final BufferedImage apply(BufferedImage image) {
                                    DrawableIconProvider drawableIconProvider = this.this$0.this$0.this$0;
                                    BufferedImage bufferedImage = image;
                                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"image");
                                    return DrawableIconProvider.access$scaleToFitIfNeeded(drawableIconProvider, bufferedImage, this.this$0.this$0.$targetSize);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            })).exceptionally(new Function<Throwable, BufferedImage>(this){
                                final /* synthetic */ fetchImage.1 this$0;

                                public final BufferedImage apply(Throwable throwable) {
                                    DrawableIconProviderKt.access$getLOG$p().warn("Error while rendering " + this.this$0.this$0.$designAsset, throwable);
                                    return DesignAssetCellRendererKt.getERROR_ICON();
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            })).get() : null;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, DrawableIconProvider.access$getFetchImageExecutor$p(this.this$0));
                    completableFuture = completableFuture2;
                    Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.supply\u2026   }, fetchImageExecutor)");
                } else {
                    CompletableFuture<Object> completableFuture3 = CompletableFuture.completedFuture(null);
                    completableFuture = completableFuture3;
                    Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"CompletableFuture.completedFuture(null)");
                }
                return completableFuture;
            }
            {
                this.this$0 = drawableIconProvider;
                this.$isStillVisible = function0;
                this.$targetSize = dimension2;
                this.$designAsset = designAsset;
                super(0);
            }
        }, 16, null);
    }

    static /* synthetic */ BufferedImage fetchImage$default(DrawableIconProvider drawableIconProvider, DesignAsset designAsset, Function0 function0, Function0 function02, Dimension dimension2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return drawableIconProvider.fetchImage(designAsset, (Function0<Unit>)function0, (Function0<Boolean>)function02, dimension2, bl);
    }

    private final BufferedImage scaleToFitIfNeeded(BufferedImage image, Dimension targetSize) {
        Dimension imageSize = new Dimension(image.getWidth(null), image.getHeight(null));
        double scale = this.getScale(targetSize, imageSize);
        if (this.shouldScale(scale)) {
            int newWidth = (int)((double)imageSize.width * scale);
            int newHeight = (int)((double)imageSize.height * scale);
            if (newWidth > 0 && newHeight > 0) {
                Image scaledImage = ImageUtil.scaleImage((Image)image, (double)scale);
                if (!(scaledImage instanceof BufferedImage)) {
                    Logger.getInstance(DrawableIconProvider.class).error("Not BufferedImage");
                }
                BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)scaledImage);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.toBufferedImage(scaledImage)");
                return bufferedImage;
            }
        }
        return image;
    }

    private final CompletableFuture<? extends BufferedImage> renderFrameworkDrawable(ResourceValue resolvedValue, DesignAsset designAsset, Dimension dimension2) {
        ResourceValue resourceValue2;
        if (designAsset.getResourceItem().getType() == ResourceType.ATTR) {
            resourceValue2 = resolvedValue;
        } else {
            resourceValue2 = this.resourceResolver.getUnresolvedResource(designAsset.getResourceItem().getReferenceToSelf());
            if (resourceValue2 == null) {
                return null;
            }
        }
        ResourceValue frameworkValue = resourceValue2;
        return FrameworkDrawableRenderer.Companion.getInstance(this.facet).thenCompose(new Function<FrameworkDrawableRenderer, CompletionStage<BufferedImage>>(frameworkValue, dimension2){
            final /* synthetic */ ResourceValue $frameworkValue;
            final /* synthetic */ Dimension $dimension;

            public final CompletionStage<BufferedImage> apply(FrameworkDrawableRenderer it) {
                return it.getDrawableRender(this.$frameworkValue, this.$dimension);
            }
            {
                this.$frameworkValue = resourceValue2;
                this.$dimension = dimension2;
            }
        });
    }

    public DrawableIconProvider(@NotNull AndroidFacet facet2, @NotNull ResourceResolver resourceResolver2, @NotNull ImageCache imageCache, @Nullable Function2<? super Dimension, ? super DesignAsset, ? extends CompletableFuture<BufferedImage>> alternateImageProvider) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)resourceResolver2, (String)"resourceResolver");
        Intrinsics.checkNotNullParameter((Object)imageCache, (String)"imageCache");
        this.facet = facet2;
        this.resourceResolver = resourceResolver2;
        this.imageCache = imageCache;
        this.alternateImageProvider = alternateImageProvider;
        Module module = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(FetchImageExecutor.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        this.fetchImageExecutor = (FetchImageExecutor)object;
        this.imageIcon = new ImageIcon(DesignAssetCellRendererKt.getEMPTY_ICON());
        this.contentRatio = 0.1;
        this.supportsTransparency = true;
        Module module2 = this.facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"facet.module.project");
        this.project = project2;
    }

    public /* synthetic */ DrawableIconProvider(AndroidFacet androidFacet, ResourceResolver resourceResolver2, ImageCache imageCache, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function2 = null;
        }
        this(androidFacet, resourceResolver2, imageCache, (Function2<? super Dimension, ? super DesignAsset, ? extends CompletableFuture<BufferedImage>>)function2);
    }

    public static final /* synthetic */ AndroidFacet access$getFacet$p(DrawableIconProvider $this) {
        return $this.facet;
    }

    public static final /* synthetic */ CompletableFuture access$renderImage(DrawableIconProvider $this, Dimension dimension2, DesignAsset designAsset) {
        return $this.renderImage(dimension2, designAsset);
    }

    public static final /* synthetic */ BufferedImage access$scaleToFitIfNeeded(DrawableIconProvider $this, BufferedImage image, Dimension targetSize) {
        return $this.scaleToFitIfNeeded(image, targetSize);
    }

    public static final /* synthetic */ FetchImageExecutor access$getFetchImageExecutor$p(DrawableIconProvider $this) {
        return $this.fetchImageExecutor;
    }
}

