/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.ui.resourcemanager.ImageCache;
import com.android.tools.idea.ui.resourcemanager.importer.DesignAssetImporter;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRendererManager;
import com.android.tools.idea.ui.resourcemanager.plugin.ResourceImporter;
import com.android.tools.idea.ui.resourcemanager.plugin.SVGAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.SketchImporterKt;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetPreviewManagerImpl;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.SketchParser;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.meta.SketchMeta;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchFile;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchImporterPresenter;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.ui.SketchImporterView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J'\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/SketchImporter;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ResourceImporter;", "()V", "hasCustomImport", "", "getHasCustomImport", "()Z", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "supportsBatchImport", "getSupportsBatchImport", "userCanEditQualifiers", "getUserCanEditQualifiers", "getSourcePreview", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "getSupportedFileTypes", "", "invokeCustomImporter", "", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "filePaths", "", "showImportDialog", "view", "Lcom/android/tools/idea/ui/resourcemanager/sketchImporter/ui/SketchImporterView;", "showInvalidSketchFileNotification", "path", "version", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Ljava/lang/Double;Lcom/intellij/openapi/project/Project;)V", "intellij.android.core"})
public final class SketchImporter
implements ResourceImporter {
    @NotNull
    private final String presentableName;
    private final boolean supportsBatchImport;
    private final boolean hasCustomImport;

    @Override
    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    @Override
    public boolean getSupportsBatchImport() {
        return this.supportsBatchImport;
    }

    @Override
    public void invokeCustomImporter(@NotNull AndroidFacet facet2, @NotNull Collection<String> filePaths) {
        block6: {
            VirtualFile virtualFile;
            ImageCache imageCache;
            Disposable disposable;
            SketchImporterView view;
            SketchFile sketchFile;
            block8: {
                block7: {
                    block5: {
                        Object object;
                        String filePath;
                        block4: {
                            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
                            Intrinsics.checkNotNullParameter(filePaths, (String)"filePaths");
                            String string = (String)CollectionsKt.firstOrNull((Iterable)filePaths);
                            if (string == null) {
                                return;
                            }
                            filePath = string;
                            sketchFile = SketchParser.read(filePath);
                            if (sketchFile == null) break block4;
                            SketchMeta sketchMeta = sketchFile.getMeta();
                            Intrinsics.checkNotNullExpressionValue((Object)sketchMeta, (String)"sketchFile.meta");
                            if (!(sketchMeta.getAppVersion() < 50.0)) break block5;
                        }
                        Double d = (object = sketchFile) != null && (object = ((SketchFile)object).getMeta()) != null ? Double.valueOf(((SketchMeta)object).getAppVersion()) : null;
                        Module module = facet2.getModule();
                        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
                        Project project = module.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
                        this.showInvalidSketchFileNotification(filePath, d, project);
                        break block6;
                    }
                    view = new SketchImporterView();
                    Disposable disposable2 = Disposer.newDisposable((String)"SketchImporter");
                    Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable(\"SketchImporter\")");
                    disposable = disposable2;
                    imageCache = ImageCache.Companion.createLargeImageCache$default(ImageCache.Companion, disposable, null, 2, null);
                    Module module = facet2.getModule();
                    Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
                    virtualFile = project.getProjectFile();
                    if (virtualFile == null) break block7;
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile it = virtualFile2;
                    boolean bl3 = false;
                    Configuration configuration = ConfigurationManager.getOrCreateInstance(facet2).getConfiguration(it);
                    Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"ConfigurationManager.get\u2026cet).getConfiguration(it)");
                    virtualFile = configuration.getResourceResolver();
                    if (virtualFile != null) break block8;
                }
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"facet.module.project.pro\u2026Resolver\n      }?: return");
            VirtualFile resourceResolver2 = virtualFile;
            AssetPreviewManagerImpl assetPreviewManager = new AssetPreviewManagerImpl(facet2, imageCache, (ResourceResolver)resourceResolver2);
            view.setPresenter(new SketchImporterPresenter(view, sketchFile, new DesignAssetImporter(), facet2, assetPreviewManager));
            this.showImportDialog(view);
            Disposer.dispose((Disposable)disposable);
        }
    }

    @Override
    public boolean getHasCustomImport() {
        return this.hasCustomImport;
    }

    private final void showImportDialog(SketchImporterView view) {
        int option = JOptionPane.showOptionDialog(null, view, "Choose the assets you would like to import", -1, -1, null, SketchImporterKt.getDIALOG_OPTIONS(), SketchImporterKt.getDIALOG_OPTIONS()[0]);
        switch (option) {
            case 0: {
                view.getPresenter().importAllFilesIntoProject();
                break;
            }
            case 1: {
                view.getPresenter().importFilesIntoProject();
                break;
            }
        }
    }

    @Override
    public boolean getUserCanEditQualifiers() {
        return true;
    }

    @Override
    @NotNull
    public Set<String> getSupportedFileTypes() {
        return SketchImporterKt.access$getSUPPORTED_FILE_TYPES$p();
    }

    @Override
    @Nullable
    public DesignAssetRenderer getSourcePreview(@NotNull DesignAsset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        return DesignAssetRendererManager.Companion.getInstance().getViewer(SVGAssetRenderer.class);
    }

    private final void showInvalidSketchFileNotification(String path2, Double version2, Project project) {
        String fileName = FilenameUtils.getName((String)path2);
        String generalInfo = "Please make sure you use Sketch 50.0 or higher to save your sketch file.";
        String versionInfo = version2 == null ? fileName + " seems to not be a valid Sketch file or has been saved with a version of Sketch older than 43.0." : fileName + " seems to have been saved using Sketch " + version2 + '.';
        String notificationContent = generalInfo + "<br/>" + versionInfo;
        String notificationTitle = "Invalid sketch file";
        new Notification("Invalid Sketch file", null, notificationTitle, fileName, notificationContent, NotificationType.ERROR, null).notify(project);
    }

    public SketchImporter() {
        this.presentableName = "Sketch Importer";
        this.hasCustomImport = true;
    }

    @Override
    @Nullable
    public DesignAsset processFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ResourceImporter.DefaultImpls.processFile(this, file);
    }
}

