/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.ui.resourcemanager.plugin.ImageFuturesManager;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.LayoutRendererKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016BI\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012*\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0005j\u0002`\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ \u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\b2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0005j\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderer;", "Lorg/jetbrains/android/facet/AndroidFacetScopedService;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "renderTaskProvider", "Lkotlin/Function3;", "Lcom/intellij/psi/xml/XmlFile;", "Lcom/android/tools/idea/configurations/Configuration;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/rendering/RenderTask;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/RenderTaskProvider;", "futuresManager", "Lcom/android/tools/idea/ui/resourcemanager/plugin/ImageFuturesManager;", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lkotlin/jvm/functions/Function3;Lcom/android/tools/idea/ui/resourcemanager/plugin/ImageFuturesManager;)V", "getImage", "Ljava/awt/image/BufferedImage;", "xmlFile", "configuration", "getLayoutRender", "onServiceDisposal", "", "Companion", "intellij.android.core"})
public final class LayoutRenderer
extends AndroidFacetScopedService {
    private final Function3<AndroidFacet, XmlFile, Configuration, CompletableFuture<RenderTask>> renderTaskProvider;
    private final ImageFuturesManager<VirtualFile> futuresManager;
    public static final Companion Companion = new Companion(null);

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
    }

    @NotNull
    public final CompletableFuture<BufferedImage> getLayoutRender(@NotNull XmlFile xmlFile, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Function0 imageRenderCallback2 = (Function0)new Function0<CompletableFuture<BufferedImage>>(this, xmlFile, configuration){
            final /* synthetic */ LayoutRenderer this$0;
            final /* synthetic */ XmlFile $xmlFile;
            final /* synthetic */ Configuration $configuration;

            @NotNull
            public final CompletableFuture<BufferedImage> invoke() {
                return LayoutRenderer.access$getImage(this.this$0, this.$xmlFile, this.$configuration);
            }
            {
                this.this$0 = layoutRenderer;
                this.$xmlFile = xmlFile;
                this.$configuration = configuration;
                super(0);
            }
        };
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"xmlFile.virtualFile");
        return this.futuresManager.registerAndGet(virtualFile, (Function0<CompletableFuture<BufferedImage>>)imageRenderCallback2);
    }

    private final CompletableFuture<BufferedImage> getImage(XmlFile xmlFile, Configuration configuration) {
        AndroidFacet androidFacet = this.getFacet();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"facet");
        CompletableFuture renderTaskFuture = (CompletableFuture)this.renderTaskProvider.invoke((Object)androidFacet, (Object)xmlFile, (Object)configuration);
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)renderTaskFuture.thenCompose((Function)getImage.1.INSTANCE)).thenApplyAsync((Function)getImage.2.INSTANCE, (Executor)PooledThreadExecutor.INSTANCE)).whenComplete(new BiConsumer<BufferedImage, Throwable>(renderTaskFuture){
            final /* synthetic */ CompletableFuture $renderTaskFuture;

            public final void accept(@Nullable BufferedImage $noName_0, Throwable $noName_1) {
                block0: {
                    RenderTask renderTask = (RenderTask)this.$renderTaskFuture.get();
                    if (renderTask == null) break block0;
                    renderTask.dispose();
                }
            }
            {
                this.$renderTaskFuture = completableFuture;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"renderTaskFuture.thenCom\u2026.get()?.dispose()\n      }");
        return completionStage;
    }

    @VisibleForTesting
    public LayoutRenderer(@NotNull AndroidFacet facet2, @NotNull Function3<? super AndroidFacet, ? super XmlFile, ? super Configuration, ? extends CompletableFuture<RenderTask>> renderTaskProvider, @NotNull ImageFuturesManager<VirtualFile> futuresManager) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter(renderTaskProvider, (String)"renderTaskProvider");
        Intrinsics.checkNotNullParameter(futuresManager, (String)"futuresManager");
        super(facet2);
        this.renderTaskProvider = renderTaskProvider;
        this.futuresManager = futuresManager;
        Disposer.register((Disposable)this, (Disposable)this.futuresManager);
    }

    public static final /* synthetic */ CompletableFuture access$getImage(LayoutRenderer $this, XmlFile xmlFile, Configuration configuration) {
        return $this.getImage(xmlFile, configuration);
    }

    @JvmStatic
    @NotNull
    public static final LayoutRenderer getInstance(@NotNull AndroidFacet facet2) {
        return Companion.getInstance(facet2);
    }

    @VisibleForTesting
    @JvmStatic
    public static final void setInstance(@NotNull AndroidFacet facet2, @Nullable LayoutRenderer layoutRenderer) {
        Companion.setInstance(facet2, layoutRenderer);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderer$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/ui/resourcemanager/plugin/LayoutRenderer;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "setInstance", "", "layoutRenderer", "intellij.android.core"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final LayoutRenderer getInstance(@NotNull AndroidFacet facet2) {
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            LayoutRenderer manager = (LayoutRenderer)facet2.getUserData(LayoutRendererKt.access$getLAYOUT_KEY$p());
            if (manager == null) {
                manager = new LayoutRenderer(facet2, (Function3<? super AndroidFacet, ? super XmlFile, ? super Configuration, ? extends CompletableFuture<RenderTask>>)((Function3)getInstance.1.INSTANCE), new ImageFuturesManager<VirtualFile>());
                this.setInstance(facet2, manager);
            }
            return manager;
        }

        @VisibleForTesting
        @JvmStatic
        public final void setInstance(@NotNull AndroidFacet facet2, @Nullable LayoutRenderer layoutRenderer) {
            Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
            facet2.putUserData(LayoutRendererKt.access$getLAYOUT_KEY$p(), (Object)layoutRenderer);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

