/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.plugin;

import com.android.tools.idea.npw.assetstudio.DrawableRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DesignAssetRenderer;
import com.android.tools.idea.ui.resourcemanager.plugin.DrawableAssetRendererKt;
import com.android.tools.idea.util.TimedDisposable;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.concurrent.CompletableFuture;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/plugin/DrawableAssetRenderer;", "Lcom/android/tools/idea/ui/resourcemanager/plugin/DesignAssetRenderer;", "()V", "currentFacet", "Ljava/lang/ref/WeakReference;", "Lorg/jetbrains/android/facet/AndroidFacet;", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "kotlin.jvm.PlatformType", "drawableRenderer", "Lcom/android/tools/idea/util/TimedDisposable;", "Lcom/android/tools/idea/npw/assetstudio/DrawableRenderer;", "failedFuture", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/image/BufferedImage;", "exception", "", "getImage", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "dimension", "Ljava/awt/Dimension;", "getRenderer", "isFileSupported", "", "intellij.android.core"})
public final class DrawableAssetRenderer
implements DesignAssetRenderer {
    private TimedDisposable<? extends DrawableRenderer> drawableRenderer;
    private WeakReference<AndroidFacet> currentFacet;
    private final DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();

    private final DrawableRenderer getRenderer(Module module) {
        DrawableRenderer drawableRenderer;
        DrawableRenderer renderer2;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            throw (Throwable)new NullPointerException("Facet couldn't be found for use in DrawableRenderer.");
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"AndroidFacet.getInstance\u2026se in DrawableRenderer.\")");
        AndroidFacet facet2 = androidFacet;
        WeakReference<AndroidFacet> weakReference = this.currentFacet;
        if (Intrinsics.areEqual((Object)facet2, (Object)(weakReference != null ? (AndroidFacet)weakReference.get() : null)) ^ true) {
            this.currentFacet = null;
            TimedDisposable<? extends DrawableRenderer> timedDisposable = this.drawableRenderer;
            if (timedDisposable != null) {
                timedDisposable.dispose();
            }
            this.drawableRenderer = null;
        }
        TimedDisposable<? extends DrawableRenderer> timedDisposable = this.drawableRenderer;
        DrawableRenderer drawableRenderer2 = renderer2 = timedDisposable != null ? timedDisposable.get() : null;
        if (renderer2 == null) {
            DrawableRenderer newRenderer = new DrawableRenderer(facet2);
            this.drawableRenderer = new TimedDisposable<Disposable>(newRenderer, (Disposable)facet2, 5L, DrawableAssetRendererKt.access$getDisposeTimeUnit$p());
            this.currentFacet = new WeakReference<AndroidFacet>(facet2);
            drawableRenderer = newRenderer;
        } else {
            drawableRenderer = renderer2;
        }
        return drawableRenderer;
    }

    @Override
    public boolean isFileSupported(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)XmlFileType.INSTANCE) ^ true || file.getLength() == 0L) {
            return false;
        }
        try {
            Document document = this.documentBuilder.parse(file.getInputStream());
            Object[] objectArray = DrawableAssetRendererKt.access$getSUPPORTED_DRAWABLE_TAG$p();
            Document document2 = document;
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
            Element element = document2.getDocumentElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"document.documentElement");
            bl = ArraysKt.contains((Object[])objectArray, (Object)element.getNodeName());
        }
        catch (SAXParseException ex) {
            DrawableAssetRendererKt.access$getLOG$p().debug(Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + " in " + file.getPath(), (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            DrawableAssetRendererKt.access$getLOG$p().warn(Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + " in " + file.getPath(), (Throwable)ex);
            return false;
        }
        return bl;
    }

    @Override
    @NotNull
    public CompletableFuture<? extends BufferedImage> getImage(@NotNull VirtualFile file, @Nullable Module module, @NotNull Dimension dimension2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dimension2, (String)"dimension");
        try {
            if (module == null) {
                throw (Throwable)new NullPointerException("Module cannot be null to render a Drawable.");
            }
            if (!this.isFileSupported(file)) {
                throw (Throwable)new ParseException(file.getPath() + " couldn't be parsed as a drawable.", 0);
            }
            DrawableRenderer renderer2 = this.getRenderer(module);
            byte[] byArray = file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"file.contentsToByteArray()");
            byte[] byArray2 = byArray;
            boolean bl = false;
            String xmlContent = new String(byArray2, Charsets.UTF_8);
            CompletableFuture<BufferedImage> completableFuture = renderer2.renderDrawable(xmlContent, dimension2);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"renderer.renderDrawable(xmlContent, dimension)");
            return completableFuture;
        }
        catch (Exception ex) {
            return this.failedFuture(ex);
        }
    }

    private final CompletableFuture<? extends BufferedImage> failedFuture(Throwable exception) {
        DrawableAssetRendererKt.access$getLOG$p().warn(exception);
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(exception);
        return failedFuture;
    }
}

