/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.model;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.model.AssetKey;
import com.android.tools.idea.ui.resourcemanager.model.DesignAssetKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\t\u0010\"\u001a\u00020\fH\u00c6\u0003JA\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\u0006\u0010(\u001a\u00020\nJ\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "qualifiers", "", "Lcom/android/ide/common/resources/configuration/ResourceQualifier;", "type", "Lcom/android/resources/ResourceType;", "name", "", "resourceItem", "Lcom/android/ide/common/resources/ResourceItem;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lcom/android/resources/ResourceType;Ljava/lang/String;Lcom/android/ide/common/resources/ResourceItem;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "key", "Lcom/android/tools/idea/ui/resourcemanager/model/AssetKey;", "getKey", "()Lcom/android/tools/idea/ui/resourcemanager/model/AssetKey;", "getName", "()Ljava/lang/String;", "getQualifiers", "()Ljava/util/List;", "setQualifiers", "(Ljava/util/List;)V", "getResourceItem", "()Lcom/android/ide/common/resources/ResourceItem;", "getType", "()Lcom/android/resources/ResourceType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "getDisplayableFileSize", "hashCode", "", "toString", "intellij.android.core"})
public final class DesignAsset
implements Asset {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private List<? extends ResourceQualifier> qualifiers;
    @NotNull
    private final ResourceType type;
    @NotNull
    private final String name;
    @NotNull
    private final ResourceItem resourceItem;

    @NotNull
    public final String getDisplayableFileSize() {
        if (this.getResourceItem().isFileBased()) {
            String string = StringUtil.formatFileSize((long)this.file.getLength());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.formatFileSize(file.length)");
            return string;
        }
        return "";
    }

    @Override
    @NotNull
    public AssetKey getKey() {
        return new AssetKey(this.getName(), this.getType(), this.file.getPath());
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final List<ResourceQualifier> getQualifiers() {
        return this.qualifiers;
    }

    public final void setQualifiers(@NotNull List<? extends ResourceQualifier> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.qualifiers = list;
    }

    @Override
    @NotNull
    public ResourceType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ResourceItem getResourceItem() {
        return this.resourceItem;
    }

    public DesignAsset(@NotNull VirtualFile file, @NotNull List<? extends ResourceQualifier> qualifiers, @NotNull ResourceType type, @NotNull String name, @NotNull ResourceItem resourceItem) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)resourceItem, (String)"resourceItem");
        this.file = file;
        this.qualifiers = qualifiers;
        this.type = type;
        this.name = name;
        this.resourceItem = resourceItem;
    }

    public /* synthetic */ DesignAsset(VirtualFile virtualFile, List list, ResourceType resourceType, String string, ResourceItem resourceItem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            String string2 = virtualFile.getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.nameWithoutExtension");
            string = string2;
        }
        if ((n & 0x10) != 0) {
            resourceItem = (ResourceItem)new ResourceMergerItem(string, DesignAssetKt.getExternalResourceNamespace(), resourceType, null, null, "external");
        }
        this(virtualFile, list, resourceType, string, resourceItem);
    }

    @Override
    @NotNull
    public ResourceUrl getResourceUrl() {
        return Asset.DefaultImpls.getResourceUrl(this);
    }

    @NotNull
    public final VirtualFile component1() {
        return this.file;
    }

    @NotNull
    public final List<ResourceQualifier> component2() {
        return this.qualifiers;
    }

    @NotNull
    public final ResourceType component3() {
        return this.getType();
    }

    @NotNull
    public final String component4() {
        return this.getName();
    }

    @NotNull
    public final ResourceItem component5() {
        return this.getResourceItem();
    }

    @NotNull
    public final DesignAsset copy(@NotNull VirtualFile file, @NotNull List<? extends ResourceQualifier> qualifiers, @NotNull ResourceType type, @NotNull String name, @NotNull ResourceItem resourceItem) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)resourceItem, (String)"resourceItem");
        return new DesignAsset(file, qualifiers, type, name, resourceItem);
    }

    public static /* synthetic */ DesignAsset copy$default(DesignAsset designAsset, VirtualFile virtualFile, List list, ResourceType resourceType, String string, ResourceItem resourceItem, int n, Object object) {
        if ((n & 1) != 0) {
            virtualFile = designAsset.file;
        }
        if ((n & 2) != 0) {
            list = designAsset.qualifiers;
        }
        if ((n & 4) != 0) {
            resourceType = designAsset.getType();
        }
        if ((n & 8) != 0) {
            string = designAsset.getName();
        }
        if ((n & 0x10) != 0) {
            resourceItem = designAsset.getResourceItem();
        }
        return designAsset.copy(virtualFile, list, resourceType, string, resourceItem);
    }

    @NotNull
    public String toString() {
        return "DesignAsset(file=" + this.file + ", qualifiers=" + this.qualifiers + ", type=" + this.getType() + ", name=" + this.getName() + ", resourceItem=" + this.getResourceItem() + ")";
    }

    public int hashCode() {
        VirtualFile virtualFile = this.file;
        List<? extends ResourceQualifier> list = this.qualifiers;
        ResourceType resourceType = this.getType();
        String string = this.getName();
        ResourceItem resourceItem = this.getResourceItem();
        return ((((virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (resourceType != null ? resourceType.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (resourceItem != null ? resourceItem.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DesignAsset)) break block3;
                DesignAsset designAsset = (DesignAsset)object;
                if (!Intrinsics.areEqual((Object)this.file, (Object)designAsset.file) || !Intrinsics.areEqual(this.qualifiers, designAsset.qualifiers) || !Intrinsics.areEqual((Object)this.getType(), (Object)designAsset.getType()) || !Intrinsics.areEqual((Object)this.getName(), (Object)designAsset.getName()) || !Intrinsics.areEqual((Object)this.getResourceItem(), (Object)designAsset.getResourceItem())) break block3;
            }
            return true;
        }
        return false;
    }
}

