/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorerKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\bH\u0002\u00a8\u0006\t"}, d2={"getSortedResourceTypes", "", "Lcom/android/resources/ResourceType;", "originalSet", "", "(Ljava/util/Set;)[Lcom/android/resources/ResourceType;", "getReferenceString", "", "Lcom/android/ide/common/resources/ResourceItem;", "intellij.android.core"})
public final class ResourcePickerDialogKt {
    private static final ResourceType[] getSortedResourceTypes(Set<? extends ResourceType> originalSet) {
        ResourceType[] resManagerTypes = ResourceExplorerKt.getMANAGER_SUPPORTED_RESOURCES();
        ArrayList<ResourceType> sortedTypes = new ArrayList<ResourceType>();
        Object $this$toTypedArray$iv = (ResourceType[])originalSet;
        boolean $i$f$toTypedArray = false;
        ResourceType[] thisCollection$iv = $this$toTypedArray$iv;
        ResourceType[] resourceTypeArray = thisCollection$iv.toArray(new ResourceType[0]);
        if (resourceTypeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Set remainingTypes = SetsKt.mutableSetOf((Object[])Arrays.copyOf(resourceTypeArray, resourceTypeArray.length));
        ResourceType[] $this$forEach$iv = resManagerTypes;
        boolean $i$f$forEach = false;
        thisCollection$iv = $this$forEach$iv;
        int n = thisCollection$iv.length;
        for (int j = 0; j < n; ++j) {
            ResourceType element$iv;
            ResourceType resourceType = element$iv = thisCollection$iv[j];
            boolean bl = false;
            if (!remainingTypes.remove(resourceType)) continue;
            sortedTypes.add(resourceType);
        }
        sortedTypes.addAll(remainingTypes);
        $this$toTypedArray$iv = sortedTypes;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        ResourceType[] resourceTypeArray2 = thisCollection$iv.toArray(new ResourceType[0]);
        if (resourceTypeArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return resourceTypeArray2;
    }

    private static final String getReferenceString(ResourceItem $this$getReferenceString) {
        ResourceReference resourceReference;
        ResourceReference resourceReference2 = resourceReference = $this$getReferenceString.getReferenceToSelf();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReference2, (String)"resourceReference");
        String qualifiedName = resourceReference2.getQualifiedName();
        if (Intrinsics.areEqual((Object)resourceReference.getNamespace(), (Object)ResourceNamespace.TOOLS)) {
            String string = qualifiedName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"qualifiedName");
            if (StringsKt.lastIndexOf$default((CharSequence)string, (String)":", (int)0, (boolean)false, (int)6, null) < 0) {
                qualifiedName = resourceReference.getNamespace().toString() + ":" + qualifiedName;
            }
        }
        String string = ResolutionUtils.getResourceUrlFromQualifiedName(qualifiedName, $this$getReferenceString.getType().getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ResolutionUtils.getResou\u2026fiedName, type.getName())");
        return string;
    }

    public static final /* synthetic */ String access$getReferenceString(ResourceItem $this$access_u24getReferenceString) {
        return ResourcePickerDialogKt.getReferenceString($this$access_u24getReferenceString);
    }

    public static final /* synthetic */ ResourceType[] access$getSortedResourceTypes(Set originalSet) {
        return ResourcePickerDialogKt.getSortedResourceTypes(originalSet);
    }
}

