/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.groups;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.ui.resourcechooser.ResourceChooserItem;
import com.android.tools.idea.ui.resourcechooser.groups.ResourceChooserGroup;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceChooserGroups {
    private static final boolean FILTER_OUT_PRIVATE_ITEMS = true;
    private static ImmutableList<ResourceNamespace> SAMPLE_DATA_NS = ImmutableList.of((Object)ResourceNamespace.TOOLS, (Object)ResourceNamespace.TODO());
    private static final Comparator<ResourceChooserItem> ITEM_COMPARATOR = (resource1, resource2) -> {
        int framework2;
        int framework1 = resource1.isFramework() ? 1 : 0;
        int delta = framework1 - (framework2 = resource2.isFramework() ? 1 : 0);
        if (delta != 0) {
            return delta;
        }
        return resource1.getName().compareTo(resource2.getName());
    };
    private static final EnumSet<ResourceType> IMAGE_RESOURCE_TYPES = EnumSet.of(ResourceType.DRAWABLE, ResourceType.MIPMAP, ResourceType.COLOR);
    private static final Predicate<SampleDataResourceItem> ONLY_IMAGES_FILTER = item -> item.getContentType() == SampleDataResourceItem.ContentType.IMAGE;
    private static final Predicate<SampleDataResourceItem> NOT_IMAGES_FILTER = ONLY_IMAGES_FILTER.negate();
    private static final String SAMPLE_DATA_LABEL = "Sample data";
    private static final String THEME_ATTRIBUTES_LABEL = "Theme attributes";

    private ResourceChooserGroups() {
    }

    @NotNull
    private static ImmutableList<ResourceChooserItem> getFrameworkItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull ResourceRepository frameworkResources, @NotNull ResourceType asType) {
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(0);
        }
        if (frameworkResources == null) {
            ResourceChooserGroups.$$$reportNull$$$0(1);
        }
        if (asType == null) {
            ResourceChooserGroups.$$$reportNull$$$0(2);
        }
        HashMap<String, ArrayList<ResourceItem>> itemsByName = new HashMap<String, ArrayList<ResourceItem>>();
        Collection publicItems = frameworkResources.getPublicResources(ResourceNamespace.ANDROID, type);
        for (ResourceItem item : publicItems) {
            String name = item.getName();
            ArrayList<ResourceItem> list = (ArrayList<ResourceItem>)itemsByName.get(name);
            if (list == null) {
                list = new ArrayList<ResourceItem>();
                itemsByName.put(name, list);
            }
            list.add(item);
        }
        ImmutableList.Builder chooserItems = ImmutableList.builder();
        for (Map.Entry entry : itemsByName.entrySet()) {
            List items2 = (List)entry.getValue();
            String resourceName = (String)entry.getKey();
            if (!includeFileResources && ((ResourceItem)items2.get(0)).isFileBased()) continue;
            chooserItems.add((Object)ResourceChooserItem.createFrameworkItem(asType, resourceName, items2));
        }
        ImmutableList immutableList = chooserItems.build();
        if (immutableList == null) {
            ResourceChooserGroups.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @NotNull
    private static ImmutableList<ResourceChooserItem> getProjectItems(@NotNull ResourceType type, boolean includeFileResources, @NotNull LocalResourceRepository repository, @Nullable ResourceVisibilityLookup lookup) {
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(4);
        }
        if (repository == null) {
            ResourceChooserGroups.$$$reportNull$$$0(5);
        }
        ImmutableList.Builder chooserItems = ImmutableList.builder();
        for (String resourceName : repository.getResources(ResourceNamespace.TODO(), type).keySet()) {
            List<ResourceItem> items2;
            if (lookup != null && lookup.isPrivate(type, resourceName) || (items2 = repository.getResources(ResourceNamespace.TODO(), type, resourceName)).isEmpty() || !includeFileResources && items2.get(0).isFileBased()) continue;
            chooserItems.add((Object)ResourceChooserItem.createProjectItem(type, resourceName, items2));
        }
        ImmutableList immutableList = chooserItems.build();
        if (immutableList == null) {
            ResourceChooserGroups.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @NotNull
    public static ResourceChooserGroup createResourceItemsGroup(@NotNull String label, @NotNull ResourceType type, @NotNull AndroidFacet facet2, boolean framework, boolean includeFileResources) {
        if (label == null) {
            ResourceChooserGroups.$$$reportNull$$$0(7);
        }
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(8);
        }
        if (facet2 == null) {
            ResourceChooserGroups.$$$reportNull$$$0(9);
        }
        assert (type != ResourceType.MIPMAP);
        ImmutableList.Builder items2 = ImmutableList.builder();
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(facet2);
        if (framework) {
            ImmutableSortedSet<String> languages = type == ResourceType.STRING ? repositoryManager.getLanguagesInProject() : ImmutableSet.of();
            ResourceRepository frameworkResources = repositoryManager.getFrameworkResources((Set<String>)languages);
            if (frameworkResources != null) {
                items2.addAll(ResourceChooserGroups.getFrameworkItems(type, includeFileResources, frameworkResources, type));
                if (type == ResourceType.DRAWABLE) {
                    items2.addAll(ResourceChooserGroups.getFrameworkItems(ResourceType.MIPMAP, includeFileResources, frameworkResources, type));
                }
            }
        } else {
            LocalResourceRepository appResources = repositoryManager.getAppResources();
            ResourceVisibilityLookup lookup = repositoryManager.getResourceVisibility();
            items2.addAll(ResourceChooserGroups.getProjectItems(type, includeFileResources, appResources, lookup));
            if (type == ResourceType.DRAWABLE) {
                items2.addAll(ResourceChooserGroups.getProjectItems(ResourceType.MIPMAP, includeFileResources, appResources, lookup));
            }
        }
        ImmutableList itemList = ImmutableList.sortedCopyOf(ITEM_COMPARATOR, (Iterable)items2.build());
        String fullLabel = label + " (" + itemList.size() + ")";
        return new ResourceChooserGroup(fullLabel, type, (ImmutableList<ResourceChooserItem>)itemList);
    }

    @NotNull
    public static ResourceChooserGroup createThemeAttributesGroup(@NotNull ResourceType type, @NotNull AndroidFacet facet2, @NotNull Collection<String> attrs) {
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(10);
        }
        if (facet2 == null) {
            ResourceChooserGroups.$$$reportNull$$$0(11);
        }
        if (attrs == null) {
            ResourceChooserGroups.$$$reportNull$$$0(12);
        }
        ResourceVisibilityLookup lookup = ResourceRepositoryManager.getInstance(facet2).getResourceVisibility();
        ArrayList<ResourceChooserItem.AttrItem> items2 = new ArrayList<ResourceChooserItem.AttrItem>();
        for (String name : attrs) {
            String simpleName;
            boolean framework = name.startsWith("android:");
            String string = simpleName = framework ? ResolutionUtils.getNameFromQualifiedName(name) : name;
            if (!framework && lookup != null && lookup.isPrivate(ResourceType.ATTR, simpleName)) continue;
            items2.add(new ResourceChooserItem.AttrItem(type, framework, simpleName));
        }
        ImmutableList itemList = ImmutableList.sortedCopyOf(ITEM_COMPARATOR, items2);
        String fullLabel = "Theme attributes (" + itemList.size() + ")";
        return new ResourceChooserGroup(fullLabel, type, (ImmutableList<ResourceChooserItem>)itemList);
    }

    @NotNull
    public static ResourceChooserGroup createSampleDataGroup(@NotNull ResourceType type, @NotNull AndroidFacet facet2) {
        if (type == null) {
            ResourceChooserGroups.$$$reportNull$$$0(13);
        }
        if (facet2 == null) {
            ResourceChooserGroups.$$$reportNull$$$0(14);
        }
        LocalResourceRepository repository = ResourceRepositoryManager.getAppResources(facet2);
        Predicate<SampleDataResourceItem> filter2 = IMAGE_RESOURCE_TYPES.contains(type) ? ONLY_IMAGES_FILTER : NOT_IMAGES_FILTER;
        ImmutableList items2 = (ImmutableList)SAMPLE_DATA_NS.stream().flatMap(namespace -> repository.getResources((ResourceNamespace)namespace, ResourceType.SAMPLE_DATA).values().stream()).map(item -> (SampleDataResourceItem)item).filter(filter2).map(item -> new ResourceChooserItem.SampleDataItem((SampleDataResourceItem)item)).collect(ImmutableList.toImmutableList());
        ImmutableList itemList = ImmutableList.sortedCopyOf(ITEM_COMPARATOR, (Iterable)items2);
        String fullLabel = "Sample data (" + itemList.size() + ")";
        return new ResourceChooserGroup(fullLabel, type, (ImmutableList<ResourceChooserItem>)itemList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkResources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asType";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcechooser/groups/ResourceChooserGroups";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcechooser/groups/ResourceChooserGroups";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkItems";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectItems";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createResourceItemsGroup";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createThemeAttributesGroup";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSampleDataGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

