/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.idea.transport.TransportProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ServerServiceDefinition;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TransportServiceProxy
extends ServiceProxy
implements AndroidDebugBridge.IClientChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    private static final String EMULATOR = "Emulator";
    static final String PRE_LOLLIPOP_FAILURE_REASON = "Pre-Lollipop devices are not supported.";
    private final TransportServiceGrpc.TransportServiceBlockingStub myServiceStub;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final Common.Device myProfilerDevice;
    private final Map<Client, Common.Process> myCachedProcesses;
    private final boolean myIsDeviceApiSupported;
    private final BlockingDeque<Common.Event> myEventQueue;
    private Thread myEventsListenerThread;
    private final Map<Commands.Command.CommandType, TransportProxy.ProxyCommandHandler> myCommandHandlers;
    private final List<TransportEventPreprocessor> myEventPreprocessors;
    private final List<TransportBytesPreprocessor> myDataPreprocessors;
    @NotNull
    private final Map<String, ByteString> myProxyBytesCache;
    private long myLatestEventTimestampNs;
    @Nullable
    private CountDownLatch myEventStreamingLatch;

    private static Logger getLog() {
        return Logger.getInstance(TransportServiceProxy.class);
    }

    public TransportServiceProxy(@NotNull IDevice ddmlibDevice, @NotNull Common.Device transportDevice, @NotNull ManagedChannel channel2, @NotNull BlockingDeque<Common.Event> proxyEventQueue, @NotNull Map<String, ByteString> proxyBytesCache) {
        if (ddmlibDevice == null) {
            TransportServiceProxy.$$$reportNull$$$0(0);
        }
        if (transportDevice == null) {
            TransportServiceProxy.$$$reportNull$$$0(1);
        }
        if (channel2 == null) {
            TransportServiceProxy.$$$reportNull$$$0(2);
        }
        if (proxyEventQueue == null) {
            TransportServiceProxy.$$$reportNull$$$0(3);
        }
        if (proxyBytesCache == null) {
            TransportServiceProxy.$$$reportNull$$$0(4);
        }
        super(TransportServiceGrpc.getServiceDescriptor());
        this.myCachedProcesses = Collections.synchronizedMap(new HashMap());
        this.myCommandHandlers = new HashMap<Commands.Command.CommandType, TransportProxy.ProxyCommandHandler>();
        this.myEventPreprocessors = new ArrayList<TransportEventPreprocessor>();
        this.myDataPreprocessors = new ArrayList<TransportBytesPreprocessor>();
        this.myLatestEventTimestampNs = Long.MIN_VALUE;
        this.myEventStreamingLatch = null;
        this.myDevice = ddmlibDevice;
        this.myProfilerDevice = transportDevice;
        this.myIsDeviceApiSupported = this.myProfilerDevice.getUnsupportedReason().isEmpty();
        this.myServiceStub = TransportServiceGrpc.newBlockingStub((Channel)channel2);
        this.myEventQueue = proxyEventQueue;
        this.myProxyBytesCache = proxyBytesCache;
        TransportServiceProxy.getLog().info(String.format("ProfilerDevice created: %s", this.myProfilerDevice));
        this.updateProcesses();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
    }

    public void registerCommandHandler(Commands.Command.CommandType commandType, TransportProxy.ProxyCommandHandler handler) {
        this.myCommandHandlers.put(commandType, handler);
    }

    public void registerEventPreprocessor(TransportEventPreprocessor eventPreprocessor) {
        this.myEventPreprocessors.add(eventPreprocessor);
    }

    public void registerDataPreprocessor(TransportBytesPreprocessor dataPreprocessor) {
        this.myDataPreprocessors.add(dataPreprocessor);
    }

    @NotNull
    public static Common.Device transportDeviceFromIDevice(@NotNull IDevice device) {
        long device_id;
        if (device == null) {
            TransportServiceProxy.$$$reportNull$$$0(5);
        }
        final StringBuilder bootIdBuilder = new StringBuilder();
        try {
            device.executeShellCommand("cat /proc/sys/kernel/random/boot_id", (IShellOutputReceiver)new MultiLineReceiver(){

                public void processNewLines(String[] lines) {
                    assert (lines.length == 1);
                    bootIdBuilder.append(lines[0]);
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            TransportServiceProxy.getLog().warn(String.format("Unable to retrieve boot_id from device %s", device), e);
        }
        String bootId = bootIdBuilder.toString();
        if (bootId.isEmpty()) {
            bootId = String.valueOf(device.getSerialNumber().hashCode());
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(bootId.getBytes());
            digest.update(device.getSerialNumber().getBytes());
            device_id = ByteBuffer.wrap(digest.digest()).getLong();
        }
        catch (NoSuchAlgorithmException e) {
            TransportServiceProxy.getLog().info("SHA-256 is not available", (Throwable)e);
            device_id = new Random(System.currentTimeMillis()).nextLong();
        }
        Common.Device device2 = Common.Device.newBuilder().setDeviceId(device_id).setSerial(device.getSerialNumber()).setModel(TransportServiceProxy.getDeviceModel(device)).setVersion(StringUtil.notNullize((String)device.getProperty("ro.build.version.release"))).setCodename(StringUtil.notNullize((String)device.getVersion().getCodename())).setApiLevel(device.getVersion().getApiLevel()).setFeatureLevel(device.getVersion().getFeatureLevel()).setManufacturer(TransportServiceProxy.getDeviceManufacturer(device)).setIsEmulator(device.isEmulator()).setState(TransportServiceProxy.convertState(device.getState())).setUnsupportedReason(TransportServiceProxy.getDeviceUnsupportedReason(device)).build();
        if (device2 == null) {
            TransportServiceProxy.$$$reportNull$$$0(6);
        }
        return device2;
    }

    private static Common.Device.State convertState(@NotNull IDevice.DeviceState state) {
        if (state == null) {
            TransportServiceProxy.$$$reportNull$$$0(7);
        }
        switch (state) {
            case OFFLINE: {
                return Common.Device.State.OFFLINE;
            }
            case ONLINE: {
                return Common.Device.State.ONLINE;
            }
            case DISCONNECTED: {
                return Common.Device.State.DISCONNECTED;
            }
        }
        return Common.Device.State.UNSPECIFIED;
    }

    @NotNull
    private static String getDeviceUnsupportedReason(@NotNull IDevice device) {
        if (device == null) {
            TransportServiceProxy.$$$reportNull$$$0(8);
        }
        String unsupportedReason = "";
        if (device.getVersion().getFeatureLevel() < 21) {
            unsupportedReason = PRE_LOLLIPOP_FAILURE_REASON;
        }
        String string = unsupportedReason;
        if (string == null) {
            TransportServiceProxy.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getDeviceModel(@NotNull IDevice device) {
        if (device == null) {
            TransportServiceProxy.$$$reportNull$$$0(10);
        }
        String string = device.isEmulator() ? StringUtil.notNullize((String)device.getAvdName(), (String)"Unknown") : DevicePropertyUtil.getModel(device, "Unknown");
        if (string == null) {
            TransportServiceProxy.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getDeviceManufacturer(@NotNull IDevice device) {
        if (device == null) {
            TransportServiceProxy.$$$reportNull$$$0(12);
        }
        String string = DevicePropertyUtil.getManufacturer(device, device.isEmulator() ? EMULATOR : "");
        if (string == null) {
            TransportServiceProxy.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public void disconnect() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        if (this.myEventStreamingLatch != null) {
            try {
                this.myEventStreamingLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void getDevices(Transport.GetDevicesRequest request, StreamObserver<Transport.GetDevicesResponse> responseObserver) {
        Transport.GetDevicesResponse response = Transport.GetDevicesResponse.newBuilder().addDevice(this.myProfilerDevice).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getEvents(Transport.GetEventsRequest request, StreamObserver<Common.Event> responseObserver) {
        new Thread(() -> {
            Iterator response = this.myServiceStub.getEvents(request);
            try {
                while (response.hasNext()) {
                    Common.Event event = (Common.Event)response.next();
                    if (event == null) continue;
                    this.myEventQueue.offer(event);
                }
            }
            catch (StatusRuntimeException statusRuntimeException) {
                // empty catch block
            }
            if (this.myEventsListenerThread != null) {
                this.myEventsListenerThread.interrupt();
                this.myEventsListenerThread = null;
            }
        }).start();
        this.myEventStreamingLatch = new CountDownLatch(1);
        this.myEventsListenerThread = new Thread(() -> {
            HashMap<Common.Event.Kind, Long2ObjectMap> ongoingEventGroups = new HashMap<Common.Event.Kind, Long2ObjectMap>();
            while (!Thread.currentThread().isInterrupted() || !this.myEventQueue.isEmpty()) {
                try {
                    Common.Event event = this.myEventQueue.take();
                    this.myLatestEventTimestampNs = Math.max(this.myLatestEventTimestampNs, event.getTimestamp());
                    for (TransportEventPreprocessor preprocessor : this.myEventPreprocessors) {
                        if (!preprocessor.shouldPreprocess(event)) continue;
                        preprocessor.preprocessEvent(event).forEach(generatedEvent -> responseObserver.onNext(generatedEvent));
                    }
                    if (event.getIsEnded()) {
                        ongoingEventGroups.computeIfPresent(event.getKind(), (kind, map2) -> {
                            map2.remove(event.getGroupId());
                            return map2.isEmpty() ? null : map2;
                        });
                    } else if (event.getGroupId() != 0L) {
                        ongoingEventGroups.compute(event.getKind(), (kind, map2) -> {
                            if (map2 == null) {
                                map2 = new Long2ObjectOpenHashMap();
                            }
                            map2.put(event.getGroupId(), (Object)event);
                            return map2;
                        });
                    }
                    responseObserver.onNext((Object)event);
                }
                catch (InterruptedException exception) {
                    Thread.currentThread().interrupt();
                }
            }
            for (Common.Event.Kind kind2 : ongoingEventGroups.keySet()) {
                for (Common.Event lastEvent : ((Long2ObjectMap)ongoingEventGroups.get(kind2)).values()) {
                    responseObserver.onNext((Object)this.generateEndEvent(lastEvent));
                }
            }
            responseObserver.onCompleted();
            this.myEventStreamingLatch.countDown();
        }, "EventListenerThread");
        this.myEventsListenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBytes(@NotNull Transport.BytesRequest request, StreamObserver<Transport.BytesResponse> responseObserver) {
        if (request == null) {
            TransportServiceProxy.$$$reportNull$$$0(14);
        }
        Map<String, ByteString> map2 = this.myProxyBytesCache;
        synchronized (map2) {
            Transport.BytesResponse.Builder response;
            if (this.myProxyBytesCache.containsKey(request.getId())) {
                response = Transport.BytesResponse.newBuilder().setContents(this.myProxyBytesCache.get(request.getId()));
                this.myProxyBytesCache.remove(request.getId());
            } else {
                response = this.myServiceStub.getBytes(request).toBuilder();
            }
            for (TransportBytesPreprocessor preprocessor : this.myDataPreprocessors) {
                if (!preprocessor.shouldPreprocess(request)) continue;
                response.setContents(preprocessor.preprocessBytes(request.getId(), response.getContents()));
            }
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        }
    }

    @NotNull
    private Common.Event generateEndEvent(@NotNull Common.Event previousEvent) {
        if (previousEvent == null) {
            TransportServiceProxy.$$$reportNull$$$0(15);
        }
        Common.Event event = Common.Event.newBuilder().setKind(previousEvent.getKind()).setGroupId(previousEvent.getGroupId()).setPid(previousEvent.getPid()).setTimestamp(this.myLatestEventTimestampNs + 1L).setIsEnded(true).build();
        if (event == null) {
            TransportServiceProxy.$$$reportNull$$$0(16);
        }
        return event;
    }

    public void getCurrentTime(Transport.TimeRequest request, StreamObserver<Transport.TimeResponse> responseObserver) {
        Transport.TimeResponse response;
        if (this.myIsDeviceApiSupported) {
            try {
                response = this.myServiceStub.getCurrentTime(request);
            }
            catch (StatusRuntimeException e) {
                responseObserver.onError((Throwable)e);
                return;
            }
        } else {
            response = Transport.TimeResponse.getDefaultInstance();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getProcesses(Transport.GetProcessesRequest request, StreamObserver<Transport.GetProcessesResponse> responseObserver) {
        Transport.GetProcessesResponse response = Transport.GetProcessesResponse.newBuilder().addAllProcess(this.myCachedProcesses.values()).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void execute(Transport.ExecuteRequest request, StreamObserver<Transport.ExecuteResponse> responseObserver) {
        Commands.Command command = request.getCommand();
        Transport.ExecuteResponse response = this.myCommandHandlers.containsKey(command.getType()) && this.myCommandHandlers.get(command.getType()).shouldHandle(command) ? this.myCommandHandlers.get(command.getType()).execute(command) : this.myServiceStub.execute(request);
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void deviceConnected(IDevice device) {
    }

    public void deviceDisconnected(IDevice device) {
    }

    public void deviceChanged(IDevice device, int changeMask) {
        if (device == this.myDevice && (changeMask & 2) != 0) {
            this.updateProcesses();
        }
    }

    public void clientChanged(Client client, int changeMask) {
        if ((changeMask & 1) != 0 && client.getDevice() == this.myDevice && client.getClientData().getClientDescription() != null) {
            this.updateProcesses(Collections.singletonList(client), Collections.EMPTY_LIST);
        }
    }

    @Override
    public ServerServiceDefinition getServiceDefinition() {
        HashMap overrides = Maps.newHashMap();
        overrides.put(TransportServiceGrpc.METHOD_GET_DEVICES, ServerCalls.asyncUnaryCall((request, observer) -> this.getDevices((Transport.GetDevicesRequest)request, (StreamObserver<Transport.GetDevicesResponse>)observer)));
        overrides.put(TransportServiceGrpc.METHOD_GET_PROCESSES, ServerCalls.asyncUnaryCall((request, observer) -> this.getProcesses((Transport.GetProcessesRequest)request, (StreamObserver<Transport.GetProcessesResponse>)observer)));
        overrides.put(TransportServiceGrpc.METHOD_GET_CURRENT_TIME, ServerCalls.asyncUnaryCall((request, observer) -> this.getCurrentTime((Transport.TimeRequest)request, (StreamObserver<Transport.TimeResponse>)observer)));
        overrides.put(TransportServiceGrpc.METHOD_GET_EVENTS, ServerCalls.asyncUnaryCall((request, observer) -> this.getEvents((Transport.GetEventsRequest)request, (StreamObserver<Common.Event>)observer)));
        overrides.put(TransportServiceGrpc.METHOD_GET_BYTES, ServerCalls.asyncUnaryCall((request, observer) -> this.getBytes((Transport.BytesRequest)request, (StreamObserver<Transport.BytesResponse>)observer)));
        overrides.put(TransportServiceGrpc.METHOD_EXECUTE, ServerCalls.asyncUnaryCall((request, observer) -> this.execute((Transport.ExecuteRequest)request, (StreamObserver<Transport.ExecuteResponse>)observer)));
        return this.generatePassThroughDefinitions(overrides, (AbstractStub)this.myServiceStub);
    }

    private void updateProcesses() {
        if (!this.myIsDeviceApiSupported) {
            return;
        }
        Set updatedClients = Arrays.stream(this.myDevice.getClients()).filter(c -> c.getClientData().getClientDescription() != null).collect(Collectors.toSet());
        Set<Client> existingClients = this.myCachedProcesses.keySet();
        ImmutableSet removedClients = Sets.difference(existingClients, updatedClients).immutableCopy();
        ImmutableSet addedClients = Sets.difference(updatedClients, existingClients).immutableCopy();
        this.updateProcesses((Collection<Client>)addedClients, (Collection<Client>)removedClients);
    }

    private void updateProcesses(@NotNull Collection<Client> addedClients, @NotNull Collection<Client> removedClients) {
        Transport.TimeResponse times;
        if (addedClients == null) {
            TransportServiceProxy.$$$reportNull$$$0(17);
        }
        if (removedClients == null) {
            TransportServiceProxy.$$$reportNull$$$0(18);
        }
        if (!this.myIsDeviceApiSupported || !this.myDevice.isOnline()) {
            return;
        }
        try {
            times = this.myServiceStub.getCurrentTime(Transport.TimeRequest.newBuilder().setStreamId(this.myProfilerDevice.getDeviceId()).build());
        }
        catch (Exception e) {
            TransportServiceProxy.getLog().info((Throwable)e);
            return;
        }
        for (Client client : addedClients) {
            String description = client.getClientData().getClientDescription();
            if (description == null) continue;
            String abi = client.getClientData().getAbi();
            String abiCpuArch = abi != null && abi.contains(")") ? abi.substring(abi.indexOf(40) + 1, abi.indexOf(41)) : Abi.getEnum((String)((String)this.myDevice.getAbis().get(0))).getCpuArch();
            Common.Process process2 = Common.Process.newBuilder().setName(client.getClientData().getClientDescription()).setPid(client.getClientData().getPid()).setDeviceId(this.myProfilerDevice.getDeviceId()).setState(Common.Process.State.ALIVE).setStartTimestampNs(times.getTimestampNs()).setAbiCpuArch(abiCpuArch).build();
            this.myCachedProcesses.put(client, process2);
            this.myEventQueue.offer(Common.Event.newBuilder().setGroupId((long)process2.getPid()).setPid(process2.getPid()).setKind(Common.Event.Kind.PROCESS).setProcess(Common.ProcessData.newBuilder().setProcessStarted(Common.ProcessData.ProcessStarted.newBuilder().setProcess(process2))).setTimestamp(times.getTimestampNs()).build());
        }
        this.removeProcesses(removedClients, times.getTimestampNs());
    }

    private void removeProcesses(@NotNull Collection<Client> removedClients, long timestampNs) {
        if (removedClients == null) {
            TransportServiceProxy.$$$reportNull$$$0(19);
        }
        for (Client client : removedClients) {
            Common.Process process2 = this.myCachedProcesses.remove(client);
            if (process2 == null) continue;
            this.myEventQueue.offer(Common.Event.newBuilder().setGroupId((long)process2.getPid()).setPid(process2.getPid()).setKind(Common.Event.Kind.PROCESS).setIsEnded(true).setTimestamp(timestampNs).build());
        }
    }

    @TestOnly
    @NotNull
    Map<Client, Common.Process> getCachedProcesses() {
        Map<Client, Common.Process> map2 = this.myCachedProcesses;
        if (map2 == null) {
            TransportServiceProxy.$$$reportNull$$$0(20);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ddmlibDevice";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transportDevice";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyEventQueue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyBytesCache";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/transport/TransportServiceProxy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousEvent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedClients";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedClients";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/transport/TransportServiceProxy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "transportDeviceFromIDevice";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceUnsupportedReason";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceManufacturer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generateEndEvent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedProcesses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "transportDeviceFromIDevice";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 20: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceUnsupportedReason";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceManufacturer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBytes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateEndEvent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateProcesses";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeProcesses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

