/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.LogService;
import com.android.tools.idea.diagnostics.crash.exception.NoPiiException;
import com.android.tools.idea.transport.EventStreamServer;
import com.android.tools.idea.transport.IntellijLogService;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.profiler.proto.Common;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.messages.MessageBus;
import io.grpc.ManagedChannel;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.internal.ManagedChannelImpl;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class TransportService
implements Disposable {
    private static final String DATASTORE_NAME = "DataStoreService";
    public static final String CHANNEL_NAME = "DataStoreService";
    @NotNull
    private final LogService myLogService;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final DataStoreService myDataStoreService;
    @NotNull
    private final TransportDeviceManager myDeviceManager;
    @NotNull
    private final AtomicInteger myCustomStreamId = new AtomicInteger();
    @NotNull
    private final Map<Long, EventStreamServer> myStreamIdToServerMap = new HashMap<Long, EventStreamServer>();

    public static TransportService getInstance() {
        return (TransportService)ApplicationManager.getApplication().getService(TransportService.class);
    }

    private static Logger getLogger() {
        return Logger.getInstance(TransportService.class);
    }

    @VisibleForTesting
    TransportService() {
        String datastoreDirectory = Paths.get(PathManager.getSystemPath(), ".android").toString() + File.separator;
        this.myLogService = new IntellijLogService();
        this.myDataStoreService = new DataStoreService("DataStoreService", datastoreDirectory, arg_0 -> ((Application)ApplicationManager.getApplication()).executeOnPooledThread(arg_0), this.myLogService);
        this.myDataStoreService.setNoPiiExceptionHandler(t -> TransportService.getLogger().error((Throwable)new NoPiiException((Throwable)t)));
        this.myMessageBus = ApplicationManager.getApplication().getMessageBus();
        this.myDeviceManager = new TransportDeviceManager(this.myDataStoreService, this.myMessageBus, this);
    }

    public void dispose() {
        this.myStreamIdToServerMap.forEach((id, server) -> server.stop());
        this.myStreamIdToServerMap.clear();
        this.myDataStoreService.shutdown();
    }

    @NotNull
    public LogService getLogService() {
        LogService logService = this.myLogService;
        if (logService == null) {
            TransportService.$$$reportNull$$$0(0);
        }
        return logService;
    }

    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            TransportService.$$$reportNull$$$0(1);
        }
        return messageBus;
    }

    @NotNull
    public Common.Stream registerStreamServer(Common.Stream.Type streamType, @NotNull EventStreamServer streamServer) {
        if (streamServer == null) {
            TransportService.$$$reportNull$$$0(2);
        }
        Common.Stream stream = Common.Stream.newBuilder().setStreamId((long)this.myCustomStreamId.incrementAndGet()).setType(streamType).build();
        ManagedChannelImpl channel2 = ((InProcessChannelBuilder)InProcessChannelBuilder.forName((String)streamServer.getServerName()).usePlaintext(true).directExecutor()).build();
        this.myDataStoreService.connect(stream, (ManagedChannel)channel2);
        this.myStreamIdToServerMap.put(stream.getStreamId(), streamServer);
        Common.Stream stream2 = stream;
        if (stream2 == null) {
            TransportService.$$$reportNull$$$0(3);
        }
        return stream2;
    }

    public void unregisterStreamServer(long streamId) {
        if (this.myStreamIdToServerMap.containsKey(streamId)) {
            this.myStreamIdToServerMap.get(streamId).stop();
            this.myDataStoreService.disconnect(streamId);
            this.myStreamIdToServerMap.remove(streamId);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/transport/TransportService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/transport/TransportService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerStreamServer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerStreamServer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

