/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.tools.idea.testartifacts.scopes.ExcludedRoots;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleTestArtifactSearchScopes
implements TestArtifactSearchScopes {
    private static final Key<GradleTestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    @NotNull
    private final Module myModule;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;
    private static final Object ourLock = new Object();
    private DependencySet myMainDependencies;
    private DependencySet myUnitTestDependencies;
    private DependencySet myAndroidTestDependencies;
    private boolean myAlreadyResolved;

    @Nullable
    public static GradleTestArtifactSearchScopes getInstance(@NotNull Module module) {
        if (module == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(0);
        }
        if (module.getProject().isDefault() || GradleSyncState.getInstance(module.getProject()).lastSyncFailed()) {
            return null;
        }
        return (GradleTestArtifactSearchScopes)module.getUserData(SEARCH_SCOPES_KEY);
    }

    public static void initializeScope(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(1);
        }
        GradleTestArtifactSearchScopes scopes = (androidModel = AndroidModuleModel.get(module)) == null ? null : new GradleTestArtifactSearchScopes(module);
        module.putUserData(SEARCH_SCOPES_KEY, (Object)scopes);
    }

    private GradleTestArtifactSearchScopes(@NotNull Module module) {
        if (module == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(2);
        }
        this.myModule = module;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(3);
        }
        return module;
    }

    @Override
    public boolean isAndroidTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(4);
        }
        return this.getAndroidTestSourceScope().accept(file);
    }

    @Override
    public boolean isUnitTestSource(@NotNull VirtualFile file) {
        if (file == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(5);
        }
        return this.getUnitTestSourceScope().accept(file);
    }

    @Override
    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestSourceScope;
        if (fileRootSearchScope == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(6);
        }
        return fileRootSearchScope;
    }

    @Override
    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestSourceScope;
        if (fileRootSearchScope == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(7);
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        if (artifactName == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(8);
        }
        Set<File> roots = Collections.emptySet();
        AndroidModuleModel androidModel = this.getAndroidModel();
        if (androidModel != null) {
            roots = new HashSet();
            if (artifactName.equals("_android_test_") && androidModel.getAndroidProject().getProjectType() == 2) {
                roots.add(androidModel.getRootDirPath());
                for (SourceProvider sourceProvider : androidModel.getActiveSourceProviders()) {
                    roots.addAll(ExcludedRoots.getAllSourceFolders(sourceProvider));
                }
            } else {
                IdeJavaArtifact testArtifact;
                for (SourceProvider sourceProvider : androidModel.getTestSourceProviders(artifactName)) {
                    roots.addAll(ExcludedRoots.getAllSourceFolders(sourceProvider));
                }
                switch (artifactName) {
                    case "_unit_test_": {
                        testArtifact = androidModel.getSelectedVariant().getUnitTestArtifact();
                        break;
                    }
                    case "_android_test_": {
                        testArtifact = androidModel.getSelectedVariant().getAndroidTestArtifact();
                        break;
                    }
                    default: {
                        testArtifact = null;
                    }
                }
                if (testArtifact != null) {
                    roots.addAll(testArtifact.getGeneratedSourceFolders());
                }
            }
        }
        return new FileRootSearchScope(this.myModule.getProject(), roots);
    }

    @Override
    @NotNull
    public FileRootSearchScope getSharedTestExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestExcludeClasspathScope().add(this.getUnitTestExcludeClasspathScope());
        }
        FileRootSearchScope fileRootSearchScope = this.mySharedTestsExcludeScope;
        if (fileRootSearchScope == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(9);
        }
        return fileRootSearchScope;
    }

    @Override
    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getUnitTestSourceScope().subtract(this.getAndroidTestSourceScope());
            this.myAndroidTestExcludeScope = exclude.add(this.getAndroidTestExcludeClasspathScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestExcludeScope;
        if (fileRootSearchScope == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(10);
        }
        return fileRootSearchScope;
    }

    @Override
    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getAndroidTestSourceScope().subtract(this.getUnitTestSourceScope());
            this.myUnitTestExcludeScope = exclude.add(this.getUnitTestExcludeClasspathScope());
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestExcludeScope;
        if (fileRootSearchScope == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(11);
        }
        return fileRootSearchScope;
    }

    @Override
    public boolean includeInUnitTestClasspath(@NotNull File file) {
        if (file == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(12);
        }
        return !this.getUnitTestExcludeScope().accept(file);
    }

    @NotNull
    private FileRootSearchScope getAndroidTestExcludeClasspathScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludeClasspathScope("_android_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myAndroidTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(13);
        }
        return fileRootSearchScope;
    }

    @NotNull
    private FileRootSearchScope getUnitTestExcludeClasspathScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludeClasspathScope("_unit_test_");
        }
        FileRootSearchScope fileRootSearchScope = this.myUnitTestDependencyExcludeScope;
        if (fileRootSearchScope == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(14);
        }
        return fileRootSearchScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileRootSearchScope getExcludeClasspathScope(@NotNull String artifactName) {
        Set<File> excluded;
        if (artifactName == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(15);
        }
        if (this.getAndroidModel() == null) {
            return new FileRootSearchScope(this.myModule.getProject(), Collections.emptyList());
        }
        this.resolveDependencies();
        boolean isAndroidTest = "_android_test_".equals(artifactName);
        Object object = ourLock;
        synchronized (object) {
            DependencySet dependenciesToInclude = isAndroidTest ? this.myAndroidTestDependencies : this.myUnitTestDependencies;
            DependencySet dependenciesToExclude = isAndroidTest ? this.myUnitTestDependencies : this.myAndroidTestDependencies;
            ExcludedModules excludedModules = new ExcludedModules(this.myModule);
            excludedModules.add(dependenciesToExclude);
            excludedModules.remove(dependenciesToInclude);
            excludedModules.remove(this.myMainDependencies);
            ExcludedRoots excludedRoots = new ExcludedRoots(excludedModules, dependenciesToExclude, dependenciesToInclude, isAndroidTest);
            excludedRoots.removeLibraryPaths(this.myMainDependencies);
            excluded = excludedRoots.get();
        }
        return new FileRootSearchScope(this.myModule.getProject(), excluded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void resolveDependencies() {
        AndroidModuleModel androidModel = this.getAndroidModel();
        Object object = ourLock;
        synchronized (object) {
            if (androidModel == null || this.myAlreadyResolved) {
                return;
            }
            this.myAlreadyResolved = true;
            this.extractMainDependencies(androidModel);
            this.extractAndroidTestDependencies(androidModel);
            this.extractUnitTestDependencies(androidModel);
            GradleTestArtifactSearchScopes.mergeSubmoduleDependencies(this.myMainDependencies, this.myMainDependencies, null, null);
            GradleTestArtifactSearchScopes.mergeSubmoduleDependencies(this.myAndroidTestDependencies, this.myAndroidTestDependencies, this.myAndroidTestDependencies, null);
            GradleTestArtifactSearchScopes.mergeSubmoduleDependencies(this.myUnitTestDependencies, this.myUnitTestDependencies, null, this.myUnitTestDependencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractMainDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(16);
        }
        Object object = ourLock;
        synchronized (object) {
            if (this.myMainDependencies == null) {
                this.myMainDependencies = this.extractDependencies(this.getProjectBasePath(), DependencyScope.COMPILE, (IdeBaseArtifact)androidModel.getMainArtifact());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractUnitTestDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(17);
        }
        Object object = ourLock;
        synchronized (object) {
            if (this.myUnitTestDependencies == null) {
                IdeJavaArtifact artifact = androidModel.getSelectedVariant().getUnitTestArtifact();
                this.myUnitTestDependencies = this.extractTestDependencies((IdeBaseArtifact)artifact);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractAndroidTestDependencies(@NotNull AndroidModuleModel androidModel) {
        if (androidModel == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(18);
        }
        Object object = ourLock;
        synchronized (object) {
            if (this.myAndroidTestDependencies == null) {
                IdeAndroidArtifact artifact = androidModel.getSelectedVariant().getAndroidTestArtifact();
                this.myAndroidTestDependencies = this.extractTestDependencies((IdeBaseArtifact)artifact);
            }
        }
    }

    @NotNull
    private DependencySet extractTestDependencies(@Nullable IdeBaseArtifact artifact) {
        return this.extractDependencies(this.getProjectBasePath(), DependencyScope.TEST, artifact);
    }

    @NotNull
    private DependencySet extractDependencies(@NotNull File basePath, @NotNull DependencyScope scope, @Nullable IdeBaseArtifact artifact) {
        if (basePath == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(20);
        }
        if (artifact != null) {
            ModuleFinder moduleFinder = ProjectStructure.getInstance(this.myModule.getProject()).getModuleFinder();
            DependencySet dependencySet = DependenciesExtractor.getInstance().extractFrom(basePath, artifact, scope, moduleFinder);
            if (dependencySet == null) {
                GradleTestArtifactSearchScopes.$$$reportNull$$$0(21);
            }
            return dependencySet;
        }
        DependencySet dependencySet = DependencySet.EMPTY;
        if (dependencySet == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(22);
        }
        return dependencySet;
    }

    @Nullable
    private AndroidModuleModel getAndroidModel() {
        return this.myModule.isDisposed() ? null : AndroidModuleModel.get(this.myModule);
    }

    @NotNull
    private File getProjectBasePath() {
        return new File(Objects.requireNonNull(this.getModule().getProject().getBasePath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeSubmoduleDependencies(@NotNull DependencySet original, @Nullable DependencySet toMergeMain, @Nullable DependencySet toMergeAndroid, @Nullable DependencySet toMergeUnit) {
        if (original == null) {
            GradleTestArtifactSearchScopes.$$$reportNull$$$0(23);
        }
        HashSet<ModuleDependency> moduleDependencies = new HashSet<ModuleDependency>((Collection<ModuleDependency>)original.onModules());
        Object object = ourLock;
        synchronized (object) {
            for (ModuleDependency moduleDependency : moduleDependencies) {
                GradleTestArtifactSearchScopes moduleScope;
                Module module = moduleDependency.getModule();
                if (module == null || (moduleScope = GradleTestArtifactSearchScopes.getInstance(module)) == null) continue;
                moduleScope.resolveDependencies();
                if (toMergeMain != null) {
                    toMergeMain.addAll(moduleScope.myMainDependencies);
                }
                if (toMergeAndroid != null) {
                    toMergeAndroid.addAll(moduleScope.myAndroidTestDependencies);
                }
                if (toMergeUnit == null) continue;
                toMergeUnit.addAll(moduleScope.myUnitTestDependencies);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getMainDependencies() {
        Object object = ourLock;
        synchronized (object) {
            return this.myMainDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getUnitTestDependencies() {
        Object object = ourLock;
        synchronized (object) {
            return this.myUnitTestDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getAndroidTestDependencies() {
        Object object = ourLock;
        synchronized (object) {
            return this.myAndroidTestDependencies;
        }
    }

    public String toString() {
        return this.myModule.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/scopes/GradleTestArtifactSearchScopes";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/GradleTestArtifactSearchScopes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestSourceScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestSourceScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedTestExcludeScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestExcludeScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestExcludeScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidTestExcludeClasspathScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnitTestExcludeClasspathScope";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initializeScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidTestSource";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnitTestSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSourceScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "includeInUnitTestClasspath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeClasspathScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractMainDependencies";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractUnitTestDependencies";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractAndroidTestDependencies";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractDependencies";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mergeSubmoduleDependencies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

