/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeDependencies;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludedRoots {
    @NotNull
    private final ExcludedModules myExcludedModules;
    private final boolean myAndroidTest;
    @NotNull
    private final Set<File> myExcludedRoots;
    @NotNull
    private final Set<String> myIncludedRootNames;

    ExcludedRoots(@NotNull ExcludedModules excludedModules, @NotNull DependencySet dependenciesToExclude, @NotNull DependencySet dependenciesToInclude, boolean isAndroidTest) {
        if (excludedModules == null) {
            ExcludedRoots.$$$reportNull$$$0(0);
        }
        if (dependenciesToExclude == null) {
            ExcludedRoots.$$$reportNull$$$0(1);
        }
        if (dependenciesToInclude == null) {
            ExcludedRoots.$$$reportNull$$$0(2);
        }
        this.myExcludedRoots = new HashSet<File>();
        this.myIncludedRootNames = new HashSet<String>();
        this.myExcludedModules = excludedModules;
        this.myAndroidTest = isAndroidTest;
        this.addFolderPathsFromExcludedModules();
        this.addRemainingModelsIfNecessary();
        for (LibraryDependency libraryDependency : dependenciesToInclude.onLibraries()) {
            File[] binaryPaths;
            for (File binaryPath : binaryPaths = libraryDependency.getBinaryPaths()) {
                this.myIncludedRootNames.add(binaryPath.getName());
            }
        }
        this.addLibraryPaths(dependenciesToExclude);
        this.removeLibraryPaths(dependenciesToInclude);
    }

    private void addFolderPathsFromExcludedModules() {
        for (Module module : this.myExcludedModules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                    this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(sourceFolder.getUrl()));
                }
                CompilerModuleExtension compiler = (CompilerModuleExtension)rootManager.getModuleExtension(CompilerModuleExtension.class);
                String url = compiler.getCompilerOutputUrl();
                if (!StringUtil.isNotEmpty((String)url)) continue;
                this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(url));
            }
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null) continue;
            IdeAndroidArtifact artifact = androidModuleModel.getMainArtifact();
            this.myExcludedRoots.addAll(ExcludedRoots.getAdditionalClasspathFolders((BaseArtifact)artifact));
        }
    }

    @Nullable
    private static File urlToFilePath(@NotNull String url) {
        if (url == null) {
            ExcludedRoots.$$$reportNull$$$0(3);
        }
        if (url.startsWith("jar://")) {
            return FilePaths.getJarFromJarUrl((String)url);
        }
        String path2 = VfsUtilCore.urlToPath((String)url);
        return new File(FileUtils.toSystemDependentPath((String)path2));
    }

    private void addRemainingModelsIfNecessary() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myExcludedModules.getProject());
        for (Module module : moduleManager.getModules()) {
            if (this.myExcludedModules.contains(module)) continue;
            this.addModuleIfNecessary(module);
        }
    }

    private void addModuleIfNecessary(@NotNull Module module) {
        AndroidModuleModel androidModel;
        if (module == null) {
            ExcludedRoots.$$$reportNull$$$0(4);
        }
        if ((androidModel = AndroidModuleModel.get(module)) != null) {
            IdeAndroidArtifact includeArtifact;
            IdeVariant variant = androidModel.getSelectedVariant();
            IdeJavaArtifact unitTestArtifact = variant.getUnitTestArtifact();
            IdeAndroidArtifact androidTestArtifact = variant.getAndroidTestArtifact();
            IdeJavaArtifact excludeArtifact = this.myAndroidTest ? unitTestArtifact : androidTestArtifact;
            Object object = includeArtifact = this.myAndroidTest ? androidTestArtifact : unitTestArtifact;
            if (excludeArtifact != null) {
                ExcludedRoots.processFolders((IdeBaseArtifact)excludeArtifact, androidModel, this.myExcludedRoots::add);
            }
            if (includeArtifact != null) {
                ExcludedRoots.processFolders((IdeBaseArtifact)includeArtifact, androidModel, this.myExcludedRoots::remove);
            }
        }
    }

    private static void processFolders(@NotNull IdeBaseArtifact artifact, @NotNull AndroidModuleModel androidModel, @NotNull Consumer<File> action2) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(5);
        }
        if (androidModel == null) {
            ExcludedRoots.$$$reportNull$$$0(6);
        }
        if (action2 == null) {
            ExcludedRoots.$$$reportNull$$$0(7);
        }
        action2.accept(artifact.getClassesFolder());
        for (File file : artifact.getGeneratedSourceFolders()) {
            action2.accept(file);
        }
        String artifactName = artifact.getName();
        List<SourceProvider> testSourceProviders = androidModel.getTestSourceProviders(artifactName);
        for (SourceProvider sourceProvider : testSourceProviders) {
            for (File file : ExcludedRoots.getAllSourceFolders(sourceProvider)) {
                action2.accept(file);
            }
        }
    }

    public static List<File> getAdditionalClasspathFolders(@NotNull BaseArtifact artifact) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(8);
        }
        return ImmutableList.builder().add((Object)artifact.getJavaResourcesFolder()).addAll((Iterable)artifact.getAdditionalClassesFolders()).build();
    }

    private void addLibraryPaths(@NotNull DependencySet dependencies2) {
        if (dependencies2 == null) {
            ExcludedRoots.$$$reportNull$$$0(9);
        }
        for (LibraryDependency dependency : dependencies2.onLibraries()) {
            Collections.addAll(this.myExcludedRoots, dependency.getBinaryPaths());
        }
    }

    void removeLibraryPaths(@NotNull DependencySet dependencies2) {
        if (dependencies2 == null) {
            ExcludedRoots.$$$reportNull$$$0(10);
        }
        for (Dependency dependency : dependencies2.onModules()) {
            Module module = ((ModuleDependency)dependency).getModule();
            if (module == null) continue;
            this.addLibraryPaths(module);
        }
        for (Dependency dependency : dependencies2.onLibraries()) {
            for (File path2 : ((LibraryDependency)dependency).getBinaryPaths()) {
                this.myExcludedRoots.remove(path2);
            }
        }
    }

    private void addLibraryPaths(@NotNull Module module) {
        AndroidModuleModel model2;
        if (module == null) {
            ExcludedRoots.$$$reportNull$$$0(11);
        }
        if ((model2 = AndroidModuleModel.get(module)) != null) {
            IdeAndroidArtifact include;
            IdeVariant variant = model2.getSelectedVariant();
            IdeJavaArtifact exclude = this.myAndroidTest ? variant.getUnitTestArtifact() : variant.getAndroidTestArtifact();
            Object object = include = this.myAndroidTest ? variant.getAndroidTestArtifact() : variant.getUnitTestArtifact();
            if (exclude != null) {
                this.addLibraryPaths((IdeBaseArtifact)exclude);
            }
            if (include != null) {
                this.removeLibraryPaths((IdeBaseArtifact)include);
            }
        }
    }

    private void addLibraryPaths(@NotNull IdeBaseArtifact artifact) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(12);
        }
        IdeDependencies dependencies2 = artifact.getDependencies();
        dependencies2.forEachLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                for (File file : library.getLocalJars()) {
                    if (this.isAlreadyIncluded(file)) continue;
                    this.myExcludedRoots.add(file);
                }
            }
        });
        dependencies2.forEachJavaLibrary(library -> {
            File jarFile;
            if (StringUtil.isEmpty((String)library.getProject()) && !this.isAlreadyIncluded(jarFile = library.getJarFile())) {
                this.myExcludedRoots.add(jarFile);
            }
        });
    }

    private boolean isAlreadyIncluded(@NotNull File file) {
        if (file == null) {
            ExcludedRoots.$$$reportNull$$$0(13);
        }
        return this.myIncludedRootNames.contains(file.getName());
    }

    private void removeLibraryPaths(@NotNull IdeBaseArtifact artifact) {
        if (artifact == null) {
            ExcludedRoots.$$$reportNull$$$0(14);
        }
        IdeDependencies dependencies2 = artifact.getDependencies();
        dependencies2.forEachLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                for (File file : library.getLocalJars()) {
                    this.myExcludedRoots.remove(file);
                }
            }
        });
        dependencies2.forEachJavaLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                this.myExcludedRoots.remove(library.getJarFile());
            }
        });
    }

    @NotNull
    public Set<File> get() {
        Set<File> set = this.myExcludedRoots;
        if (set == null) {
            ExcludedRoots.$$$reportNull$$$0(15);
        }
        return set;
    }

    public static Collection<File> getAllSourceFolders(SourceProvider provider2) {
        return Stream.of(provider2.getJavaDirectories(), provider2.getResDirectories(), provider2.getAidlDirectories(), provider2.getRenderscriptDirectories(), provider2.getAssetsDirectories(), provider2.getCDirectories(), provider2.getCppDirectories(), provider2.getJniLibsDirectories()).flatMap(it -> it.stream()).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedModules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesToExclude";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesToInclude";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/scopes/ExcludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/ExcludedRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "urlToFilePath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModuleIfNecessary";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processFolders";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalClasspathFolders";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryPaths";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeLibraryPaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyIncluded";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

