/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.adapter;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tools.idea.testartifacts.instrumented.testsuite.AndroidTestResultListener;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuite;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestSuiteResult;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\nH\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J$\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0013H\u0016J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/adapter/DdmlibTestRunListenerAdapter;", "Lcom/android/ddmlib/testrunner/ITestRunListener;", "device", "Lcom/android/ddmlib/IDevice;", "listener", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/AndroidTestResultListener;", "(Lcom/android/ddmlib/IDevice;Lcom/android/tools/idea/testartifacts/instrumented/testsuite/AndroidTestResultListener;)V", "myDevice", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "myTestCases", "", "Lcom/android/ddmlib/testrunner/TestIdentifier;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "myTestSuite", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestSuite;", "testAssumptionFailure", "", "testId", "trace", "", "testEnded", "testMetrics", "testFailed", "testIgnored", "testRunEnded", "elapsedTime", "", "runMetrics", "testRunFailed", "errorMessage", "testRunStarted", "runName", "testCount", "", "testRunStopped", "testStarted", "intellij.android.core"})
public final class DdmlibTestRunListenerAdapter
implements ITestRunListener {
    private final AndroidDevice myDevice;
    private AndroidTestSuite myTestSuite;
    private final Map<TestIdentifier, AndroidTestCase> myTestCases;
    private final AndroidTestResultListener listener;

    public void testRunStarted(@NotNull String runName, int testCount) {
        Intrinsics.checkNotNullParameter((Object)runName, (String)"runName");
        AndroidTestSuite androidTestSuite = this.myTestSuite = new AndroidTestSuite(runName, runName, testCount, null, 8, null);
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        this.listener.onTestSuiteStarted(this.myDevice, androidTestSuite);
    }

    public void testStarted(@NotNull TestIdentifier testId) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        String string = testId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testId.toString()");
        String string2 = testId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"testId.toString()");
        AndroidTestCase testCase = new AndroidTestCase(string, string2, null, 4, null);
        this.myTestCases.put(testId, testCase);
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        this.listener.onTestCaseStarted(this.myDevice, androidTestSuite, testCase);
    }

    public void testFailed(@NotNull TestIdentifier testId, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        AndroidTestCase testCase = (AndroidTestCase)MapsKt.getValue(this.myTestCases, (Object)testId);
        testCase.setResult(AndroidTestCaseResult.FAILED);
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        androidTestSuite.setResult(AndroidTestSuiteResult.FAILED);
    }

    public void testAssumptionFailure(@NotNull TestIdentifier testId, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        AndroidTestCase testCase = (AndroidTestCase)MapsKt.getValue(this.myTestCases, (Object)testId);
        testCase.setResult(AndroidTestCaseResult.FAILED);
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        androidTestSuite.setResult(AndroidTestSuiteResult.FAILED);
    }

    public void testIgnored(@NotNull TestIdentifier testId) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        AndroidTestCase testCase = (AndroidTestCase)MapsKt.getValue(this.myTestCases, (Object)testId);
        testCase.setResult(AndroidTestCaseResult.SKIPPED);
    }

    public void testEnded(@NotNull TestIdentifier testId, @NotNull Map<String, String> testMetrics) {
        Intrinsics.checkNotNullParameter((Object)testId, (String)"testId");
        Intrinsics.checkNotNullParameter(testMetrics, (String)"testMetrics");
        AndroidTestCase testCase = (AndroidTestCase)MapsKt.getValue(this.myTestCases, (Object)testId);
        AndroidTestCaseResult androidTestCaseResult = testCase.getResult();
        if (androidTestCaseResult == null) {
            androidTestCaseResult = AndroidTestCaseResult.PASSED;
        }
        testCase.setResult(androidTestCaseResult);
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        this.listener.onTestCaseFinished(this.myDevice, androidTestSuite, testCase);
    }

    public void testRunFailed(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        androidTestSuite.setResult(AndroidTestSuiteResult.ABORTED);
    }

    public void testRunStopped(long elapsedTime) {
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        androidTestSuite.setResult(AndroidTestSuiteResult.CANCELLED);
    }

    public void testRunEnded(long elapsedTime, @NotNull Map<String, String> runMetrics) {
        AndroidTestSuiteResult androidTestSuiteResult;
        Intrinsics.checkNotNullParameter(runMetrics, (String)"runMetrics");
        AndroidTestSuite androidTestSuite = this.myTestSuite;
        if (androidTestSuite == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        AndroidTestSuite androidTestSuite2 = this.myTestSuite;
        if (androidTestSuite2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        if ((androidTestSuiteResult = androidTestSuite2.getResult()) == null) {
            androidTestSuiteResult = AndroidTestSuiteResult.PASSED;
        }
        androidTestSuite.setResult(androidTestSuiteResult);
        AndroidTestSuite androidTestSuite3 = this.myTestSuite;
        if (androidTestSuite3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTestSuite");
        }
        this.listener.onTestSuiteFinished(this.myDevice, androidTestSuite3);
    }

    public DdmlibTestRunListenerAdapter(@NotNull IDevice device, @NotNull AndroidTestResultListener listener2) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listener = listener2;
        String string = device.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"device.serialNumber");
        String string2 = device.getAvdName();
        if (string2 == null) {
            string2 = device.getSerialNumber();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"device.avdName ?: device.serialNumber");
        this.myDevice = new AndroidDevice(string, string2);
        boolean bl = false;
        this.myTestCases = new LinkedHashMap();
        this.listener.onTestSuiteScheduled(this.myDevice);
    }
}

