/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.TestOptions;
import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.NonGradleApkProvider;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.AndroidTestExtraParam;
import com.android.tools.idea.run.editor.AndroidTestExtraParamKt;
import com.android.tools.idea.run.editor.TestRunParameters;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.ui.BaseAction;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestApplicationLaunchTask;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestConsoleProperties;
import com.android.tools.idea.testartifacts.instrumented.testsuite.AndroidTestSuiteView;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import kotlin.sequences.SequencesKt;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    public static final int TEST_ALL_IN_MODULE = 0;
    public static final int TEST_ALL_IN_PACKAGE = 1;
    public static final int TEST_CLASS = 2;
    public static final int TEST_METHOD = 3;
    public static final String DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS = "android.test.InstrumentationTestRunner";
    public int TESTING_TYPE = 0;
    @NotNull
    public String METHOD_NAME = "";
    @NotNull
    public String CLASS_NAME = "";
    @NotNull
    public String PACKAGE_NAME = "";
    @NotNull
    public String INSTRUMENTATION_RUNNER_CLASS = "";
    @NotNull
    public String EXTRA_OPTIONS = "";
    public boolean INCLUDE_GRADLE_EXTRA_OPTIONS = true;

    public AndroidTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory, true);
        this.putUserData(BaseAction.SHOW_APPLY_CHANGES_UI, true);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(0);
        }
        if (!AndroidModel.isRequired(facet2)) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet2);
        if (androidModel == null) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        IdeAndroidArtifact testArtifact = androidModel.getSelectedVariant().getAndroidTestArtifact();
        String testTask = testArtifact != null ? testArtifact.getAssembleTaskName() : null;
        return new Pair((Object)(testTask != null ? 1 : 0), (Object)AndroidBundle.message("android.cannot.run.library.project.in.this.buildtype", new Object[0]));
    }

    public boolean isGeneratedName() {
        return Objects.equals(this.getName(), this.suggestedName());
    }

    public String suggestedName() {
        if (this.TESTING_TYPE == 1) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{this.PACKAGE_NAME});
        }
        if (this.TESTING_TYPE == 2) {
            return ProgramRunnerUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.CLASS_NAME), (int)0);
        }
        if (this.TESTING_TYPE == 3) {
            return ProgramRunnerUtil.shortenName((String)this.METHOD_NAME, (int)2) + "()";
        }
        return TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(1);
        }
        List<ValidationError> list = this.checkConfiguration(facet2, AndroidModuleModel.get(facet2.getModule()));
        if (list == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    @VisibleForTesting
    List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet2, @Nullable AndroidModuleModel androidModel) {
        IdeAndroidArtifact testArtifact;
        int count;
        if (facet2 == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(3);
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Module module = facet2.getModule();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        switch (this.TESTING_TYPE) {
            case 1: {
                PsiPackage testPackage = facade.findPackage(this.PACKAGE_NAME);
                if (testPackage != null) break;
                errors.add(ValidationError.warning(JUnitBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{this.PACKAGE_NAME})));
                break;
            }
            case 2: {
                PsiClass testClass = null;
                try {
                    testClass = ((JavaRunConfigurationModule)this.getConfigurationModule()).checkModuleAndClassName(this.CLASS_NAME, JUnitBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
                }
                catch (RuntimeConfigurationException e) {
                    errors.add(ValidationError.fromException(e));
                }
                if (testClass == null || JUnitUtil.isTestClass((PsiClass)testClass)) break;
                errors.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                break;
            }
            case 3: {
                errors.addAll(this.checkTestMethod());
            }
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet2.getConfiguration();
        if (!AndroidModel.isRequired(facet2) && !configuration.getState().PACK_TEST_CODE && (count = AndroidTestRunConfiguration.getTestSourceRootCount(module)) > 0) {
            String shortMessage = "Test code not included into APK";
            String fixMessage = "Code and resources under test source " + (count > 1 ? "roots" : "root") + " aren't included into debug APK.\nWould you like to include them and recompile " + module.getName() + " module?\n(You may change this option in Android facet settings later)";
            Runnable quickFix = () -> {
                int result2 = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)fixMessage, (String)"Test code not included into APK", (Icon)Messages.getQuestionIcon());
                if (result2 == 0) {
                    configuration.getState().PACK_TEST_CODE = true;
                }
            };
            errors.add(ValidationError.fatal("Test code not included into APK", quickFix));
        }
        if (androidModel != null && (testArtifact = androidModel.getArtifactForAndroidTest()) == null) {
            IdeVariant selectedVariant = androidModel.getSelectedVariant();
            errors.add(ValidationError.warning("Active build variant \"" + selectedVariant.getName() + "\" does not have a test artifact."));
        }
        ArrayList<ValidationError> arrayList = errors;
        if (arrayList == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected ApkProvider getApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull List<AndroidDevice> targetDevices) {
        if (facet2 == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(5);
        }
        if (applicationIdProvider == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(6);
        }
        if (targetDevices == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(7);
        }
        if (AndroidModel.get(facet2) != null && AndroidModel.get(facet2) instanceof AndroidModuleModel) {
            ApkProvider apkProvider = this.createGradleApkProvider(facet2, applicationIdProvider, true, targetDevices);
            if (apkProvider == null) {
                AndroidTestRunConfiguration.$$$reportNull$$$0(8);
            }
            return apkProvider;
        }
        return new NonGradleApkProvider(facet2, applicationIdProvider, null);
    }

    private static int getTestSourceRootCount(@NotNull Module module) {
        if (module == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(9);
        }
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        return manager.getSourceRoots(true).length - manager.getSourceRoots(false).length;
    }

    private List<ValidationError> checkTestMethod() {
        PsiClass testClass;
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            testClass = configurationModule.checkModuleAndClassName(this.CLASS_NAME, JUnitBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        }
        catch (RuntimeConfigurationException e) {
            return ImmutableList.of((Object)ValidationError.fromException(e));
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (!JUnitUtil.isTestClass((PsiClass)testClass)) {
            errors.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.METHOD_NAME)) {
            errors.add(ValidationError.fatal(JUnitBundle.message((String)"method.name.not.specified.error.message", (Object[])new Object[0])));
        }
        JUnitUtil.TestMethodFilter filter2 = new JUnitUtil.TestMethodFilter(testClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method : testClass.findMethodsByName(this.METHOD_NAME, true)) {
            if (filter2.value(method)) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            testAnnotated = true;
        }
        if (!found) {
            errors.add(ValidationError.warning(JUnitBundle.message((String)"test.method.doesnt.exist.error.message", (Object[])new Object[]{this.METHOD_NAME})));
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)testClass, (String)"org.junit.runner.RunWith", (int)1) && !testAnnotated) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)configurationModule.getModule());
                if (!testClass.isInheritor(testCaseClass, true)) {
                    errors.add(ValidationError.fatal(JUnitBundle.message((String)"class.isnt.inheritor.of.testcase.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                errors.add(ValidationError.warning(ExecutionBundle.message((String)AndroidBundle.message("cannot.find.testcase.error", new Object[0]), (Object[])new Object[0])));
            }
        }
        return errors;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new AndroidRunConfigurationEditor<AndroidTestRunConfiguration>(this.getProject(), (Predicate<AndroidFacet>)((Predicate)facet2 -> facet2 != null && (Boolean)this.supportsRunningLibraryProjects((AndroidFacet)facet2).getFirst() != false), this, false, moduleSelector -> new TestRunParameters(this.getProject(), (ConfigurationModuleSelector)moduleSelector));
    }

    @Override
    @NotNull
    protected ConsoleProvider getConsoleProvider() {
        ConsoleProvider consoleProvider = (parent, handler, executor) -> {
            AndroidTestSuiteView consoleView;
            if (((Boolean)StudioFlags.MULTIDEVICE_INSTRUMENTATION_TESTS.get()).booleanValue() && "Run".equals(executor.getId())) {
                consoleView = new AndroidTestSuiteView();
                consoleView.attachToProcess(handler);
            } else {
                AndroidTestConsoleProperties properties = new AndroidTestConsoleProperties((RunConfiguration)this, executor);
                consoleView = SMTestRunnerConnectionUtil.createAndAttachConsole((String)"Android", (ProcessHandler)handler, (TestConsoleProperties)properties);
            }
            Disposer.register((Disposable)parent, (Disposable)consoleView);
            return consoleView;
        };
        if (consoleProvider == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(10);
        }
        return consoleProvider;
    }

    @Override
    protected boolean supportMultipleDevices() {
        return false;
    }

    @Override
    @Nullable
    protected LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider applicationIdProvider, @NotNull AndroidFacet facet2, @NotNull String contributorsAmStartOptions, boolean waitForDebugger, @NotNull LaunchStatus launchStatus) {
        String testAppId;
        String runner;
        if (applicationIdProvider == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(11);
        }
        if (facet2 == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(12);
        }
        if (contributorsAmStartOptions == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(13);
        }
        if (launchStatus == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(14);
        }
        if (StringUtil.isEmptyOrSpaces((String)(runner = this.INSTRUMENTATION_RUNNER_CLASS))) {
            runner = AndroidTestRunConfiguration.getDefaultInstrumentationRunner(facet2);
        }
        if (StringUtil.isEmptyOrSpaces((String)runner)) {
            launchStatus.terminateLaunch("Unable to determine instrumentation runner", true);
            return null;
        }
        String instrumentationOptions = Joiner.on((String)" ").join((Object)this.getExtraInstrumentationOptions(facet2), (Object)this.getInstrumentationOptions(facet2), new Object[0]);
        try {
            testAppId = applicationIdProvider.getTestPackageName();
            if (testAppId == null) {
                launchStatus.terminateLaunch("Unable to determine test package name", true);
                return null;
            }
        }
        catch (ApkProvisionException e) {
            launchStatus.terminateLaunch("Unable to determine test package name", true);
            return null;
        }
        AndroidModuleModel moduleModel = AndroidModuleModel.get(facet2);
        IdeAndroidArtifact testArtifact = null;
        if (moduleModel != null) {
            testArtifact = moduleModel.getArtifactForAndroidTest();
        }
        switch (this.TESTING_TYPE) {
            case 0: {
                return AndroidTestApplicationLaunchTask.allInModuleTest(runner, testAppId, waitForDebugger, instrumentationOptions, testArtifact);
            }
            case 1: {
                return AndroidTestApplicationLaunchTask.allInPackageTest(runner, testAppId, waitForDebugger, instrumentationOptions, testArtifact, this.PACKAGE_NAME);
            }
            case 2: {
                return AndroidTestApplicationLaunchTask.classTest(runner, testAppId, waitForDebugger, instrumentationOptions, testArtifact, this.CLASS_NAME);
            }
            case 3: {
                return AndroidTestApplicationLaunchTask.methodTest(runner, testAppId, waitForDebugger, instrumentationOptions, testArtifact, this.CLASS_NAME, this.METHOD_NAME);
            }
        }
        launchStatus.terminateLaunch("Unknown testing type is selected", true);
        return null;
    }

    @NotNull
    public static String getDefaultInstrumentationRunner(@Nullable AndroidFacet facet2) {
        if (facet2 == null) {
            return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet2);
        if (androidModel != null) {
            String runner = androidModel.getSelectedVariant().getMergedFlavor().getTestInstrumentationRunner();
            if (StringUtil.isEmptyOrSpaces((String)runner)) {
                return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
            }
            String string = runner;
            if (string == null) {
                AndroidTestRunConfiguration.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = (String)DumbService.getInstance((Project)facet2.getModule().getProject()).runReadActionInSmartMode(() -> {
            Manifest manifest = Manifest.getMainManifest(facet2);
            if (manifest == null) {
                return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
            }
            for (Instrumentation instrumentation : manifest.getInstrumentations()) {
                PsiClass instrumentationClass;
                if (instrumentation == null || (instrumentationClass = (PsiClass)instrumentation.getInstrumentationClass().getValue()) == null) continue;
                return instrumentationClass.getQualifiedName();
            }
            return DEFAULT_ANDROID_INSTRUMENTATION_RUNNER_CLASS;
        });
        if (string == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getExtraInstrumentationOptions(@Nullable AndroidFacet facet2) {
        Collection<Object> extraParams = this.INCLUDE_GRADLE_EXTRA_OPTIONS ? AndroidTestExtraParamKt.merge(AndroidTestExtraParam.parseFromString(this.EXTRA_OPTIONS), AndroidTestExtraParamKt.getAndroidTestExtraParams(facet2)) : SequencesKt.toList(AndroidTestExtraParam.parseFromString(this.EXTRA_OPTIONS));
        String string = extraParams.stream().map(param -> "-e " + param.getNAME() + " " + param.getVALUE()).collect(Collectors.joining(" "));
        if (string == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getInstrumentationOptions(@Nullable AndroidFacet facet2) {
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        boolean isAnimationDisabled = Optional.ofNullable(facet2).map(AndroidModuleModel::get).map(AndroidModuleModel::getArtifactForAndroidTest).map(AndroidArtifact::getTestOptions).map(TestOptions::getAnimationsDisabled).orElse(false);
        if (isAnimationDisabled) {
            builder2.add((Object)"--no-window-animation");
        }
        String string = Joiner.on((String)" ").join((Iterable)builder2.build());
        if (string == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (element instanceof PsiPackage) {
            String pkgName = ((PsiPackage)element).getQualifiedName();
            if (this.TESTING_TYPE == 1 && !Objects.equals(pkgName, this.PACKAGE_NAME)) {
                return null;
            }
            if (this.TESTING_TYPE != 1 && !Objects.equals(pkgName, StringUtil.getPackageName((String)this.CLASS_NAME))) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (newElement instanceof PsiPackage) {
                        String newPkgName = ((PsiPackage)newElement).getQualifiedName();
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = newPkgName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), newPkgName);
                        }
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (newElement instanceof PsiPackage) {
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = oldQualifiedName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), oldQualifiedName);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if ((this.TESTING_TYPE == 2 || this.TESTING_TYPE == 3) && element instanceof PsiClass) {
            if (!StringUtil.equals((CharSequence)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element)), (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)newElement));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = oldQualifiedName;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        if (this.TESTING_TYPE == 3 && element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (!StringUtil.equals((CharSequence)psiMethod.getName(), (CharSequence)this.METHOD_NAME)) {
                return null;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            String fqName = psiClass.getQualifiedName();
            if (fqName != null && !StringUtil.equals((CharSequence)fqName, (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = ((PsiMethod)newElement).getName();
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (oldQualifiedName == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = oldQualifiedName;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElement";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "oldQualifiedName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "elementRenamedOrMoved";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "undoElementMovedOrRenamed";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        return null;
    }

    @Override
    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        LaunchOptions.Builder builder2 = super.getLaunchOptions().setForceStopRunningApp(false);
        if (builder2 == null) {
            AndroidTestRunConfiguration.$$$reportNull$$$0(19);
        }
        return builder2;
    }

    public TestOptions.Execution getTestExecution(@Nullable AndroidFacet facet2) {
        return Optional.ofNullable(facet2).map(f -> AndroidModuleModel.get(f)).map(model2 -> model2.getArtifactForAndroidTest()).map(testArtifact -> testArtifact.getTestOptions()).map(testOptions -> testOptions.getExecution()).orElse(TestOptions.Execution.HOST);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevices";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorsAmStartOptions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getApkProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleProvider";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInstrumentationRunner";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraInstrumentationOptions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstrumentationOptions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supportsRunningLibraryProjects";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkConfiguration";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getApkProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestSourceRootCount";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationLaunchTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

