/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestConfigurator;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.execution.GradleExternalTaskConfigurationType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/AndroidTestConfigurationProducer;", "Lcom/intellij/execution/junit/JavaRunConfigurationProducerBase;", "Lcom/android/tools/idea/testartifacts/instrumented/AndroidTestRunConfiguration;", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElementRef", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "shouldReplace", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "intellij.android.core"})
public final class AndroidTestConfigurationProducer
extends JavaRunConfigurationProducerBase<AndroidTestRunConfiguration> {
    protected boolean setupConfigurationFromContext(@NotNull AndroidTestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElementRef) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElementRef, (String)"sourceElementRef");
        AndroidTestConfigurator androidTestConfigurator = AndroidTestConfigurator.Companion.invoke(context);
        if (androidTestConfigurator == null) {
            return false;
        }
        AndroidTestConfigurator configurator = androidTestConfigurator;
        if (!configurator.configure(configuration, sourceElementRef)) {
            return false;
        }
        return this.setupConfigurationModule(context, configuration);
    }

    public boolean isConfigurationFromContext(@NotNull AndroidTestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RunConfiguration runConfiguration = this.getConfigurationFactory().createTemplateConfiguration(configuration.getProject());
        if (runConfiguration == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration");
        }
        AndroidTestRunConfiguration expectedConfig = (AndroidTestRunConfiguration)runConfiguration;
        AndroidTestConfigurator androidTestConfigurator = AndroidTestConfigurator.Companion.invoke(context);
        if (androidTestConfigurator == null) {
            return false;
        }
        AndroidTestConfigurator configurator = androidTestConfigurator;
        if (!configurator.configure(expectedConfig, (Ref<PsiElement>)new Ref())) {
            return false;
        }
        if (configuration.TESTING_TYPE != expectedConfig.TESTING_TYPE) {
            return false;
        }
        switch (configuration.TESTING_TYPE) {
            case 0: {
                String string = configuration.PACKAGE_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"configuration.PACKAGE_NAME");
                CharSequence charSequence = string;
                boolean bl2 = false;
                if (charSequence.length() == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                bl = Intrinsics.areEqual((Object)configuration.PACKAGE_NAME, (Object)expectedConfig.PACKAGE_NAME);
                break;
            }
            case 2: {
                bl = Intrinsics.areEqual((Object)configuration.CLASS_NAME, (Object)expectedConfig.CLASS_NAME);
                break;
            }
            case 3: {
                if (Intrinsics.areEqual((Object)configuration.CLASS_NAME, (Object)expectedConfig.CLASS_NAME) && Intrinsics.areEqual((Object)configuration.METHOD_NAME, (Object)expectedConfig.METHOD_NAME)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        RunConfiguration runConfiguration = self.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"self.configuration");
        GradleProjectInfo gradleProjectInfo = GradleProjectInfo.getInstance(runConfiguration.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)gradleProjectInfo, (String)"GradleProjectInfo.getIns\u2026lf.configuration.project)");
        return !gradleProjectInfo.isBuildWithGradle() ? false : (other.getConfigurationType() instanceof JUnitConfigurationType ? true : other.getConfigurationType() instanceof GradleExternalTaskConfigurationType);
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        AndroidTestRunConfigurationType androidTestRunConfigurationType = AndroidTestRunConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)androidTestRunConfigurationType, (String)"AndroidTestRunConfigurationType.getInstance()");
        ConfigurationFactory configurationFactory = androidTestRunConfigurationType.getFactory();
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"AndroidTestRunConfigurat\u2026ype.getInstance().factory");
        return configurationFactory;
    }
}

