/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u001d\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0016J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0010H\u0016J\b\u0010&\u001a\u00020\u0006H\u0016J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\bH\u0016J\u0018\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0016J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010.\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0018\u0010/\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\b\u00100\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/tools/idea/templates/recipe/FindReferencesRecipeExecutor;", "Lcom/android/tools/idea/templates/recipe/RecipeExecutor;", "myContext", "Lcom/android/tools/idea/templates/recipe/RenderingContext;", "(Lcom/android/tools/idea/templates/recipe/RenderingContext;)V", "addClasspath", "", "mavenUrl", "", "addDependency", "configuration", "addDynamicFeature", "name", "toModule", "addFilesToOpen", "file", "Ljava/io/File;", "addGlobalVariable", "id", "value", "", "addIncludeToSettings", "moduleName", "addModuleDependency", "addSourceFile", "addSourceSet", "type", "dir", "addTargetFile", "applyPlugin", "plugin", "copy", "from", "to", "instantiate", "merge", "mkDir", "at", "popFolder", "pushFolder", "folder", "requireJavaVersion", "version", "kotlinSupport", "resolveSourceFile", "resolveTargetFile", "setBuildFeature", "setExtVar", "updateAndSync", "intellij.android.core"})
public final class FindReferencesRecipeExecutor
implements RecipeExecutor {
    private final RenderingContext myContext;

    @Override
    public void copy(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (from.isDirectory()) {
            throw (Throwable)new RuntimeException("Directories not supported for Find References");
        }
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void instantiate(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void merge(@NotNull File from, @NotNull File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.addSourceFile(from);
        this.addTargetFile(to);
    }

    @Override
    public void addGlobalVariable(@NotNull String id, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Map<String, Object> map2 = this.myContext.getParamMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"myContext.paramMap");
        map2.put(id, value2);
    }

    @Override
    public void mkDir(@NotNull File at) {
        Intrinsics.checkNotNullParameter((Object)at, (String)"at");
    }

    @Override
    public void addFilesToOpen(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myContext.getFilesToOpen().add(this.resolveTargetFile(file));
    }

    @Override
    public void applyPlugin(@NotNull String plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.myContext.getPlugins().add(plugin);
    }

    @Override
    public void addSourceSet(@NotNull String type, @NotNull String name, @NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
    }

    @Override
    public void setExtVar(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
    }

    @Override
    public void addClasspath(@NotNull String mavenUrl) {
        Intrinsics.checkNotNullParameter((Object)mavenUrl, (String)"mavenUrl");
        this.myContext.getClasspathEntries().add(mavenUrl);
    }

    @Override
    public void addDependency(@NotNull String configuration, @NotNull String mavenUrl) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)mavenUrl, (String)"mavenUrl");
        this.myContext.getDependencies().put((Object)configuration, (Object)mavenUrl);
    }

    @Override
    public void addModuleDependency(@NotNull String configuration, @NotNull String moduleName2, @NotNull String toModule) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)toModule, (String)"toModule");
    }

    @Override
    public void addDynamicFeature(@NotNull String name, @NotNull String toModule) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)toModule, (String)"toModule");
    }

    @Override
    public void updateAndSync() {
    }

    @Override
    public void pushFolder(@NotNull String folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
    }

    @Override
    public void popFolder() {
    }

    @Override
    public void addIncludeToSettings(@Nullable String moduleName2) {
    }

    @Override
    public void setBuildFeature(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
    }

    @Override
    public void requireJavaVersion(@NotNull String version2, @NotNull String kotlinSupport) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)kotlinSupport, (String)"kotlinSupport");
    }

    public final void addSourceFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myContext.getSourceFiles().add(this.resolveSourceFile(file));
    }

    public final void addTargetFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.myContext.getTargetFiles().add(this.resolveTargetFile(file));
    }

    private final File resolveSourceFile(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        try {
            File file2 = this.myContext.getLoader().getSourceFile(file);
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"myContext.loader.getSourceFile(file)");
            return file2;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private final File resolveTargetFile(File file) {
        return file.isAbsolute() ? file : new File(this.myContext.getOutputRoot(), file.getPath());
    }

    public FindReferencesRecipeExecutor(@NotNull RenderingContext myContext) {
        Intrinsics.checkNotNullParameter((Object)myContext, (String)"myContext");
        this.myContext = myContext;
    }
}

