/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.prefs.AndroidLocation;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.SigningConfigModel;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetProperties;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0007J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/templates/KeystoreUtils;", "", "()V", "getCertificate", "Ljava/security/cert/Certificate;", "keyStoreFile", "Ljava/io/File;", "certificateAlias", "", "keyStorePassword", "getDebugKeystore", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "getGradleDebugKeystore", "getOrCreateDefaultDebugKeystore", "sha1", "keyAlias", "intellij.android.core"})
public final class KeystoreUtils {
    public static final KeystoreUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final File getOrCreateDefaultDebugKeystore() throws KeytoolException, AndroidLocation.AndroidLocationException {
        File debugLocation = new File(KeystoreHelper.defaultDebugKeystoreLocation());
        if (!debugLocation.exists()) {
            File keystoreDirectory = new File(AndroidLocation.getFolder());
            if (!keystoreDirectory.canWrite()) {
                throw (Throwable)new AndroidLocation.AndroidLocationException("Could not create debug keystore because \"" + keystoreDirectory + "\" is not writable");
            }
            StdLogger logger2 = new StdLogger(StdLogger.Level.ERROR);
            KeystoreHelper.createDebugStore(null, (File)debugLocation, (String)"android", (String)"android", (String)"AndroidDebugKey", (ILogger)((ILogger)logger2));
        }
        if (!debugLocation.exists()) {
            throw (Throwable)new AndroidLocation.AndroidLocationException("Could not create debug keystore");
        }
        return debugLocation;
    }

    @JvmStatic
    @NotNull
    public static final File getDebugKeystore(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        File gradleDebugKeystore = INSTANCE.getGradleDebugKeystore(facet2);
        if (gradleDebugKeystore != null) {
            return gradleDebugKeystore;
        }
        AndroidFacetConfiguration androidFacetConfiguration = (AndroidFacetConfiguration)facet2.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacetConfiguration, (String)"facet.configuration");
        AndroidFacetProperties androidFacetProperties = androidFacetConfiguration.getState();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacetProperties, (String)"facet.configuration.state");
        AndroidFacetProperties state = androidFacetProperties;
        return state != null && !Strings.isNullOrEmpty((String)state.CUSTOM_DEBUG_KEYSTORE_PATH) ? new File(state.CUSTOM_DEBUG_KEYSTORE_PATH) : KeystoreUtils.getOrCreateDefaultDebugKeystore();
    }

    private final File getGradleDebugKeystore(AndroidFacet facet2) {
        Object v4;
        block6: {
            Module module = facet2.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
            ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get((Project)module.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"ProjectBuildModel.get(facet.module.project)");
            ProjectBuildModel projectBuildModel3 = projectBuildModel2;
            GradleBuildModel gradleBuildModel = projectBuildModel3.getModuleBuildModel(facet2.getModule());
            if (gradleBuildModel == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel, (String)"projectBuildModel.getMod\u2026et.module) ?: return null");
            GradleBuildModel gradleBuildModel2 = gradleBuildModel;
            List list = gradleBuildModel2.android().signingConfigs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"gradleBuildModel.android().signingConfigs()");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SigningConfigModel it = (SigningConfigModel)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)"debug", (Object)it.name())) continue;
                v4 = element$iv;
                break block6;
            }
            v4 = null;
        }
        SigningConfigModel signingConfigModel = v4;
        if (signingConfigModel == null) {
            return null;
        }
        SigningConfigModel signingConfig2 = signingConfigModel;
        String string = signingConfig2.storeFile().valueAsString();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signingConfig.storeFile(\u2026AsString() ?: return null");
        String debugStorePath = string;
        File debugStoreFile = new File(debugStorePath);
        if (debugStoreFile.isAbsolute()) {
            return debugStoreFile;
        }
        File file = AndroidRootUtil.findModuleRootFolderPath(facet2.getModule());
        if (file == null) {
            return debugStoreFile;
        }
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"AndroidRootUtil.findModu\u2026 ?: return debugStoreFile");
        File moduleRoot = file;
        return new File(moduleRoot, debugStorePath);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile, @Nullable String keyAlias2, @Nullable String keyStorePassword) throws Exception {
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        Certificate signingCert = INSTANCE.getCertificate(keyStoreFile, keyAlias2, keyStorePassword);
        try {
            byte[] certBytes = MessageDigest.getInstance("SHA1").digest(signingCert.getEncoded());
            String string = BaseEncoding.base16().withSeparator(":", 2).encode(certBytes);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BaseEncoding.base16().wi\u2026\":\", 2).encode(certBytes)");
            return string;
        }
        catch (Exception e) {
            throw (Throwable)new Exception("Could not compute SHA1 hash from certificate", e);
        }
    }

    public static /* synthetic */ String sha1$default(File file, String string, String string2, int n, Object object) throws Exception {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return KeystoreUtils.sha1(file, string, string2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile, @Nullable String keyAlias2) throws Exception {
        return KeystoreUtils.sha1$default(keyStoreFile, keyAlias2, null, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String sha1(@NotNull File keyStoreFile) throws Exception {
        return KeystoreUtils.sha1$default(keyStoreFile, null, null, 6, null);
    }

    private final Certificate getCertificate(File keyStoreFile, String certificateAlias, String keyStorePassword) throws Exception {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            InputStream inputStream = new FileInputStream(keyStoreFile);
            String string = keyStorePassword;
            if (string == null) {
                string = "android";
            }
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string3.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            keyStore.load(inputStream, cArray);
            String string4 = certificateAlias;
            if (string4 == null) {
                string4 = keyStore.aliases().nextElement();
            }
            Certificate certificate = keyStore.getCertificate(string4);
            Intrinsics.checkNotNullExpressionValue((Object)certificate, (String)"keyStore.getCertificate(\u2026.aliases().nextElement())");
            return certificate;
        }
        catch (GeneralSecurityException exception) {
            throw (Throwable)new Exception("Could not extract certificate from file.", exception);
        }
        catch (IOException exception) {
            throw (Throwable)new Exception("Could not extract certificate from file.", exception);
        }
    }

    private KeystoreUtils() {
    }

    static {
        KeystoreUtils keystoreUtils;
        INSTANCE = keystoreUtils = new KeystoreUtils();
    }
}

