/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.templates.GradleFileMergers;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.CharMatcher;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public final class GradleFilePsiMerger {
    public static String mergeGradleFiles(@NotNull String source, @NotNull String dest, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        if (source == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(0);
        }
        if (dest == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(2);
        }
        source = source.replace("\r", "");
        dest = dest.replace("\r", "");
        if (project.isDefault()) {
            throw new UnsupportedOperationException();
        }
        source = source.trim();
        dest = dest.trim();
        GroovyFile templateBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)source);
        GroovyFile existingBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)dest);
        return (String)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{existingBuildFile}).withName("Merged Gradle Files").compute(() -> {
            GradleFilePsiMerger.addTrailingNewLine(existingBuildFile);
            GradleFilePsiMerger.mergePsi((PsiElement)templateBuildFile, (PsiElement)existingBuildFile, project, supportLibVersionFilter);
            PsiElement formatted = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)existingBuildFile);
            return formatted.getText();
        });
    }

    private static void mergePsi(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        if (fromRoot == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(3);
        }
        if (toRoot == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(5);
        }
        HashSet<PsiElement> destinationChildren = new HashSet<PsiElement>(Arrays.asList(toRoot.getChildren()));
        if (toRoot instanceof GrCallExpression && fromRoot instanceof GrCallExpression) {
            PsiElement[] fromArguments = fromRoot.getLastChild().getChildren();
            PsiElement[] toArguments = toRoot.getLastChild().getChildren();
            if (toArguments.length == 1 && fromArguments.length == 1 && toArguments[0] instanceof GrLiteral && fromArguments[0] instanceof GrLiteral) {
                toArguments[0].replace(fromArguments[0]);
                return;
            }
        }
        if (fromRoot.getFirstChild() != null && fromRoot.getFirstChild().getText().startsWith("apply")) {
            for (PsiElement destination : destinationChildren) {
                if (destination.getFirstChild() == null || !destination.getFirstChild().getText().equalsIgnoreCase("android")) continue;
                toRoot.addBefore(fromRoot, destination);
                GradleFilePsiMerger.ensureCorrectSpacing(fromRoot);
                return;
            }
        }
        for (PsiElement psiElement : fromRoot.getChildren()) {
            PsiElement destination = GradleFilePsiMerger.findEquivalentElement(destinationChildren, psiElement);
            if (destination == null) {
                if (destinationChildren.isEmpty()) {
                    toRoot.add(psiElement);
                    continue;
                }
                if (psiElement instanceof GrAssignmentExpression && psiElement.getChildren().length == 2 && psiElement.getChildren()[1] instanceof GrLiteral && psiElement.getText().startsWith("ext.")) {
                    PsiElement psiElement2 = toRoot.addAfter(psiElement, toRoot.getFirstChild());
                    GradleFilePsiMerger.ensureCorrectSpacing(psiElement2);
                    continue;
                }
                PsiElement psiElement3 = toRoot.addBefore(psiElement, toRoot.getLastChild());
                GradleFilePsiMerger.ensureCorrectSpacing(psiElement3);
                continue;
            }
            if (psiElement.getFirstChild() != null && psiElement.getFirstChild().getText().equalsIgnoreCase("dependencies") && destination.getFirstChild() != null && destination.getFirstChild().getText().equalsIgnoreCase("dependencies")) {
                GradleFilePsiMerger.mergeDependencies(psiElement.getLastChild(), destination.getLastChild(), project, supportLibVersionFilter);
                continue;
            }
            GradleFilePsiMerger.mergePsi(psiElement, destination, project, supportLibVersionFilter);
        }
    }

    private static void mergeDependencies(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        if (fromRoot == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(6);
        }
        if (toRoot == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(7);
        }
        if (project == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(8);
        }
        TreeMap<String, Multimap<String, GradleCoordinate>> dependencies2 = new TreeMap<String, Multimap<String, GradleCoordinate>>(GradleFileMergers.CONFIGURATION_ORDERING);
        ArrayList<String> unparsedDependencies = new ArrayList<String>();
        HashMap originalDependencies = Maps.newHashMap();
        HashMap psiGradleCoordinate = Maps.newHashMap();
        ArrayList<String> originalUnparsedDependencies = new ArrayList<String>();
        GradleFilePsiMerger.pullDependenciesIntoMap(toRoot, originalDependencies, originalUnparsedDependencies, psiGradleCoordinate);
        GradleFilePsiMerger.pullDependenciesIntoMap(fromRoot, dependencies2, unparsedDependencies, null);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        GradleFileMergers.updateExistingDependencies(dependencies2, originalDependencies, psiGradleCoordinate, factory);
        RepositoryUrlManager urlManager = RepositoryUrlManager.get();
        dependencies2.forEach((configurationName, unresolvedDependencies) -> {
            List<GradleCoordinate> resolved = urlManager.resolveDynamicSdkDependencies((Multimap<String, GradleCoordinate>)unresolvedDependencies, supportLibVersionFilter, FileOpUtils.create());
            PsiElement nextElement = GradleFilePsiMerger.findInsertionPoint(toRoot, configurationName);
            for (GradleCoordinate dependency : resolved) {
                GrStatement dependencyElement = factory.createStatementFromText((CharSequence)String.format("%s '%s'\n", configurationName, dependency.toString()));
                PsiElement newElement = toRoot.addBefore((PsiElement)dependencyElement, nextElement);
                toRoot.addAfter(factory.createLineTerminator(1), newElement);
            }
        });
        Set originalSet = originalUnparsedDependencies.stream().map(arg_0 -> ((CharMatcher)CharMatcher.whitespace()).removeFrom(arg_0)).collect(Collectors.toSet());
        for (String dependency : unparsedDependencies) {
            if (originalSet.contains(CharMatcher.whitespace().removeFrom((CharSequence)dependency))) continue;
            GrStatement dependencyElement = factory.createStatementFromText((CharSequence)dependency);
            toRoot.addBefore((PsiElement)dependencyElement, toRoot.getLastChild());
        }
    }

    private static void addTrailingNewLine(@NotNull GroovyFile file) {
        if (file == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(9);
        }
        PsiElement newLineElement = GradleFilePsiMerger.getNewLineElement((PsiElement)file, 1);
        file.addAfter(newLineElement, file.getLastChild());
    }

    @NotNull
    private static PsiElement getNewLineElement(@NotNull PsiElement context, int length) {
        if (context == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(10);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)context.getProject());
        PsiElement psiElement = factory.createLineTerminator(length);
        if (psiElement == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(11);
        }
        return psiElement;
    }

    private static boolean scanForNewLineOrNull(@NotNull PsiElement element, boolean searchForward) {
        if (element == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(12);
        }
        return GradleFilePsiMerger.scanAndCountNewLinesOrNulls(element, searchForward, 1) > 0;
    }

    private static int scanAndCountNewLinesOrNulls(@NotNull PsiElement element, boolean searchForward, int numberOfNewLines) {
        if (element == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(13);
        }
        int foundNewLines = 0;
        HashSet<PsiElement> seen = new HashSet<PsiElement>();
        while (!seen.contains(element)) {
            if (element == null) {
                return Integer.MAX_VALUE;
            }
            if (element.getNode().getElementType().equals(GroovyTokenTypes.mNLS)) {
                foundNewLines += element.getTextLength();
            } else if (!(element instanceof PsiWhiteSpace)) {
                return foundNewLines;
            }
            if (foundNewLines >= numberOfNewLines) {
                return foundNewLines;
            }
            seen.add(element);
            if (!searchForward) {
                element = element.getPrevSibling();
                continue;
            }
            element = element.getNextSibling();
        }
        return Integer.MAX_VALUE;
    }

    private static boolean shouldBeWrappedByNewLines(@NotNull PsiElement element) {
        if (element == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(14);
        }
        return !(element.getParent() == null || !(element instanceof GrMethodCall) && !(element instanceof GrAssignmentExpression) || !(element.getParent() instanceof GroovyFile) && !(element.getParent() instanceof GrClosableBlock));
    }

    private static void ensureCorrectSpacing(@NotNull PsiElement element) {
        if (element == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(15);
        }
        if (!GradleFilePsiMerger.shouldBeWrappedByNewLines(element)) {
            return;
        }
        PsiElement newLineElement = GradleFilePsiMerger.getNewLineElement(element, 1);
        if (element.getParent() instanceof GroovyFile) {
            int newLines;
            int n = newLines = element.getPrevSibling() == null ? -1 : GradleFilePsiMerger.scanAndCountNewLinesOrNulls(element.getPrevSibling(), false, 2);
            if (newLines >= 0 && newLines < 2) {
                PsiElement doubleNewLineElement = GradleFilePsiMerger.getNewLineElement(element, 2 - newLines);
                element.getParent().addBefore(doubleNewLineElement, element);
            }
        } else if (!GradleFilePsiMerger.scanForNewLineOrNull(element.getPrevSibling(), false)) {
            element.getParent().addBefore(newLineElement, element);
        }
        if (!GradleFilePsiMerger.scanForNewLineOrNull(element.getNextSibling(), true)) {
            element.getParent().addAfter(newLineElement, element);
        }
    }

    @NotNull
    private static PsiElement findInsertionPoint(@NotNull PsiElement root2, String configurationName) {
        String currentConfigurationName;
        if (root2 == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(16);
        }
        GrMethodCall current = (GrMethodCall)PsiTreeUtil.getChildOfType((PsiElement)root2, GrMethodCall.class);
        while (current != null && ((currentConfigurationName = GradleFilePsiMerger.getConfigurationName(current)) == null || GradleFileMergers.CONFIGURATION_ORDERING.compare(currentConfigurationName, configurationName) <= 0)) {
            current = (GrMethodCall)PsiTreeUtil.getNextSiblingOfType((PsiElement)current, GrMethodCall.class);
        }
        Object object = current != null ? current : root2.getLastChild();
        if (object == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(17);
        }
        return object;
    }

    @Nullable
    private static String getConfigurationName(@NotNull GrMethodCall element) {
        IElementType elementType;
        PsiElement referenceNameElement;
        GrExpression invokedExpression;
        if (element == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(18);
        }
        if ((invokedExpression = element.getInvokedExpression()) instanceof GrReferenceExpression && (referenceNameElement = ((GrReferenceExpression)invokedExpression).getReferenceNameElement()) instanceof LeafPsiElement && (elementType = ((LeafPsiElement)referenceNameElement).getElementType()) == GroovyTokenTypes.mIDENT) {
            return referenceNameElement.getText();
        }
        return null;
    }

    private static void pullDependenciesIntoMap(@NotNull PsiElement root2, @NotNull Map<String, Multimap<String, GradleCoordinate>> allConfigurations, @NotNull List<String> unparsedDependencies, @Nullable Map<GradleCoordinate, PsiElement> psiGradleCoordinate) {
        if (root2 == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(19);
        }
        if (allConfigurations == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(20);
        }
        if (unparsedDependencies == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(21);
        }
        for (PsiElement existingElem : root2.getChildren()) {
            String coordinateText;
            GradleCoordinate coordinate;
            Object value2;
            PsiElement reference2;
            if (!(existingElem instanceof GrCall) || !((reference2 = existingElem.getFirstChild()) instanceof GrReferenceExpression)) continue;
            String configurationName = reference2.getText();
            boolean parsed = false;
            GrCall call = (GrCall)existingElem;
            GrArgumentList arguments = call.getArgumentList();
            if (arguments == null || call.getClosureArguments().length != 0) continue;
            GrExpression[] expressionArguments = arguments.getExpressionArguments();
            if (expressionArguments.length == 1 && expressionArguments[0] instanceof GrLiteral && (value2 = ((GrLiteral)expressionArguments[0]).getValue()) instanceof String && (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateText = (String)value2))) != null) {
                parsed = true;
                Multimap map2 = allConfigurations.computeIfAbsent(configurationName, k -> LinkedListMultimap.create());
                if (!map2.get((Object)coordinate.getId()).contains(coordinate)) {
                    map2.put((Object)coordinate.getId(), (Object)coordinate);
                    if (psiGradleCoordinate != null) {
                        psiGradleCoordinate.put(coordinate, reference2);
                    }
                }
            }
            if (parsed) continue;
            unparsedDependencies.add(existingElem.getText());
        }
    }

    @Nullable
    private static PsiElement findEquivalentElement(@NotNull Collection<PsiElement> collection2, @NotNull PsiElement element) {
        if (collection2 == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(22);
        }
        if (element == null) {
            GradleFilePsiMerger.$$$reportNull$$$0(23);
        }
        ArrayList matchingItems = Lists.newArrayListWithExpectedSize((int)1);
        for (PsiElement item : collection2) {
            if (item.getText() != null && item.getText().equals(element.getText())) {
                return item;
            }
            if (item.getFirstChild() == null || element.getFirstChild() == null || !item.getFirstChild().getText().equals(element.getFirstChild().getText())) continue;
            matchingItems.add(item);
        }
        if (matchingItems.size() == 1) {
            return (PsiElement)matchingItems.get(0);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromRoot";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/GradleFilePsiMerger";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allConfigurations";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unparsedDependencies";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/GradleFilePsiMerger";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewLineElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findInsertionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeGradleFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergePsi";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "mergeDependencies";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTrailingNewLine";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNewLineElement";
                break;
            }
            case 11: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scanForNewLineOrNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scanAndCountNewLinesOrNulls";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeWrappedByNewLines";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "ensureCorrectSpacing";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findInsertionPoint";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationName";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "pullDependenciesIntoMap";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findEquivalentElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

