/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.idea.stats.UserSentimentPanel;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/stats/UserSentimentProjectComponent;", "Lcom/intellij/ide/ApplicationInitializedListener;", "()V", "componentsInitialized", "", "intellij.android.core"})
final class UserSentimentProjectComponent
implements ApplicationInitializedListener {
    public void componentsInitialized() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (!AnalyticsSettings.getOptedIn()) {
                    return;
                }
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
                if (statusBar == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.ex.StatusBarEx");
                }
                StatusBarEx statusBar2 = (StatusBarEx)statusBar;
                UserSentimentPanel positive = new UserSentimentPanel(project, true);
                UserSentimentPanel negative = new UserSentimentPanel(project, false);
                statusBar2.addWidget((StatusBarWidget)positive, "after ReadOnlyAttribute");
                statusBar2.addWidget((StatusBarWidget)negative, "after " + positive.ID());
                Disposer.register((Disposable)((Disposable)project), (Disposable)new Disposable(statusBar2, positive, negative){
                    final /* synthetic */ StatusBarEx $statusBar;
                    final /* synthetic */ UserSentimentPanel $positive;
                    final /* synthetic */ UserSentimentPanel $negative;

                    public final void dispose() {
                        this.$statusBar.removeWidget(this.$positive.ID());
                        this.$statusBar.removeWidget(this.$negative.ID());
                    }
                    {
                        this.$statusBar = statusBarEx;
                        this.$positive = userSentimentPanel;
                        this.$negative = userSentimentPanel2;
                    }
                });
            }
        });
    }
}

