/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.idea.stats.EditorStatsUtil;
import com.android.tools.idea.stats.TypingLatencyTracker;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.LatencyListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.HdrHistogram.SingleWriterRecorder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/stats/TypingLatencyTracker;", "Lcom/intellij/openapi/editor/actionSystem/LatencyListener;", "()V", "latencyRecorders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/wireless/android/sdk/stats/EditorFileType;", "Lorg/HdrHistogram/SingleWriterRecorder;", "recordTypingLatency", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "", "latencyMs", "", "reportTypingLatency", "intellij.android.core"})
public final class TypingLatencyTracker
implements LatencyListener {
    private static final ConcurrentHashMap<EditorFileType, SingleWriterRecorder> latencyRecorders;
    public static final TypingLatencyTracker INSTANCE;

    public void recordTypingLatency(@NotNull Editor editor2, @NotNull String action2, long latencyMs) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (latencyMs < 0L) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor2.getDocument());
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"FileDocumentManager.getI\u2026ditor.document) ?: return");
        VirtualFile file = virtualFile;
        EditorFileType fileType = EditorStatsUtil.getEditorFileTypeForAnalytics(file);
        SingleWriterRecorder singleWriterRecorder = latencyRecorders.computeIfAbsent(fileType, recordTypingLatency.recorder.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)singleWriterRecorder, (String)"latencyRecorders.compute\u2026SingleWriterRecorder(1) }");
        SingleWriterRecorder recorder2 = singleWriterRecorder;
        recorder2.recordValue(latencyMs);
    }

    public final void reportTypingLatency() {
    }

    private TypingLatencyTracker() {
    }

    static {
        TypingLatencyTracker typingLatencyTracker;
        INSTANCE = typingLatencyTracker = new TypingLatencyTracker();
        latencyRecorders = new ConcurrentHashMap();
    }
}

