/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.prefs.AndroidLocation;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.actions.AndroidActionGroupRemover;
import com.android.tools.idea.actions.AndroidImportModuleAction;
import com.android.tools.idea.actions.AndroidImportProjectAction;
import com.android.tools.idea.actions.AndroidNewModuleAction;
import com.android.tools.idea.actions.AndroidNewModuleInGroupAction;
import com.android.tools.idea.actions.AndroidNewProjectAction;
import com.android.tools.idea.actions.AndroidOpenFileAction;
import com.android.tools.idea.actions.CreateLibraryFromFilesAction;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectSettingsGroup;
import com.android.tools.idea.gradle.actions.AndroidTemplateProjectStructureAction;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.startup.AndroidSdkInitializer;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.wizard.AndroidStudioWelcomeScreenProvider;
import com.android.utils.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.intellij.ide.projectView.actions.MarkRootGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroupTopLevel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSpecificInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(GradleSpecificInitializer.class);
    @NotNull
    public static final String TEMPLATE_PROJECT_SETTINGS_GROUP_ID = "TemplateProjectSettingsGroup";

    @Override
    public void run() {
        GradleSpecificInitializer.setUpNewProjectActions();
        GradleSpecificInitializer.setUpWelcomeScreenActions();
        GradleSpecificInitializer.replaceProjectPopupActions();
        Actions.replaceAction(TEMPLATE_PROJECT_SETTINGS_GROUP_ID, (AnAction)new AndroidTemplateProjectSettingsGroup());
        Actions.hideAction("Groovy.CheckResources.Rebuild");
        Actions.hideAction("Groovy.CheckResources.Make");
        GradleSpecificInitializer.setUpGradleViewToolbarActions();
        GradleSpecificInitializer.checkInstallPath();
        ActionManager actionManager = ActionManager.getInstance();
        AnAction pluginAction = actionManager.getAction("StartupWizard");
        if (pluginAction != null) {
            pluginAction.getTemplatePresentation().setVisible(false);
        }
        if (AndroidSdkUtils.isAndroidSdkManagerEnabled()) {
            try {
                GradleSpecificInitializer.setupSdks();
                GradleSpecificInitializer.checkAndroidSdkHome();
            }
            catch (Exception e) {
                LOG.error("Unexpected error while setting up SDKs: ", (Throwable)e);
            }
            GradleSpecificInitializer.checkAndSetAndroidSdkSources();
        }
    }

    private static void checkInstallPath() {
        if (!PathManager.getHomePath().contains("!")) {
            return;
        }
        String message2 = String.format("%1$s must not be installed in a path containing '!' or Gradle sync will fail!", ApplicationNamesInfo.getInstance().getProductName());
        Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification(message2, NotificationType.ERROR);
        notification.setImportant(true);
        Notifications.Bus.notify((Notification)notification);
    }

    private static void setUpGradleViewToolbarActions() {
        Actions.hideAction("ExternalSystem.RefreshAllProjects");
        Actions.hideAction("ExternalSystem.SelectProjectDataToImport");
    }

    private static void setUpNewProjectActions() {
        Actions.replaceAction("OpenFile", (AnAction)new AndroidOpenFileAction());
        Actions.replaceAction("NewProject", new AndroidNewProjectAction());
        Actions.replaceAction("NewModule", new AndroidNewModuleAction());
        Actions.replaceAction("NewModuleInGroup", new AndroidNewModuleInGroupAction());
        Actions.replaceAction("ImportProject", new AndroidImportProjectAction());
        Actions.replaceAction("CreateLibraryFromFile", new CreateLibraryFromFilesAction());
        Actions.replaceAction("ImportModule", new AndroidImportModuleAction());
        Actions.hideAction("AddFrameworkSupport");
        Actions.hideAction("BuildArtifact");
        Actions.hideAction("RunTargetAction");
    }

    private static void setUpWelcomeScreenActions() {
        System.setProperty("ide.new.welcome.screen.force", "true");
        Actions.replaceAction("WelcomeScreen.OpenProject", (AnAction)new AndroidOpenFileAction("Open an existing Android Studio project"));
        Actions.replaceAction("WelcomeScreen.CreateNewProject", new AndroidNewProjectAction("Start a new Android Studio project"));
        Actions.replaceAction("WelcomeScreen.ImportProject", new AndroidImportProjectAction("Import project (Gradle, Eclipse ADT, etc.)"));
        Actions.replaceAction("WelcomeScreen.Configure.ProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        Actions.replaceAction("TemplateProjectStructure", (AnAction)new AndroidTemplateProjectStructureAction("Default Project Structure..."));
        ActionManager actionManager = ActionManager.getInstance();
        Actions.moveAction("WelcomeScreen.ImportProject", "WelcomeScreen.QuickStart.IDEA", "WelcomeScreen.QuickStart", new Constraints(Anchor.AFTER, "Vcs.VcsClone"), actionManager);
        AnAction getFromVcsAction = actionManager.getAction("Vcs.VcsClone");
        if (getFromVcsAction != null) {
            getFromVcsAction.getTemplatePresentation().setText("Get project from Version Control");
        }
    }

    private static void replaceProjectPopupActions() {
        ArrayDeque<Pair> stack = new ArrayDeque<Pair>();
        stack.add(Pair.of(null, (Object)ActionManager.getInstance().getAction("ProjectViewPopupMenu")));
        while (!stack.isEmpty()) {
            Pair entry = (Pair)stack.pop();
            DefaultActionGroup parent = (DefaultActionGroup)entry.getFirst();
            AnAction action2 = (AnAction)entry.getSecond();
            if (action2 instanceof DefaultActionGroup) {
                DefaultActionGroup actionGroup = (DefaultActionGroup)action2;
                for (AnAction child : actionGroup.getChildActionsOrStubs()) {
                    stack.push(Pair.of((Object)actionGroup, (Object)child));
                }
            }
            if (action2 instanceof MoveModuleToGroupTopLevel) {
                parent.remove(action2);
                parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action2, "Move Module to Group"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
                continue;
            }
            if (!(action2 instanceof MarkRootGroup)) continue;
            parent.remove(action2);
            parent.add((AnAction)new AndroidActionGroupRemover((ActionGroup)action2, "Mark Directory As"), new Constraints(Anchor.AFTER, "OpenModuleSettings"));
        }
    }

    private static void notifyInvalidSdk() {
        String key = "android.invalid.sdk.message";
        String message2 = AndroidBundle.message(key, new Object[0]);
        NotificationListener.Adapter listener2 = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                SdkQuickfixUtils.showAndroidSdkManager();
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/startup/GradleSpecificInitializer$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        GradleSpecificInitializer.addStartupWarning(message2, (NotificationListener)listener2);
    }

    private static void addStartupWarning(@NotNull String message2, @Nullable NotificationListener listener2) {
        if (message2 == null) {
            GradleSpecificInitializer.$$$reportNull$$$0(0);
        }
        Notification notification = GradleSpecificInitializer.getNotificationGroup().createNotification("SDK Validation", message2, NotificationType.WARNING, listener2);
        notification.setImportant(true);
        Notifications.Bus.notify((Notification)notification);
    }

    @NotNull
    private static NotificationGroup getNotificationGroup() {
        NotificationGroup group2 = NotificationGroup.findRegisteredGroup((String)"System Health");
        if (group2 == null) {
            group2 = new NotificationGroup("Gradle Initializer", NotificationDisplayType.STICKY_BALLOON, true);
        }
        NotificationGroup notificationGroup = group2;
        if (notificationGroup == null) {
            GradleSpecificInitializer.$$$reportNull$$$0(1);
        }
        return notificationGroup;
    }

    private static void setupSdks() {
        try {
            GradleSpecificInitializer.repairDuplicateAndroidSdks();
        }
        catch (Throwable e) {
            LOG.error("Failed to remove duplicate Android SDKs", e);
        }
        IdeSdks ideSdks = IdeSdks.getInstance();
        File androidHome = ideSdks.getAndroidSdkPath();
        if (androidHome != null) {
            Validator.Result result2 = PathValidator.forAndroidSdkLocation().validate(androidHome);
            Validator.Severity severity = result2.getSeverity();
            if (severity == Validator.Severity.ERROR) {
                GradleSpecificInitializer.notifyInvalidSdk();
            }
            return;
        }
        Sdk sdk = GradleSpecificInitializer.findFirstAndroidSdk();
        if (sdk != null) {
            String sdkHomePath = sdk.getHomePath();
            assert (sdkHomePath != null);
            ideSdks.createAndroidSdkPerAndroidTarget(FilePaths.toSystemDependentPath((String)sdkHomePath));
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            File androidSdkPath = GradleSpecificInitializer.getAndroidSdkPath();
            if (androidSdkPath == null) {
                return;
            }
            FirstRunWizardMode wizardMode = AndroidStudioWelcomeScreenProvider.getWizardMode();
            boolean promptSdkSelection = wizardMode == null;
            Sdk sdk1 = AndroidSdkUtils.createNewAndroidPlatform(androidSdkPath.getPath(), promptSdkSelection);
            if (sdk1 != null) {
                String sdkNamePrefix = "Android ";
                if (sdk1.getName().startsWith(sdkNamePrefix)) {
                    Sdk jdk;
                    SdkModificator sdkModificator = sdk1.getSdkModificator();
                    sdkModificator.setName(sdkNamePrefix + sdk1.getName().substring(sdkNamePrefix.length()));
                    sdkModificator.commitChanges();
                    AndroidSdkAdditionalData additionalData = AndroidSdks.getInstance().getAndroidSdkAdditionalData(sdk1);
                    if (additionalData != null && (jdk = additionalData.getJavaSdk()) != null) {
                        sdkModificator = jdk.getSdkModificator();
                        sdkModificator.setName("JDK");
                        sdkModificator.commitChanges();
                    }
                    ideSdks.createAndroidSdkPerAndroidTarget(androidSdkPath);
                }
            }
        });
    }

    private static void repairDuplicateAndroidSdks() {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        Sdk[] sdks = jdkTable.getAllJdks();
        if (sdks.length <= 1) {
            return;
        }
        ArrayListMultimap androidSdksByClasses = ArrayListMultimap.create();
        for (Sdk sdk : sdks) {
            if (!sdk.getSdkType().getName().equals("Android SDK")) continue;
            RootProvider rootProvider = sdk.getRootProvider();
            String[] urls = rootProvider.getUrls(OrderRootType.CLASSES);
            androidSdksByClasses.put(Arrays.asList(urls), (Object)sdk);
        }
        if (androidSdksByClasses.size() == androidSdksByClasses.keySet().size()) {
            return;
        }
        for (List classes2 : androidSdksByClasses.keySet()) {
            Collection duplicateSdks = androidSdksByClasses.get((Object)classes2);
            if (duplicateSdks.size() <= 1) continue;
            ApplicationManager.getApplication().runWriteAction(() -> {
                boolean firstSkipped = false;
                for (Sdk sdk : duplicateSdks) {
                    if (firstSkipped) {
                        jdkTable.removeJdk(sdk);
                    }
                    firstSkipped = true;
                }
            });
        }
    }

    private static void checkAndroidSdkHome() {
        try {
            AndroidLocation.checkAndroidSdkHome();
        }
        catch (AndroidLocation.AndroidLocationException e) {
            GradleSpecificInitializer.addStartupWarning(e.getMessage(), null);
        }
    }

    @Nullable
    private static Sdk findFirstAndroidSdk() {
        List<Sdk> sdks = AndroidSdks.getInstance().getAllAndroidSdks();
        if (!sdks.isEmpty()) {
            return sdks.get(0);
        }
        return null;
    }

    @Nullable
    private static File getAndroidSdkPath() {
        return AndroidSdkInitializer.findOrGetAndroidSdkPath();
    }

    private static void checkAndSetAndroidSdkSources() {
        for (Sdk sdk : AndroidSdks.getInstance().getAllAndroidSdks()) {
            GradleSpecificInitializer.checkAndSetSources(sdk);
        }
    }

    private static void checkAndSetSources(@NotNull Sdk sdk) {
        VirtualFile[] storedSources;
        if (sdk == null) {
            GradleSpecificInitializer.$$$reportNull$$$0(2);
        }
        if ((storedSources = sdk.getRootProvider().getFiles(OrderRootType.SOURCES)).length > 0) {
            return;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
        if (platform != null) {
            SdkModificator sdkModificator = sdk.getSdkModificator();
            IAndroidTarget target = platform.getTarget();
            AndroidSdks.getInstance().findAndSetPlatformSources(target, sdkModificator);
            sdkModificator.commitChanges();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/startup/GradleSpecificInitializer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/startup/GradleSpecificInitializer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addStartupWarning";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkAndSetSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

