/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.sqliteEvaluator;

import com.android.tools.idea.lang.androidSql.AndroidSqlLanguage;
import com.android.tools.idea.sqlite.SchemaProvider;
import com.android.tools.idea.sqlite.model.SqliteDatabase;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.sqlLanguage.SqliteSchemaContext;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorPanel;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorView;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LanguageTextField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001)B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010&\u001a\u00020\u0019H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\"H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;", "project", "Lcom/intellij/openapi/project/Project;", "tableView", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "schemaProvider", "Lcom/android/tools/idea/sqlite/SchemaProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/ui/tableView/TableView;Lcom/android/tools/idea/sqlite/SchemaProvider;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "editorTextField", "Lcom/intellij/ui/LanguageTextField;", "evaluatorPanel", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorPanel;", "listeners", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTableView", "()Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "addDatabase", "", "database", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "index", "", "addListener", "listener", "getActiveDatabase", "getSqliteStatement", "", "removeDatabase", "removeListener", "selectDatabase", "setSchemaFromSelectedItem", "showSqliteStatement", "sqliteStatement", "ComboBoxItem", "intellij.android.debuggers"})
public final class SqliteEvaluatorViewImpl
implements SqliteEvaluatorView {
    private final SqliteEvaluatorPanel evaluatorPanel;
    @NotNull
    private final JComponent component;
    private final LanguageTextField editorTextField;
    private final ArrayList<SqliteEvaluatorView.Listener> listeners;
    @NotNull
    private final Project project;
    @NotNull
    private final TableView tableView;
    private final SchemaProvider schemaProvider;

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    private final void setSchemaFromSelectedItem() {
        block1: {
            JComboBox<ComboBoxItem> jComboBox = this.evaluatorPanel.getDatabaseComboBox();
            Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"evaluatorPanel.databaseComboBox");
            Object object = jComboBox.getSelectedItem();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorViewImpl.ComboBoxItem");
            }
            SqliteDatabase database = ((ComboBoxItem)object).getDatabase();
            SqliteSchema schema = this.schemaProvider.getSchema(database);
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.editorTextField.getDocument());
            if (virtualFile == null) break block1;
            virtualFile.putUserData(SqliteSchemaContext.Companion.getSQLITE_SCHEMA_KEY(), (Object)schema);
        }
    }

    @Override
    public void addDatabase(@NotNull SqliteDatabase database, int index) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.evaluatorPanel.getDatabaseComboBox().insertItemAt(new ComboBoxItem(database, database.getName()), index);
        JComboBox<ComboBoxItem> jComboBox = this.evaluatorPanel.getDatabaseComboBox();
        Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"evaluatorPanel.databaseComboBox");
        if (jComboBox.getSelectedIndex() == -1) {
            JComboBox<ComboBoxItem> jComboBox2 = this.evaluatorPanel.getDatabaseComboBox();
            Intrinsics.checkNotNullExpressionValue(jComboBox2, (String)"evaluatorPanel.databaseComboBox");
            jComboBox2.setSelectedIndex(0);
        }
        this.setSchemaFromSelectedItem();
    }

    @Override
    public void selectDatabase(@NotNull SqliteDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        JComboBox<ComboBoxItem> jComboBox = this.evaluatorPanel.getDatabaseComboBox();
        Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"evaluatorPanel.databaseComboBox");
        jComboBox.setSelectedItem(database);
    }

    @Override
    public void removeDatabase(int index) {
        this.evaluatorPanel.getDatabaseComboBox().removeItemAt(index);
    }

    @Override
    @NotNull
    public SqliteDatabase getActiveDatabase() {
        JComboBox<ComboBoxItem> jComboBox = this.evaluatorPanel.getDatabaseComboBox();
        Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"evaluatorPanel.databaseComboBox");
        Object object = jComboBox.getSelectedItem();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorViewImpl.ComboBoxItem");
        }
        return ((ComboBoxItem)object).getDatabase();
    }

    @Override
    @NotNull
    public String getSqliteStatement() {
        String string = this.editorTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editorTextField.text");
        return string;
    }

    @Override
    public void addListener(@NotNull SqliteEvaluatorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull SqliteEvaluatorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void showSqliteStatement(@NotNull String sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        this.editorTextField.setText(sqliteStatement);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public TableView getTableView() {
        return this.tableView;
    }

    public SqliteEvaluatorViewImpl(@NotNull Project project, @NotNull TableView tableView, @NotNull SchemaProvider schemaProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tableView, (String)"tableView");
        Intrinsics.checkNotNullParameter((Object)schemaProvider, (String)"schemaProvider");
        this.project = project;
        this.tableView = tableView;
        this.schemaProvider = schemaProvider;
        this.evaluatorPanel = new SqliteEvaluatorPanel();
        JPanel jPanel = this.evaluatorPanel.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"evaluatorPanel.root");
        this.component = jPanel;
        this.editorTextField = new LanguageTextField((Language)AndroidSqlLanguage.INSTANCE, this.getProject(), "");
        this.listeners = new ArrayList();
        this.evaluatorPanel.getControlsContainer().add((Component)this.editorTextField, "Center");
        this.evaluatorPanel.getRoot().add((Component)this.getTableView().getComponent(), "Center");
        this.evaluatorPanel.getEvaluateButton().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqliteEvaluatorView.Listener it2 = (SqliteEvaluatorView.Listener)element$iv;
                    boolean bl = false;
                    JComboBox<ComboBoxItem> jComboBox = evaluatorPanel.getDatabaseComboBox();
                    Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"evaluatorPanel.databaseComboBox");
                    Object object = jComboBox.getSelectedItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorViewImpl.ComboBoxItem");
                    }
                    SqliteDatabase sqliteDatabase = ((ComboBoxItem)object).getDatabase();
                    String string = editorTextField.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editorTextField.text");
                    it2.evaluateSqlActionInvoked(sqliteDatabase, string);
                }
            }
        });
        this.evaluatorPanel.getDatabaseComboBox().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.setSchemaFromSelectedItem();
            }
        });
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorViewImpl$ComboBoxItem;", "", "database", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "name", "", "(Lcom/android/tools/idea/sqlite/model/SqliteDatabase;Ljava/lang/String;)V", "getDatabase", "()Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.debuggers"})
    public static final class ComboBoxItem {
        @NotNull
        private final SqliteDatabase database;
        @NotNull
        private final String name;

        @NotNull
        public String toString() {
            return this.name;
        }

        @NotNull
        public final SqliteDatabase getDatabase() {
            return this.database;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public ComboBoxItem(@NotNull SqliteDatabase database, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.database = database;
            this.name = name;
        }

        @NotNull
        public final SqliteDatabase component1() {
            return this.database;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final ComboBoxItem copy(@NotNull SqliteDatabase database, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ComboBoxItem(database, name);
        }

        public static /* synthetic */ ComboBoxItem copy$default(ComboBoxItem comboBoxItem, SqliteDatabase sqliteDatabase, String string, int n, Object object) {
            if ((n & 1) != 0) {
                sqliteDatabase = comboBoxItem.database;
            }
            if ((n & 2) != 0) {
                string = comboBoxItem.name;
            }
            return comboBoxItem.copy(sqliteDatabase, string);
        }

        public int hashCode() {
            SqliteDatabase sqliteDatabase = this.database;
            String string = this.name;
            return (sqliteDatabase != null ? sqliteDatabase.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ComboBoxItem)) break block3;
                    ComboBoxItem comboBoxItem = (ComboBoxItem)object;
                    if (!Intrinsics.areEqual((Object)this.database, (Object)comboBoxItem.database) || !Intrinsics.areEqual((Object)this.name, (Object)comboBoxItem.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

