/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import com.android.tools.idea.appinspection.api.AppInspectorClient;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.ImmediateSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveDatabaseConnection$WhenMappings;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteColumnValue;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.sql.protocol.SqliteInspection;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.sql.JDBCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fH\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002J\f\u0010\u0018\u001a\u00020\u001b*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u0017*\u00020\u001eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/live/LiveDatabaseConnection;", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnection;", "messenger", "Lcom/android/tools/idea/appinspection/api/AppInspectorClient$CommandMessenger;", "id", "", "executor", "Ljava/util/concurrent/Executor;", "(Lcom/android/tools/idea/appinspection/api/AppInspectorClient$CommandMessenger;ILjava/util/concurrent/Executor;)V", "taskExecutor", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "close", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "execute", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "getLiveSqliteResultSet", "Lcom/android/tools/idea/sqlite/databaseConnection/live/ImmediateSqliteResultSet;", "cursor", "Lcom/android/tools/sql/protocol/SqliteInspection$Cursor;", "readSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "toSqliteColumn", "Lcom/android/tools/idea/sqlite/model/SqliteColumnValue;", "Lcom/android/tools/sql/protocol/SqliteInspection$CellValue;", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "Lcom/android/tools/sql/protocol/SqliteInspection$Column;", "toSqliteSchema", "Lcom/android/tools/sql/protocol/SqliteInspection$Schema;", "intellij.android.debuggers"})
public final class LiveDatabaseConnection
implements DatabaseConnection {
    private final FutureCallbackExecutor taskExecutor;
    private final AppInspectorClient.CommandMessenger messenger;
    private final int id;

    @Override
    @NotNull
    public ListenableFuture<Unit> close() {
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(Unit)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteSchema> readSchema() {
        SqliteInspection.Commands commands2 = SqliteInspection.Commands.newBuilder().setGetSchema(SqliteInspection.GetSchemaCommand.newBuilder().setId(this.id)).build();
        byte[] byArray = commands2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"commands.toByteArray()");
        ListenableFuture<byte[]> responseFuture = this.messenger.sendRawCommand(byArray);
        ListenableFuture listenableFuture = this.taskExecutor.transform(responseFuture, (FutureCallbackExecutor.ThrowableFunction)new FutureCallbackExecutor.ThrowableFunction<byte[], SqliteSchema>(this){
            final /* synthetic */ LiveDatabaseConnection this$0;

            public final SqliteSchema apply(byte[] it) {
                SqliteInspection.SchemaResponse schemaResponse;
                SqliteInspection.SchemaResponse schemaResponse2 = schemaResponse = SqliteInspection.SchemaResponse.parseFrom((byte[])it);
                Intrinsics.checkNotNullExpressionValue((Object)schemaResponse2, (String)"schemaResponse");
                SqliteInspection.Schema schema = schemaResponse2.getSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"schemaResponse.schema");
                return LiveDatabaseConnection.access$toSqliteSchema(this.this$0, schema);
            }
            {
                this.this$0 = liveDatabaseConnection;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"taskExecutor.transform(r\u2026ma.toSqliteSchema()\n    }");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteResultSet> execute(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        SqliteInspection.QueryCommand.Builder queryBuilder = SqliteInspection.QueryCommand.newBuilder().setQuery(sqliteStatement.assignValuesToParameters()).setDatabaseId(this.id);
        SqliteInspection.Commands command = SqliteInspection.Commands.newBuilder().setQuery(queryBuilder).build();
        byte[] byArray = command.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"command.toByteArray()");
        ListenableFuture<byte[]> responseFuture = this.messenger.sendRawCommand(byArray);
        ListenableFuture listenableFuture = this.taskExecutor.transform(responseFuture, (FutureCallbackExecutor.ThrowableFunction)new FutureCallbackExecutor.ThrowableFunction<byte[], SqliteResultSet>(this){
            final /* synthetic */ LiveDatabaseConnection this$0;

            @Nullable
            public final SqliteResultSet apply(byte[] it) {
                SqliteInspection.Cursor cursor;
                SqliteInspection.Cursor cursor2 = cursor = SqliteInspection.Cursor.parseFrom((byte[])it);
                Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"cursor");
                return cursor2.getRowsList().size() == 0 ? null : LiveDatabaseConnection.access$getLiveSqliteResultSet(this.this$0, cursor);
            }
            {
                this.this$0 = liveDatabaseConnection;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"taskExecutor.transform(r\u2026Set(cursor)\n      }\n    }");
        return listenableFuture;
    }

    /*
     * WARNING - void declaration
     */
    private final ImmediateSqliteResultSet getLiveSqliteResultSet(SqliteInspection.Cursor cursor) {
        void $this$mapTo$iv$iv;
        List list = cursor.getRowsList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cursor.rowsList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it;
            SqliteInspection.Row row = (SqliteInspection.Row)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            List list2 = v1.getValuesList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.valuesList");
            Iterable $this$map$iv2 = list2;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void cellValue;
                SqliteInspection.CellValue cellValue2 = (SqliteInspection.CellValue)item$iv$iv2;
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                void v3 = cellValue;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"cellValue");
                SqliteColumnValue sqliteColumnValue = this.toSqliteColumn((SqliteInspection.CellValue)v3);
                collection3.add(sqliteColumnValue);
            }
            List row2 = (List)destination$iv$iv2;
            SqliteRow sqliteRow = new SqliteRow(row2);
            collection2.add(sqliteRow);
        }
        List rows = (List)destination$iv$iv;
        return new ImmediateSqliteResultSet(rows);
    }

    /*
     * WARNING - void declaration
     */
    private final SqliteSchema toSqliteSchema(SqliteInspection.Schema $this$toSqliteSchema) {
        void $this$mapTo$iv$iv;
        List list = $this$toSqliteSchema.getTablesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tablesList");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void table2;
            SqliteInspection.Table table3 = (SqliteInspection.Table)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = table2;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"table");
            List list2 = v1.getColumnsList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"table.columnsList");
            Iterable $this$map$iv2 = list2;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                SqliteInspection.Column column = (SqliteInspection.Column)item$iv$iv2;
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                void v3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                SqliteColumn sqliteColumn = this.toSqliteColumn((SqliteInspection.Column)v3);
                collection3.add(sqliteColumn);
            }
            List sqliteColumns = (List)destination$iv$iv2;
            String string = table2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"table.name");
            SqliteTable sqliteTable = new SqliteTable(string, sqliteColumns, null, false);
            collection2.add(sqliteTable);
        }
        List tables = (List)destination$iv$iv;
        return new SqliteSchema(tables);
    }

    private final SqliteColumn toSqliteColumn(SqliteInspection.Column $this$toSqliteColumn) {
        JDBCType jDBCType;
        if (Intrinsics.areEqual((Object)$this$toSqliteColumn.getType(), (Object)"TEXT")) {
            jDBCType = JDBCType.VARCHAR;
        } else {
            JDBCType jDBCType2;
            try {
                String string = $this$toSqliteColumn.getType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"type");
                jDBCType2 = JDBCType.valueOf(string);
            }
            catch (Exception e) {
                jDBCType2 = JDBCType.OTHER;
            }
            jDBCType = jDBCType2;
        }
        JDBCType type = jDBCType;
        String string = $this$toSqliteColumn.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return new SqliteColumn(string, type, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final SqliteColumnValue toSqliteColumn(SqliteInspection.CellValue $this$toSqliteColumn) {
        SqliteColumnValue sqliteColumnValue;
        SqliteInspection.CellValue.UnionCase unionCase = $this$toSqliteColumn.getUnionCase();
        if (unionCase != null) {
            switch (LiveDatabaseConnection$WhenMappings.$EnumSwitchMapping$0[unionCase.ordinal()]) {
                case 1: {
                    String string = $this$toSqliteColumn.getColumnName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"columnName");
                    sqliteColumnValue = new SqliteColumnValue(new SqliteColumn(string, JDBCType.VARCHAR, false), $this$toSqliteColumn.getStringValue());
                    return sqliteColumnValue;
                }
                case 2: {
                    String string = $this$toSqliteColumn.getColumnName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"columnName");
                    sqliteColumnValue = new SqliteColumnValue(new SqliteColumn(string, JDBCType.FLOAT, false), Float.valueOf($this$toSqliteColumn.getFloatValue()));
                    return sqliteColumnValue;
                }
                case 3: {
                    String string = $this$toSqliteColumn.getColumnName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"columnName");
                    sqliteColumnValue = new SqliteColumnValue(new SqliteColumn(string, JDBCType.BLOB, false), $this$toSqliteColumn.getBlobValue());
                    return sqliteColumnValue;
                }
                case 4: {
                    String string = $this$toSqliteColumn.getColumnName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"columnName");
                    sqliteColumnValue = new SqliteColumnValue(new SqliteColumn(string, JDBCType.INTEGER, false), $this$toSqliteColumn.getIntValue());
                    return sqliteColumnValue;
                }
            }
        }
        String string = $this$toSqliteColumn.getColumnName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"columnName");
        sqliteColumnValue = new SqliteColumnValue(new SqliteColumn(string, JDBCType.NULL, false), "null");
        return sqliteColumnValue;
    }

    public LiveDatabaseConnection(@NotNull AppInspectorClient.CommandMessenger messenger, int id, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.messenger = messenger;
        this.id = id;
        FutureCallbackExecutor futureCallbackExecutor = FutureCallbackExecutor.wrap((Executor)executor);
        Intrinsics.checkNotNullExpressionValue((Object)futureCallbackExecutor, (String)"FutureCallbackExecutor.wrap(executor)");
        this.taskExecutor = futureCallbackExecutor;
    }

    @Override
    public void dispose() {
        DatabaseConnection.DefaultImpls.dispose(this);
    }

    public static final /* synthetic */ SqliteSchema access$toSqliteSchema(LiveDatabaseConnection $this, SqliteInspection.Schema $this$access_u24toSqliteSchema) {
        return $this.toSqliteSchema($this$access_u24toSqliteSchema);
    }

    public static final /* synthetic */ ImmediateSqliteResultSet access$getLiveSqliteResultSet(LiveDatabaseConnection $this, SqliteInspection.Cursor cursor) {
        return $this.getLiveSqliteResultSet(cursor);
    }
}

