/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection;

import com.android.tools.idea.appinspection.api.AppInspectorClient;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnectionFactory;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcDatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.live.LiveDatabaseConnection;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnectionFactoryImpl;", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnectionFactory;", "()V", "getDatabaseConnection", "Lcom/google/common/util/concurrent/ListenableFuture;", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnection;", "sqliteFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "executor", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "getLiveDatabaseConnection", "messenger", "Lcom/android/tools/idea/appinspection/api/AppInspectorClient$CommandMessenger;", "id", "", "Companion", "intellij.android.debuggers"})
public final class DatabaseConnectionFactoryImpl
implements DatabaseConnectionFactory {
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    @NotNull
    public ListenableFuture<DatabaseConnection> getDatabaseConnection(@NotNull VirtualFile sqliteFile, @NotNull FutureCallbackExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)sqliteFile, (String)"sqliteFile");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        ListenableFuture listenableFuture = executor.executeAsync((Callable)new Callable<DatabaseConnection>(sqliteFile, executor){
            final /* synthetic */ VirtualFile $sqliteFile;
            final /* synthetic */ FutureCallbackExecutor $executor;

            public final DatabaseConnection call() {
                try {
                    String url = "jdbc:sqlite:" + this.$sqliteFile.getPath();
                    Connection connection = DriverManager.getConnection(url);
                    DatabaseConnectionFactoryImpl.access$getLogger$cp().info("Successfully opened database: " + this.$sqliteFile.getPath());
                    Connection connection2 = connection;
                    Intrinsics.checkNotNullExpressionValue((Object)connection2, (String)"connection");
                    return new JdbcDatabaseConnection(connection2, this.$sqliteFile, (Executor)this.$executor);
                }
                catch (Exception e) {
                    throw (Throwable)new Exception("Error opening Sqlite database file \"" + this.$sqliteFile.getPath() + '\"', e);
                }
            }
            {
                this.$sqliteFile = virtualFile;
                this.$executor = futureCallbackExecutor;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"executor.executeAsync {\n\u2026ath}\\\"\", e)\n      }\n    }");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<DatabaseConnection> getLiveDatabaseConnection(@NotNull AppInspectorClient.CommandMessenger messenger, int id, @NotNull FutureCallbackExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)new LiveDatabaseConnection(messenger, id, (Executor)executor));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(\u2026messenger, id, executor))");
        return listenableFuture;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(DatabaseConnectionFactoryImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Datab\u2026nFactoryImpl::class.java)");
        logger = logger2;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnectionFactoryImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android.debuggers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

