/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.controllers;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorController;
import com.android.tools.idea.sqlite.controllers.TableController;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.model.SqliteDatabase;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorView;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0002!\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000bJ\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018H\u0016J\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020\u000fR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$TabController;", "view", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;", "edtExecutor", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "(Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView;Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;)V", "currentTableController", "Lcom/android/tools/idea/sqlite/controllers/TableController;", "listeners", "", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Listener;", "sqliteEvaluatorViewListener", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "addDatabase", "", "database", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "index", "", "addListener", "listener", "dispose", "evaluateSqlStatement", "Lcom/google/common/util/concurrent/ListenableFuture;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "execute", "refreshData", "removeDatabase", "removeListener", "removeListeners", "setUp", "Listener", "SqliteEvaluatorViewListenerImpl", "intellij.android.debuggers"})
public final class SqliteEvaluatorController
implements DatabaseInspectorController.TabController {
    private TableController currentTableController;
    private final SqliteEvaluatorView.Listener sqliteEvaluatorViewListener;
    private final List<Listener> listeners;
    private final SqliteEvaluatorView view;
    private final FutureCallbackExecutor edtExecutor;

    public final void setUp() {
        this.view.addListener(this.sqliteEvaluatorViewListener);
    }

    public final void removeDatabase(int index) {
        this.view.removeDatabase(index);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> refreshData() {
        ListenableFuture listenableFuture = this.currentTableController;
        if (listenableFuture == null || (listenableFuture = listenableFuture.refreshData()) == null) {
            ListenableFuture listenableFuture2 = Futures.immediateFuture((Object)Unit.INSTANCE);
            listenableFuture = listenableFuture2;
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture2, (String)"Futures.immediateFuture(Unit)");
        }
        return listenableFuture;
    }

    public void dispose() {
        this.view.removeListener(this.sqliteEvaluatorViewListener);
        this.listeners.clear();
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public final void removeListeners() {
        this.listeners.clear();
    }

    public final void addDatabase(@NotNull SqliteDatabase database, int index) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.view.addDatabase(database, index);
    }

    @NotNull
    public final ListenableFuture<Unit> evaluateSqlStatement(@NotNull SqliteDatabase database, @NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        this.view.showSqliteStatement(sqliteStatement.assignValuesToParameters());
        this.view.selectDatabase(database);
        return this.execute(database, sqliteStatement);
    }

    private final ListenableFuture<Unit> execute(SqliteDatabase database, SqliteStatement sqliteStatement) {
        SettableFuture settableFuture = SettableFuture.create();
        DatabaseConnection databaseConnection = database.getDatabaseConnection();
        this.edtExecutor.addCallback(databaseConnection.execute(sqliteStatement), (FutureCallback)new FutureCallback<SqliteResultSet>(this, databaseConnection, sqliteStatement, database, settableFuture){
            final /* synthetic */ SqliteEvaluatorController this$0;
            final /* synthetic */ DatabaseConnection $databaseConnection;
            final /* synthetic */ SqliteStatement $sqliteStatement;
            final /* synthetic */ SqliteDatabase $database;
            final /* synthetic */ SettableFuture $settableFuture;

            public void onSuccess(@Nullable SqliteResultSet resultSet) {
                if (resultSet != null) {
                    SqliteEvaluatorController.access$setCurrentTableController$p(this.this$0, new TableController(0, SqliteEvaluatorController.access$getView$p(this.this$0).getTableView(), null, this.$databaseConnection, this.$sqliteStatement, SqliteEvaluatorController.access$getEdtExecutor$p(this.this$0), 1, null));
                    Disposable disposable = this.this$0;
                    TableController tableController = SqliteEvaluatorController.access$getCurrentTableController$p(this.this$0);
                    Intrinsics.checkNotNull((Object)tableController);
                    Disposer.register((Disposable)disposable, (Disposable)tableController);
                    TableController tableController2 = SqliteEvaluatorController.access$getCurrentTableController$p(this.this$0);
                    Intrinsics.checkNotNull((Object)tableController2);
                    tableController2.setUp();
                } else {
                    SqliteEvaluatorController.access$getView$p(this.this$0).getTableView().resetView();
                    SqliteEvaluatorController.access$getView$p(this.this$0).getTableView().setEditable(false);
                    Iterable $this$forEach$iv = SqliteEvaluatorController.access$getListeners$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Listener it = (Listener)element$iv;
                        boolean bl = false;
                        it.onSchemaUpdated(this.$database);
                    }
                }
                this.$settableFuture.set((Object)Unit.INSTANCE);
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                SqliteEvaluatorController.access$getView$p(this.this$0).getTableView().reportError("Error executing SQLite statement", t);
                this.$settableFuture.setException(t);
            }
            {
                this.this$0 = this$0;
                this.$databaseConnection = $captured_local_variable$1;
                this.$sqliteStatement = $captured_local_variable$2;
                this.$database = $captured_local_variable$3;
                this.$settableFuture = $captured_local_variable$4;
            }
        });
        SettableFuture settableFuture2 = settableFuture;
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture2, (String)"settableFuture");
        return (ListenableFuture)settableFuture2;
    }

    public SqliteEvaluatorController(@NotNull SqliteEvaluatorView view, @NotNull FutureCallbackExecutor edtExecutor) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)edtExecutor, (String)"edtExecutor");
        this.view = view;
        this.edtExecutor = edtExecutor;
        this.sqliteEvaluatorViewListener = new SqliteEvaluatorViewListenerImpl();
        boolean bl = false;
        this.listeners = new ArrayList();
    }

    public static final /* synthetic */ TableController access$getCurrentTableController$p(SqliteEvaluatorController $this) {
        return $this.currentTableController;
    }

    public static final /* synthetic */ void access$setCurrentTableController$p(SqliteEvaluatorController $this, TableController tableController) {
        $this.currentTableController = tableController;
    }

    public static final /* synthetic */ SqliteEvaluatorView access$getView$p(SqliteEvaluatorController $this) {
        return $this.view;
    }

    public static final /* synthetic */ FutureCallbackExecutor access$getEdtExecutor$p(SqliteEvaluatorController $this) {
        return $this.edtExecutor;
    }

    public static final /* synthetic */ List access$getListeners$p(SqliteEvaluatorController $this) {
        return $this.listeners;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$SqliteEvaluatorViewListenerImpl;", "Lcom/android/tools/idea/sqlite/ui/sqliteEvaluator/SqliteEvaluatorView$Listener;", "(Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController;)V", "evaluateSqlActionInvoked", "", "database", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "sqliteStatement", "", "intellij.android.debuggers"})
    private final class SqliteEvaluatorViewListenerImpl
    implements SqliteEvaluatorView.Listener {
        @Override
        public void evaluateSqlActionInvoked(@NotNull SqliteDatabase database, @NotNull String sqliteStatement) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
            SqliteEvaluatorController.this.evaluateSqlStatement(database, new SqliteStatement(sqliteStatement, CollectionsKt.emptyList()));
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Listener;", "", "onSchemaUpdated", "", "database", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "intellij.android.debuggers"})
    public static interface Listener {
        public void onSchemaUpdated(@NotNull SqliteDatabase var1);
    }
}

