/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.controllers;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.device.fs.DownloadProgress;
import com.android.tools.idea.sqlite.DatabaseInspectorProjectService;
import com.android.tools.idea.sqlite.SchemaProvider;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorController;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorControllerImpl;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorControllerImpl$addNewDatabase$;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorControllerImpl$closeDatabase$;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorControllerImpl$dispose$;
import com.android.tools.idea.sqlite.controllers.SqliteEvaluatorController;
import com.android.tools.idea.sqlite.controllers.TabId;
import com.android.tools.idea.sqlite.controllers.TableController;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcUtilsKt;
import com.android.tools.idea.sqlite.model.FileSqliteDatabase;
import com.android.tools.idea.sqlite.model.SqliteDatabase;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.ui.DatabaseInspectorViewsFactory;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorView;
import com.android.tools.idea.sqlite.ui.sqliteEvaluator.SqliteEvaluatorView;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u000223B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0 H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0013H\u0002J\b\u0010%\u001a\u00020\u001aH\u0016J\b\u0010&\u001a\u00020'H\u0002J$\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001a0*H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001a0 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u001aH\u0016J\u0010\u0010/\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u00100\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001eH\u0002R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00060\u0016R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorControllerImpl;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$Model;", "viewFactory", "Lcom/android/tools/idea/sqlite/ui/DatabaseInspectorViewsFactory;", "edtExecutor", "Ljava/util/concurrent/Executor;", "taskExecutor", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$Model;Lcom/android/tools/idea/sqlite/ui/DatabaseInspectorViewsFactory;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "resultSetControllers", "", "Lcom/android/tools/idea/sqlite/controllers/TabId;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$TabController;", "sqliteViewListener", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorControllerImpl$SqliteViewListenerImpl;", "view", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorView;", "addNewDatabase", "", "database", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "sqliteSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "addSqliteDatabase", "Lcom/google/common/util/concurrent/ListenableFuture;", "sqliteDatabaseFuture", "closeDatabase", "closeTab", "tabId", "dispose", "openNewEvaluatorTab", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController;", "readDatabaseSchema", "onSchemaRead", "Lkotlin/Function1;", "runSqlStatement", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "setUp", "updateDatabaseSchema", "updateExistingDatabaseSchemaView", "newSqliteSchema", "SqliteEvaluatorControllerListenerImpl", "SqliteViewListenerImpl", "intellij.android.debuggers"})
public final class DatabaseInspectorControllerImpl
implements DatabaseInspectorController {
    private final FutureCallbackExecutor edtExecutor;
    private final FutureCallbackExecutor taskExecutor;
    private final DatabaseInspectorView view;
    private final Map<TabId, DatabaseInspectorController.TabController> resultSetControllers;
    private final SqliteViewListenerImpl sqliteViewListener;
    private final Project project;
    private final DatabaseInspectorController.Model model;
    private final DatabaseInspectorViewsFactory viewFactory;

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.view.getComponent();
    }

    @Override
    public void setUp() {
        this.view.addListener(this.sqliteViewListener);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> addSqliteDatabase(@NotNull ListenableFuture<SqliteDatabase> sqliteDatabaseFuture) {
        Intrinsics.checkNotNullParameter(sqliteDatabaseFuture, (String)"sqliteDatabaseFuture");
        SettableFuture settableFuture = SettableFuture.create();
        this.view.startLoading("Getting database...");
        this.taskExecutor.addCallback(sqliteDatabaseFuture, (FutureCallback)new FutureCallback<SqliteDatabase>(this, settableFuture){
            final /* synthetic */ DatabaseInspectorControllerImpl this$0;
            final /* synthetic */ SettableFuture $settableFuture;

            public void onSuccess(@Nullable SqliteDatabase sqliteDatabase) {
                if (Disposer.isDisposed((Disposable)this.this$0)) {
                    return;
                }
                Disposable disposable = this.this$0;
                SqliteDatabase sqliteDatabase2 = sqliteDatabase;
                Intrinsics.checkNotNull((Object)sqliteDatabase2);
                Disposer.register((Disposable)disposable, (Disposable)sqliteDatabase2.getDatabaseConnection());
                DatabaseInspectorControllerImpl.access$readDatabaseSchema(this.this$0, sqliteDatabase, (Function1)new Function1<SqliteSchema, Unit>(this, sqliteDatabase){
                    final /* synthetic */ addSqliteDatabase.1 this$0;
                    final /* synthetic */ SqliteDatabase $sqliteDatabase;

                    public final void invoke(@NotNull SqliteSchema schema) {
                        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                        DatabaseInspectorControllerImpl.access$addNewDatabase(this.this$0.this$0, this.$sqliteDatabase, schema);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$sqliteDatabase = sqliteDatabase;
                        super(1);
                    }
                });
                this.$settableFuture.set((Object)Unit.INSTANCE);
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                DatabaseInspectorControllerImpl.access$getView$p(this.this$0).reportError("Error getting database", t);
                this.$settableFuture.setException(t);
            }
            {
                this.this$0 = this$0;
                this.$settableFuture = $captured_local_variable$1;
            }
        });
        SettableFuture settableFuture2 = settableFuture;
        Intrinsics.checkNotNullExpressionValue((Object)settableFuture2, (String)"settableFuture");
        return (ListenableFuture)settableFuture2;
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> runSqlStatement(@NotNull SqliteDatabase database, @NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        SqliteEvaluatorController sqliteEvaluatorController = this.openNewEvaluatorTab();
        return sqliteEvaluatorController.evaluateSqlStatement(database, sqliteStatement);
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> closeDatabase(@NotNull SqliteDatabase database) {
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        if (!this.model.getOpenDatabases().containsKey(database)) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(Unit)");
            return listenableFuture;
        }
        Iterable $this$filterIsInstance$iv = this.resultSetControllers.keySet();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TabId.TableTab)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            TabId.TableTab it = (TabId.TableTab)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getDatabase(), (Object)database)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tabsToClose = (List)destination$iv$iv;
        Iterable $this$forEach$iv = tabsToClose;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TabId.TableTab it = (TabId.TableTab)element$iv;
            boolean bl = false;
            this.closeTab(it);
        }
        int index = this.model.getSortedIndexOf(database);
        Sequence $this$filterIsInstance$iv2 = CollectionsKt.asSequence((Iterable)this.resultSetControllers.values());
        boolean $i$f$filterIsInstance2 = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)closeDatabase$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence $this$forEach$iv2 = sequence;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            SqliteEvaluatorController it = (SqliteEvaluatorController)element$iv;
            boolean bl = false;
            it.removeDatabase(index);
        }
        this.view.removeDatabaseSchema(database);
        this.model.remove(database);
        ListenableFuture listenableFuture = this.taskExecutor.executeAsync((Callable)new Callable<Unit>(database){
            final /* synthetic */ SqliteDatabase $database;

            public final void call() {
                Disposer.dispose((Disposable)this.$database.getDatabaseConnection());
            }
            {
                this.$database = sqliteDatabase;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"taskExecutor.executeAsyn\u2026databaseConnection)\n    }");
        return listenableFuture;
    }

    public void dispose() {
        this.view.removeListener(this.sqliteViewListener);
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.resultSetControllers.values());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)dispose$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence $this$forEach$iv = sequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteEvaluatorController it = (SqliteEvaluatorController)element$iv;
            boolean bl = false;
            it.removeListeners();
        }
    }

    private final void readDatabaseSchema(SqliteDatabase database, Function1<? super SqliteSchema, Unit> onSchemaRead) {
        ListenableFuture<SqliteSchema> futureSchema = database.getDatabaseConnection().readSchema();
        this.edtExecutor.addListener(futureSchema, new Runnable(this){
            final /* synthetic */ DatabaseInspectorControllerImpl this$0;

            public final void run() {
                if (!Disposer.isDisposed((Disposable)this.this$0)) {
                    DatabaseInspectorControllerImpl.access$getView$p(this.this$0).stopLoading();
                }
            }
            {
                this.this$0 = databaseInspectorControllerImpl;
            }
        });
        this.edtExecutor.addCallback(futureSchema, (FutureCallback)new FutureCallback<SqliteSchema>(this, onSchemaRead){
            final /* synthetic */ DatabaseInspectorControllerImpl this$0;
            final /* synthetic */ Function1 $onSchemaRead;

            public void onSuccess(@Nullable SqliteSchema sqliteSchema) {
                block0: {
                    SqliteSchema sqliteSchema2 = sqliteSchema;
                    if (sqliteSchema2 == null) break block0;
                    SqliteSchema sqliteSchema3 = sqliteSchema2;
                    boolean bl = false;
                    boolean bl2 = false;
                    SqliteSchema it = sqliteSchema3;
                    boolean bl3 = false;
                    this.$onSchemaRead.invoke((Object)sqliteSchema);
                }
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (!Disposer.isDisposed((Disposable)this.this$0)) {
                    DatabaseInspectorControllerImpl.access$getView$p(this.this$0).reportError("Error reading Sqlite database", t);
                }
            }
            {
                this.this$0 = this$0;
                this.$onSchemaRead = $captured_local_variable$1;
            }
        });
    }

    private final void addNewDatabase(SqliteDatabase database, SqliteSchema sqliteSchema) {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        int index = this.model.getSortedIndexOf(database);
        this.view.addDatabaseSchema(database, sqliteSchema, index);
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)this.resultSetControllers.values());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)addNewDatabase$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        Sequence $this$forEach$iv = sequence;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteEvaluatorController it = (SqliteEvaluatorController)element$iv;
            boolean bl = false;
            it.addDatabase(database, index);
        }
        this.model.add(database, sqliteSchema);
    }

    private final void closeTab(TabId tabId) {
        block0: {
            DatabaseInspectorController.TabController controller2;
            this.view.closeTab(tabId);
            DatabaseInspectorController.TabController tabController = controller2 = this.resultSetControllers.remove(tabId);
            if (tabController == null) break block0;
            DatabaseInspectorController.TabController tabController2 = tabController;
            boolean bl = false;
            boolean bl2 = false;
            Disposable p1 = tabController2;
            boolean bl3 = false;
            Disposer.dispose((Disposable)p1);
        }
    }

    private final void updateDatabaseSchema(SqliteDatabase database) {
        this.readDatabaseSchema(database, (Function1<? super SqliteSchema, Unit>)((Function1)new Function1<SqliteSchema, Unit>(this, database){
            final /* synthetic */ DatabaseInspectorControllerImpl this$0;
            final /* synthetic */ SqliteDatabase $database;

            public final void invoke(@NotNull SqliteSchema newSchema) {
                Intrinsics.checkNotNullParameter((Object)newSchema, (String)"newSchema");
                DatabaseInspectorControllerImpl.access$updateExistingDatabaseSchemaView(this.this$0, this.$database, newSchema);
                DatabaseInspectorControllerImpl.access$getModel$p(this.this$0).add(this.$database, newSchema);
            }
            {
                this.this$0 = databaseInspectorControllerImpl;
                this.$database = sqliteDatabase;
                super(1);
            }
        }));
    }

    private final void updateExistingDatabaseSchemaView(SqliteDatabase database, SqliteSchema newSqliteSchema) {
        Iterable $this$sortedBy$iv = newSqliteSchema.getTables();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List toAdd = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                SqliteTable it = (SqliteTable)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (SqliteTable)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        this.view.updateDatabase(database, toAdd);
    }

    /*
     * WARNING - void declaration
     */
    private final SqliteEvaluatorController openNewEvaluatorTab() {
        TabId.AdHocQueryTab tabId = new TabId.AdHocQueryTab();
        SqliteEvaluatorView sqliteEvaluatorView2 = this.viewFactory.createEvaluatorView(this.project, new SchemaProvider(this){
            final /* synthetic */ DatabaseInspectorControllerImpl this$0;

            @Nullable
            public SqliteSchema getSchema(@NotNull SqliteDatabase database) {
                Intrinsics.checkNotNullParameter((Object)database, (String)"database");
                return DatabaseInspectorControllerImpl.access$getModel$p(this.this$0).getOpenDatabases().get(database);
            }
            {
                this.this$0 = this$0;
            }
        }, this.viewFactory.createTableView());
        this.view.openTab(tabId, "New Query", sqliteEvaluatorView2.getComponent());
        SqliteEvaluatorController sqliteEvaluatorController = new SqliteEvaluatorController(sqliteEvaluatorView2, this.edtExecutor);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)sqliteEvaluatorController);
        sqliteEvaluatorController.setUp();
        sqliteEvaluatorController.addListener(new SqliteEvaluatorControllerListenerImpl());
        this.resultSetControllers.put(tabId, sqliteEvaluatorController);
        Set<SqliteDatabase> set = this.model.getOpenDatabases().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"model.openDatabases.keys");
        Iterable $this$forEachIndexed$iv = set;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void sqliteDatabase;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SqliteDatabase sqliteDatabase2 = (SqliteDatabase)item$iv;
            int index = n;
            boolean bl2 = false;
            void v1 = sqliteDatabase;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"sqliteDatabase");
            sqliteEvaluatorController.addDatabase((SqliteDatabase)v1, index);
        }
        return sqliteEvaluatorController;
    }

    public DatabaseInspectorControllerImpl(@NotNull Project project, @NotNull DatabaseInspectorController.Model model2, @NotNull DatabaseInspectorViewsFactory viewFactory, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)viewFactory, (String)"viewFactory");
        Intrinsics.checkNotNullParameter((Object)edtExecutor, (String)"edtExecutor");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        this.project = project;
        this.model = model2;
        this.viewFactory = viewFactory;
        FutureCallbackExecutor futureCallbackExecutor = FutureCallbackExecutor.wrap((Executor)edtExecutor);
        Intrinsics.checkNotNullExpressionValue((Object)futureCallbackExecutor, (String)"FutureCallbackExecutor.wrap(edtExecutor)");
        this.edtExecutor = futureCallbackExecutor;
        FutureCallbackExecutor futureCallbackExecutor2 = FutureCallbackExecutor.wrap((Executor)taskExecutor);
        Intrinsics.checkNotNullExpressionValue((Object)futureCallbackExecutor2, (String)"FutureCallbackExecutor.wrap(taskExecutor)");
        this.taskExecutor = futureCallbackExecutor2;
        this.view = this.viewFactory.createDatabaseInspectorView(this.project);
        boolean bl = false;
        this.resultSetControllers = new LinkedHashMap();
        this.sqliteViewListener = new SqliteViewListenerImpl();
    }

    public static final /* synthetic */ void access$readDatabaseSchema(DatabaseInspectorControllerImpl $this, SqliteDatabase database, Function1 onSchemaRead) {
        $this.readDatabaseSchema(database, (Function1<? super SqliteSchema, Unit>)onSchemaRead);
    }

    public static final /* synthetic */ void access$addNewDatabase(DatabaseInspectorControllerImpl $this, SqliteDatabase database, SqliteSchema sqliteSchema) {
        $this.addNewDatabase(database, sqliteSchema);
    }

    public static final /* synthetic */ void access$updateExistingDatabaseSchemaView(DatabaseInspectorControllerImpl $this, SqliteDatabase database, SqliteSchema newSqliteSchema) {
        $this.updateExistingDatabaseSchemaView(database, newSqliteSchema);
    }

    public static final /* synthetic */ DatabaseInspectorController.Model access$getModel$p(DatabaseInspectorControllerImpl $this) {
        return $this.model;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorControllerImpl$SqliteViewListenerImpl;", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorView$Listener;", "(Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorControllerImpl;)V", "closeTabActionInvoked", "", "tabId", "Lcom/android/tools/idea/sqlite/controllers/TabId;", "openSqliteEvaluatorTabActionInvoked", "reDownloadDatabaseFileActionInvoked", "database", "Lcom/android/tools/idea/sqlite/model/FileSqliteDatabase;", "removeDatabaseActionInvoked", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "tableNodeActionInvoked", "table", "Lcom/android/tools/idea/sqlite/model/SqliteTable;", "intellij.android.debuggers"})
    private final class SqliteViewListenerImpl
    implements DatabaseInspectorView.Listener {
        @Override
        public void tableNodeActionInvoked(@NotNull SqliteDatabase database, @NotNull SqliteTable table2) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            TabId.TableTab tableId = new TabId.TableTab(database, table2.getName());
            Map map2 = DatabaseInspectorControllerImpl.this.resultSetControllers;
            boolean bl = false;
            Map map3 = map2;
            boolean bl2 = false;
            if (map3.containsKey(tableId)) {
                DatabaseInspectorControllerImpl.this.view.focusTab(tableId);
                return;
            }
            DatabaseConnection databaseConnection = database.getDatabaseConnection();
            TableView tableView = DatabaseInspectorControllerImpl.this.viewFactory.createTableView();
            DatabaseInspectorControllerImpl.this.view.openTab(tableId, table2.getName(), tableView.getComponent());
            TableController tableController = new TableController(0, tableView, table2, databaseConnection, new SqliteStatement(JdbcUtilsKt.selectAllAndRowIdFromTable(table2)), DatabaseInspectorControllerImpl.this.edtExecutor, 1, null);
            Disposer.register((Disposable)((Disposable)DatabaseInspectorControllerImpl.this.project), (Disposable)tableController);
            DatabaseInspectorControllerImpl.this.edtExecutor.addCallback(tableController.setUp(), (FutureCallback)new FutureCallback<Unit>(this, tableController, tableId, table2){
                final /* synthetic */ SqliteViewListenerImpl this$0;
                final /* synthetic */ TableController $tableController;
                final /* synthetic */ TabId.TableTab $tableId;
                final /* synthetic */ SqliteTable $table;

                public void onSuccess(@Nullable Unit result2) {
                    DatabaseInspectorControllerImpl.access$getResultSetControllers$p(this.this$0.DatabaseInspectorControllerImpl.this).put(this.$tableId, this.$tableController);
                }

                public void onFailure(@NotNull Throwable t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    DatabaseInspectorControllerImpl.access$getView$p(this.this$0.DatabaseInspectorControllerImpl.this).reportError("Error reading Sqlite table \"" + this.$table.getName() + '\"', t);
                }
                {
                    this.this$0 = this$0;
                    this.$tableController = $captured_local_variable$1;
                    this.$tableId = $captured_local_variable$2;
                    this.$table = $captured_local_variable$3;
                }
            });
        }

        @Override
        public void openSqliteEvaluatorTabActionInvoked() {
            DatabaseInspectorControllerImpl.this.openNewEvaluatorTab();
        }

        @Override
        public void closeTabActionInvoked(@NotNull TabId tabId) {
            Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
            DatabaseInspectorControllerImpl.this.closeTab(tabId);
        }

        @Override
        public void removeDatabaseActionInvoked(@NotNull SqliteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            DatabaseInspectorControllerImpl.this.closeDatabase(database);
        }

        @Override
        public void reDownloadDatabaseFileActionInvoked(@NotNull FileSqliteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            ListenableFuture<Unit> downloadFuture2 = DatabaseInspectorProjectService.Companion.getInstance(DatabaseInspectorControllerImpl.this.project).reDownloadAndOpenFile(database, new DownloadProgress(this){
                final /* synthetic */ SqliteViewListenerImpl this$0;

                public boolean isCancelled() {
                    return false;
                }

                public void onStarting(@NotNull String entryFullPath) {
                    Intrinsics.checkNotNullParameter((Object)entryFullPath, (String)"entryFullPath");
                    DatabaseInspectorControllerImpl.access$getView$p(this.this$0.DatabaseInspectorControllerImpl.this).reportSyncProgress(StringKt.trimMiddle((String)entryFullPath, (int)20, (boolean)true) + ": start sync");
                }

                public void onProgress(@NotNull String entryFullPath, long currentBytes, long totalBytes) {
                    Intrinsics.checkNotNullParameter((Object)entryFullPath, (String)"entryFullPath");
                    DatabaseInspectorControllerImpl.access$getView$p(this.this$0.DatabaseInspectorControllerImpl.this).reportSyncProgress(StringKt.trimMiddle((String)entryFullPath, (int)20, (boolean)true) + ": sync progress " + currentBytes + '/' + totalBytes);
                }

                public void onCompleted(@NotNull String entryFullPath) {
                    Intrinsics.checkNotNullParameter((Object)entryFullPath, (String)"entryFullPath");
                    DatabaseInspectorControllerImpl.access$getView$p(this.this$0.DatabaseInspectorControllerImpl.this).reportSyncProgress(StringKt.trimMiddle((String)entryFullPath, (int)20, (boolean)true) + ": sync completed");
                }
                {
                    this.this$0 = this$0;
                }
            });
            DatabaseInspectorControllerImpl.this.edtExecutor.transform(downloadFuture2, (FutureCallbackExecutor.ThrowableFunction)new FutureCallbackExecutor.ThrowableFunction<Unit, Unit>(this){
                final /* synthetic */ SqliteViewListenerImpl this$0;

                public final void apply(Unit it) {
                    DatabaseInspectorControllerImpl.access$getView$p(this.this$0.DatabaseInspectorControllerImpl.this).reportSyncProgress("");
                }
                {
                    this.this$0 = sqliteViewListenerImpl;
                }
            });
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorControllerImpl$SqliteEvaluatorControllerListenerImpl;", "Lcom/android/tools/idea/sqlite/controllers/SqliteEvaluatorController$Listener;", "(Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorControllerImpl;)V", "onSchemaUpdated", "", "database", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "intellij.android.debuggers"})
    private final class SqliteEvaluatorControllerListenerImpl
    implements SqliteEvaluatorController.Listener {
        @Override
        public void onSchemaUpdated(@NotNull SqliteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            DatabaseInspectorControllerImpl.this.updateDatabaseSchema(database);
        }
    }
}

