/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.sync.hyperlink.DownloadAndroidStudioHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DownloadJdk8Hyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.SelectJdkFromFileSystemHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.UseEmbeddedJdkHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.UseJavaHomeAsJdkHyperlink;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Jdks {
    @NotNull
    private static final Logger LOG = Logger.getInstance(Jdks.class);
    @NonNls
    public static final String DOWNLOAD_JDK_8_URL = "http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html";
    @NotNull
    private final IdeInfo myIdeInfo;

    @NotNull
    public static Jdks getInstance() {
        Jdks jdks = (Jdks)ApplicationManager.getApplication().getService(Jdks.class);
        if (jdks == null) {
            Jdks.$$$reportNull$$$0(0);
        }
        return jdks;
    }

    @NonInjectable
    public Jdks(@NotNull IdeInfo ideInfo) {
        if (ideInfo == null) {
            Jdks.$$$reportNull$$$0(1);
        }
        this.myIdeInfo = ideInfo;
    }

    public Jdks() {
        this.myIdeInfo = IdeInfo.getInstance();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public boolean isApplicableJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(2);
        }
        return IdeSdks.getInstance().isJdkCompatible(jdk);
    }

    @Nullable
    public JavaSdkVersion findVersion(@NotNull File jdkRoot) {
        if (jdkRoot == null) {
            Jdks.$$$reportNull$$$0(3);
        }
        return Jdks.getVersion(jdkRoot.getPath());
    }

    @Nullable
    private static JavaSdkVersion getVersion(String jdkRoot) {
        String version2 = JavaSdk.getInstance().getVersionString(jdkRoot);
        return StringUtil.isEmpty((String)version2) ? null : JavaSdkVersion.fromVersionString((String)version2);
    }

    @Nullable
    public Sdk createJdk(@NotNull String jdkHomePath) {
        Sdk jdk;
        if (jdkHomePath == null) {
            Jdks.$$$reportNull$$$0(4);
        }
        if ((jdk = (Sdk)ExternalSystemApiUtil.executeOnEdt(() -> SdkConfigurationUtil.createAndAddSDK((String)jdkHomePath, (SdkType)JavaSdk.getInstance()))) == null) {
            String msg = String.format("Unable to create JDK from path '%1$s'", jdkHomePath);
            LOG.error(msg);
        }
        return jdk;
    }

    @Nullable
    public Sdk createEmbeddedJdk() {
        if (this.myIdeInfo.isAndroidStudio()) {
            File path2 = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
            if (path2 == null) {
                return null;
            }
            Sdk jdk = this.createJdk(path2.getPath());
            assert (jdk != null);
            return jdk;
        }
        return null;
    }

    public void setJdk(@NotNull Project project, @NotNull Sdk jdk) {
        if (project == null) {
            Jdks.$$$reportNull$$$0(5);
        }
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(6);
        }
        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)jdk);
    }

    @NotNull
    public List<NotificationHyperlink> getWrongJdkQuickFixes(@NotNull Project project) {
        if (project == null) {
            Jdks.$$$reportNull$$$0(7);
        }
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        if (this.myIdeInfo.isAndroidStudio()) {
            UseJavaHomeAsJdkHyperlink useJavaHomeHyperlink;
            String javaHome;
            IdeSdks ideSdks = IdeSdks.getInstance();
            if (!ideSdks.isUsingJavaHomeJdk() && (javaHome = IdeSdks.getJdkFromJavaHome()) != null && ideSdks.validateJdkPath(new File(javaHome)) != null && (useJavaHomeHyperlink = UseJavaHomeAsJdkHyperlink.create()) != null) {
                quickFixes.add(useJavaHomeHyperlink);
            }
            if (quickFixes.isEmpty()) {
                File embeddedJdkPath = EmbeddedDistributionPaths.getInstance().tryToGetEmbeddedJdkPath();
                if (embeddedJdkPath != null && Jdks.isJdkRunnableOnPlatform(embeddedJdkPath.getAbsolutePath())) {
                    quickFixes.add(new UseEmbeddedJdkHyperlink());
                } else {
                    quickFixes.add(new DownloadAndroidStudioHyperlink());
                }
            }
        }
        quickFixes.add(new DownloadJdk8Hyperlink());
        SelectJdkFromFileSystemHyperlink selectJdkHyperlink = SelectJdkFromFileSystemHyperlink.create(project);
        if (selectJdkHyperlink != null) {
            quickFixes.add(selectJdkHyperlink);
        }
        ArrayList<NotificationHyperlink> arrayList = quickFixes;
        if (arrayList == null) {
            Jdks.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static boolean isJdkRunnableOnPlatform(@NotNull Sdk jdk) {
        if (jdk == null) {
            Jdks.$$$reportNull$$$0(9);
        }
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (!SystemInfo.isWindows || !SystemInfo.is32Bit) {
            return true;
        }
        JavaSdk javaSdk = (JavaSdk)jdk.getSdkType();
        String javaExecutablePath = javaSdk.getVMExecutablePath(jdk);
        return Jdks.runAndCheckJVM(javaExecutablePath);
    }

    private static boolean isJdkRunnableOnPlatform(@NotNull String jdkHome) {
        if (jdkHome == null) {
            Jdks.$$$reportNull$$$0(10);
        }
        return Jdks.runAndCheckJVM(FileUtil.join((String[])new String[]{jdkHome, "bin", "java"}));
    }

    private static boolean runAndCheckJVM(@NotNull String javaExecutablePath) {
        if (javaExecutablePath == null) {
            Jdks.$$$reportNull$$$0(11);
        }
        LOG.info("Checking java binary: " + javaExecutablePath);
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{javaExecutablePath});
        commandLine.addParameter("-version");
        try {
            CapturingAnsiEscapesAwareProcessHandler process2 = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            int exitCode = process2.runProcess().getExitCode();
            return exitCode == 0;
        }
        catch (ExecutionException e) {
            LOG.info("Could not invoke 'java -version'", (Throwable)e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/Jdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHomePath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/Jdks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrongJdkQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableJdk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setJdk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWrongJdkQuickFixes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isJdkRunnableOnPlatform";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runAndCheckJVM";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

