/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IdeSdks {
    @NonNls
    public static final String MAC_JDK_CONTENT_PATH = "/Contents/Home";
    @NonNls
    private static final String ANDROID_SDK_PATH_KEY = "android.sdk.path";
    @NotNull
    public static final JavaSdkVersion DEFAULT_JDK_VERSION = JavaSdkVersion.JDK_1_8;
    @NotNull
    public static final String JDK_LOCATION_ENV_VARIABLE_NAME = "STUDIO_GRADLE_JDK";
    private static final JavaSdkVersion MIN_JDK_VERSION = JavaSdkVersion.JDK_1_8;
    private static final JavaSdkVersion MAX_JDK_VERSION = JavaSdkVersion.JDK_11;
    @NotNull
    private final AndroidSdks myAndroidSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final Map<String, LocalPackage> localPackagesByPrefix;
    private boolean myUseJdkEnvVariable;
    private boolean myIsJdkEnvVariableValid;
    private Boolean myIsJdkEnvVariableDefined;
    private File myEnvVariableJdk;
    private String myEnvVariableJdkValue;
    private final Object myEnvVariableLock;

    @NotNull
    public static IdeSdks getInstance() {
        IdeSdks ideSdks = (IdeSdks)ApplicationManager.getApplication().getService(IdeSdks.class);
        if (ideSdks == null) {
            IdeSdks.$$$reportNull$$$0(0);
        }
        return ideSdks;
    }

    public IdeSdks() {
        this(AndroidSdks.getInstance(), Jdks.getInstance(), EmbeddedDistributionPaths.getInstance(), IdeInfo.getInstance());
    }

    @NonInjectable
    public IdeSdks(@NotNull AndroidSdks sdks, @NotNull Jdks jdks, @NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull IdeInfo ideInfo) {
        if (sdks == null) {
            IdeSdks.$$$reportNull$$$0(1);
        }
        if (jdks == null) {
            IdeSdks.$$$reportNull$$$0(2);
        }
        if (embeddedDistributionPaths == null) {
            IdeSdks.$$$reportNull$$$0(3);
        }
        if (ideInfo == null) {
            IdeSdks.$$$reportNull$$$0(4);
        }
        this.localPackagesByPrefix = new HashMap<String, LocalPackage>();
        this.myUseJdkEnvVariable = false;
        this.myIsJdkEnvVariableValid = false;
        this.myEnvVariableJdk = null;
        this.myEnvVariableJdkValue = null;
        this.myEnvVariableLock = new Object();
        this.myAndroidSdks = sdks;
        this.myJdks = jdks;
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public File getAndroidSdkPath() {
        File candidate;
        File candidate2;
        String sdkHome = null;
        Sdk sdk = this.getFirstAndroidSdk();
        if (sdk != null) {
            sdkHome = sdk.getHomePath();
        }
        if (sdkHome != null && this.isValidAndroidSdkPath(candidate2 = FilePaths.toSystemDependentPath((String)sdkHome))) {
            return candidate2;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        PropertiesComponent component3 = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        String sdkPath = component3.getValue(ANDROID_SDK_PATH_KEY);
        if (sdkPath != null && this.isValidAndroidSdkPath(candidate = new File(sdkPath))) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public LocalPackage getSpecificLocalPackage(@NotNull String prefix) {
        if (prefix == null) {
            IdeSdks.$$$reportNull$$$0(5);
        }
        if (this.localPackagesByPrefix.containsKey(prefix)) {
            return this.localPackagesByPrefix.get(prefix);
        }
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage result2 = sdkHandler.getLatestLocalPackageForPrefix(prefix, null, true, (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (result2 != null) {
            this.setSpecificLocalPackage(prefix, result2);
        }
        return result2;
    }

    @VisibleForTesting
    public void setSpecificLocalPackage(@NotNull String prefix, @NotNull LocalPackage localPackage) {
        if (prefix == null) {
            IdeSdks.$$$reportNull$$$0(6);
        }
        if (localPackage == null) {
            IdeSdks.$$$reportNull$$$0(7);
        }
        this.localPackagesByPrefix.put(prefix, localPackage);
    }

    @Nullable
    public LocalPackage getHighestLocalNdkPackage(boolean allowPreview) {
        return this.getHighestLocalNdkPackage(allowPreview, null);
    }

    @Nullable
    public LocalPackage getHighestLocalNdkPackage(boolean allowPreview, @Nullable Predicate<Revision> filter2) {
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage ndk = sdkHandler.getLatestLocalPackageForPrefix("ndk", filter2, allowPreview, (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (ndk != null) {
            return ndk;
        }
        LocalPackage ndkPackage = sdkHandler.getLocalPackage("ndk-bundle", (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (filter2 != null && ndkPackage != null && filter2.test(ndkPackage.getVersion())) {
            return ndkPackage;
        }
        return null;
    }

    @Nullable
    public File getAndroidNdkPath() {
        return this.getAndroidNdkPath(null);
    }

    @Nullable
    public File getAndroidNdkPath(@Nullable Predicate<Revision> filter2) {
        LocalPackage ndk = this.getHighestLocalNdkPackage(false, filter2);
        if (ndk != null) {
            return ndk.getLocation();
        }
        return null;
    }

    @Nullable
    public File getJdkPath() {
        return this.doGetJdkPath(true);
    }

    @Nullable
    private File doGetJdkPath(boolean createJdkIfNeeded) {
        if (this.isUsingEnvVariableJdk()) {
            return this.getEnvVariableJdk();
        }
        JavaSdkVersion sdkVersion = this.getRunningVersionOrDefault();
        Sdk jdk = this.getExistingJdk(sdkVersion);
        if (createJdkIfNeeded && (jdk == null || jdk.getHomePath() == null)) {
            jdk = this.createNewJdk(sdkVersion);
        }
        if (jdk != null && jdk.getHomePath() != null) {
            return new File(jdk.getHomePath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsingEnvVariableJdk() {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            this.initializeJdkEnvVariable();
            return this.myUseJdkEnvVariable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeJdkEnvVariable() {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            if (this.myIsJdkEnvVariableDefined != null) {
                return;
            }
            this.initializeJdkEnvVariable(System.getenv(JDK_LOCATION_ENV_VARIABLE_NAME));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void cleanJdkEnvVariableInitialization() {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            this.myIsJdkEnvVariableDefined = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void initializeJdkEnvVariable(@Nullable String envVariableValue) {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            if (this.myIsJdkEnvVariableDefined != null) {
                return;
            }
            this.myEnvVariableJdkValue = envVariableValue;
            if (this.myEnvVariableJdkValue == null) {
                this.myIsJdkEnvVariableDefined = Boolean.FALSE;
                this.myEnvVariableJdk = null;
                this.myIsJdkEnvVariableValid = false;
                this.myUseJdkEnvVariable = false;
                return;
            }
            this.myIsJdkEnvVariableDefined = Boolean.TRUE;
            this.myEnvVariableJdk = this.validateJdkPath(new File(FileUtil.toSystemDependentName((String)this.myEnvVariableJdkValue)));
            if (this.myEnvVariableJdk == null) {
                this.myIsJdkEnvVariableValid = false;
                this.myUseJdkEnvVariable = false;
                return;
            }
            this.myIsJdkEnvVariableValid = true;
            this.myUseJdkEnvVariable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJdkEnvVariableDefined() {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            this.initializeJdkEnvVariable();
            return this.myIsJdkEnvVariableDefined;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJdkEnvVariableValid() {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            this.initializeJdkEnvVariable();
            return this.myIsJdkEnvVariableValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File getEnvVariableJdk() {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            this.initializeJdkEnvVariable();
            return this.myEnvVariableJdk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getEnvVariableJdkValue() {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            this.initializeJdkEnvVariable();
            return this.myEnvVariableJdkValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUseEnvVariableJdk(boolean useJdkEnvVariable) {
        Object object = this.myEnvVariableLock;
        synchronized (object) {
            this.initializeJdkEnvVariable();
            if (!this.isJdkEnvVariableValid()) {
                return false;
            }
            this.myUseJdkEnvVariable = useJdkEnvVariable;
            return true;
        }
    }

    @Nullable
    private Sdk getFirstAndroidSdk() {
        List<Sdk> allAndroidSdks = this.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        return null;
    }

    public void setJdkPath(@NotNull File path2) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(8);
        }
        if (JdkUtil.checkForJdk((File)path2)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            File canonicalPath = IdeSdks.resolvePath(path2);
            Sdk chosenJdk = null;
            if (this.isAndroidStudio()) {
                List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance());
                for (Sdk jdk : jdks) {
                    ProjectJdkTable.getInstance().removeJdk(jdk);
                }
            } else {
                for (Sdk jdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)canonicalPath.getPath())) continue;
                    chosenJdk = jdk;
                    break;
                }
            }
            if (chosenJdk == null) {
                if (canonicalPath.isDirectory()) {
                    chosenJdk = this.createJdk(canonicalPath);
                    if (chosenJdk == null) {
                        throw new IllegalStateException("Failed to create IDEA JDK from '" + path2.getPath() + "'");
                    }
                    this.setJdkOfAndroidSdks(chosenJdk);
                    for (Project project : ProjectUtil.getOpenProjects()) {
                        NewProjectUtil.applyJdkToProject((Project)project, (Sdk)chosenJdk);
                    }
                } else {
                    throw new IllegalStateException("The resolved path '" + canonicalPath.getPath() + "' was not found");
                }
            }
            this.setUseEnvVariableJdk(false);
        }
    }

    private void setJdkOfAndroidSdks(@NotNull Sdk jdk) {
        if (jdk == null) {
            IdeSdks.$$$reportNull$$$0(9);
        }
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path2, @Nullable Project currentProject) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(10);
        }
        List<Sdk> list = this.setAndroidSdkPath(path2, null, currentProject);
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path2, @Nullable Sdk javaSdk, @Nullable Project currentProject) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(12);
        }
        if (this.isValidAndroidSdkPath(path2)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (currentProject != null && !currentProject.isDisposed()) {
                String sdkPath = FileUtil.toCanonicalPath((String)path2.getAbsolutePath());
                PropertiesComponent.getInstance((Project)currentProject).setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                if (!currentProject.isDefault()) {
                    PropertiesComponent component3 = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
                    component3.setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                }
            }
            this.updateSdkData(path2);
            ArrayList<Sdk> sdksToDelete = new ArrayList<Sdk>();
            File resolved = IdeSdks.resolvePath(path2);
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolved, true);
            if (sdkData != null) {
                for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(resolved, javaSdk);
            IdeSdks.afterAndroidSdkPathUpdate(resolved);
            List<Sdk> list = sdks;
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<Sdk> list = Collections.emptyList();
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(14);
        }
        return list;
    }

    private void updateSdkData(@NotNull File path2) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(15);
        }
        AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path2);
        this.myAndroidSdks.setSdkData(oldSdkData);
    }

    public void updateFromAndroidSdkPath(@Nullable Project currentProject) {
        String sdkPath;
        File sdkDir = null;
        if (currentProject != null && !currentProject.isDisposed() && (sdkPath = PropertiesComponent.getInstance((Project)currentProject).getValue(ANDROID_SDK_PATH_KEY)) != null) {
            sdkDir = new File(sdkPath);
        }
        if (sdkDir == null) {
            sdkDir = this.getAndroidSdkPath();
        }
        assert (sdkDir != null);
        assert (this.isValidAndroidSdkPath(sdkDir));
        this.updateSdkData(sdkDir);
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            VirtualFile homeDir = sdk.getHomeDirectory();
            if (homeDir == null || !homeDir.exists()) {
                jdkTable.removeJdk(sdk);
                continue;
            }
            IAndroidTarget target = IdeSdks.getTarget(sdk);
            File targetFile = new File(target.getLocation());
            if (targetFile.exists()) continue;
            jdkTable.removeJdk(sdk);
        }
        File resolved = IdeSdks.resolvePath(sdkDir);
        this.createAndroidSdkPerAndroidTarget(resolved);
    }

    private static void afterAndroidSdkPathUpdate(@NotNull File androidSdkPath) {
        Project[] openProjects;
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(16);
        }
        if ((openProjects = ProjectUtil.getOpenProjects()).length == 0) {
            return;
        }
        List eventListeners = AndroidSdkEventListener.EP_NAME.getExtensionList();
        for (Project project : openProjects) {
            if (!AndroidProjectInfo.getInstance(project).requiresAndroidModel()) continue;
            for (AndroidSdkEventListener listener2 : eventListeners) {
                listener2.afterSdkPathChange(androidSdkPath, project);
            }
        }
    }

    public boolean isValidAndroidSdkPath(@NotNull File path2) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(17);
        }
        return SdkPaths.validateAndroidSdk((File)path2, (boolean)false).success;
    }

    @NotNull
    public List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(18);
        }
        List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(androidSdkPath, null);
        IdeSdks.updateWelcomeRunAndroidSdkAction();
        List<Sdk> list = sdks;
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(19);
        }
        return list;
    }

    public static void updateWelcomeRunAndroidSdkAction() {
        AnAction sdkManagerAction = ActionManager.getInstance().getAction("WelcomeScreen.RunAndroidSdkManager");
        if (sdkManagerAction != null) {
            sdkManagerAction.update(AnActionEvent.createFromDataContext((String)"unknown", null, dataId -> null));
        }
    }

    @NotNull
    private List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath, @Nullable Sdk javaSdk) {
        Sdk ideJdk;
        AndroidSdkData sdkData;
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(20);
        }
        if ((sdkData = AndroidSdkData.getSdkData(androidSdkPath)) == null) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(21);
            }
            return list;
        }
        IAndroidTarget[] targets = sdkData.getTargets(false);
        if (targets.length == 0) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(22);
            }
            return list;
        }
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        Sdk sdk = ideJdk = javaSdk != null ? javaSdk : this.getJdk();
        if (ideJdk != null) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform() || this.doesIdeAndroidSdkExist(target)) continue;
                String name = this.myAndroidSdks.chooseNameForNewLibrary(target);
                Sdk sdk2 = this.myAndroidSdks.create(target, sdkData.getLocation(), name, ideJdk, true);
                if (sdk2 == null) continue;
                sdks.add(sdk2);
            }
        }
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private boolean doesIdeAndroidSdkExist(@NotNull IAndroidTarget target) {
        if (target == null) {
            IdeSdks.$$$reportNull$$$0(24);
        }
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = IdeSdks.getTarget(sdk);
            AndroidVersion version2 = target.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        if (sdk == null) {
            IdeSdks.$$$reportNull$$$0(25);
        }
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        assert (androidPlatform != null);
        IAndroidTarget iAndroidTarget = androidPlatform.getTarget();
        if (iAndroidTarget == null) {
            IdeSdks.$$$reportNull$$$0(26);
        }
        return iAndroidTarget;
    }

    @NotNull
    private static File resolvePath(@NotNull File path2) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(27);
        }
        try {
            String resolvedPath = FileUtil.resolveShortWindowsName((String)path2.getPath());
            return new File(resolvedPath);
        }
        catch (IOException iOException) {
            File file = path2;
            if (file == null) {
                IdeSdks.$$$reportNull$$$0(28);
            }
            return file;
        }
    }

    public boolean isUsingEmbeddedJdk() {
        if (!this.isAndroidStudio()) {
            return false;
        }
        File jdkPath = this.doGetJdkPath(false);
        return jdkPath != null && FileUtil.filesEqual((File)jdkPath, (File)this.getEmbeddedJdkPath());
    }

    public void setUseEmbeddedJdk() {
        Preconditions.checkState((boolean)this.isAndroidStudio(), (Object)"This method is for use in Android Studio only.");
        File embeddedJdkPath = this.getEmbeddedJdkPath();
        assert (embeddedJdkPath != null);
        this.setJdkPath(embeddedJdkPath);
    }

    @Nullable
    public File getEmbeddedJdkPath() {
        if (!this.isAndroidStudio()) {
            return null;
        }
        return this.myEmbeddedDistributionPaths.getEmbeddedJdkPath();
    }

    public boolean isUsingJavaHomeJdk() {
        return this.isUsingJavaHomeJdk(ApplicationManager.getApplication().isUnitTestMode());
    }

    @VisibleForTesting
    boolean isUsingJavaHomeJdk(boolean assumeUnitTest) {
        if (!this.isAndroidStudio()) {
            return false;
        }
        File jdkPath = assumeUnitTest ? this.doGetJdkPath(false) : this.getJdkPath();
        return IdeSdks.isSameAsJavaHomeJdk(jdkPath);
    }

    @VisibleForTesting
    boolean isAndroidStudio() {
        return this.myIdeInfo.isAndroidStudio();
    }

    public static boolean isSameAsJavaHomeJdk(@Nullable File path2) {
        String javaHome = IdeSdks.getJdkFromJavaHome();
        return javaHome != null && FileUtil.filesEqual((File)path2, (File)FilePaths.toSystemDependentPath((String)javaHome));
    }

    @Nullable
    public static String getJdkFromJavaHome() {
        String terminalValue = IdeSdks.doGetJdkFromPathOrParent(EnvironmentUtil.getValue((String)"JAVA_HOME"));
        if (!Strings.isNullOrEmpty((String)terminalValue)) {
            return terminalValue;
        }
        String envVariableValue = IdeSdks.doGetJdkFromPathOrParent(System.getenv("JAVA_HOME"));
        if (!Strings.isNullOrEmpty((String)envVariableValue)) {
            return envVariableValue;
        }
        return IdeSdks.doGetJdkFromPathOrParent(SystemProperties.getJavaHome());
    }

    @VisibleForTesting
    @Nullable
    static String doGetJdkFromPathOrParent(@Nullable String path2) {
        if (Strings.isNullOrEmpty((String)path2)) {
            return null;
        }
        File pathFile = new File(FileUtil.toSystemDependentName((String)path2));
        String result2 = IdeSdks.doGetJdkFromPath(pathFile);
        if (result2 != null) {
            return result2;
        }
        File parentFile = pathFile.getParentFile();
        if (parentFile != null) {
            return IdeSdks.doGetJdkFromPath(parentFile);
        }
        return null;
    }

    @Nullable
    private static String doGetJdkFromPath(@NotNull File file) {
        File potentialPath;
        if (file == null) {
            IdeSdks.$$$reportNull$$$0(29);
        }
        if (JdkUtil.checkForJdk((File)file)) {
            return file.getPath();
        }
        if (SystemInfo.isMac && (potentialPath = new File(file, MAC_JDK_CONTENT_PATH)).isDirectory() && JdkUtil.checkForJdk((File)potentialPath)) {
            return potentialPath.getPath();
        }
        return null;
    }

    @Nullable
    public Sdk getJdk() {
        return this.getJdk(this.getRunningVersionOrDefault());
    }

    @Nullable
    private Sdk getJdk(@Nullable JavaSdkVersion preferredVersion) {
        Sdk existingJdk = this.getExistingJdk(preferredVersion);
        if (existingJdk != null) {
            return existingJdk;
        }
        return this.createNewJdk(preferredVersion);
    }

    @Nullable
    private Sdk getExistingJdk(@Nullable JavaSdkVersion preferredVersion) {
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data = this.myAndroidSdks.getAndroidSdkAdditionalData(androidSdk);
            assert (data != null);
            Sdk jdk = data.getJavaSdk();
            if (this.isJdkCompatible(jdk, preferredVersion)) {
                return jdk;
            }
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!jdks.isEmpty()) {
            for (Sdk jdk : jdks) {
                if (!this.isJdkCompatible(jdk, preferredVersion)) continue;
                return jdk;
            }
        }
        return null;
    }

    @Nullable
    private Sdk createNewJdk(@Nullable JavaSdkVersion preferredVersion) {
        Sdk jdk;
        if (this.isAndroidStudio() && (jdk = this.myJdks.createEmbeddedJdk()) != null) {
            assert (this.isJdkCompatible(jdk, preferredVersion));
            return jdk;
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        Set checkedJdkPaths = jdks.stream().map(Sdk::getHomePath).collect(Collectors.toSet());
        List<File> jdkPaths = IdeSdks.getPotentialJdkPaths();
        for (File jdkPath : jdkPaths) {
            Sdk jdk2;
            if (checkedJdkPaths.contains(jdkPath.getAbsolutePath())) continue;
            if (JdkUtil.checkForJdk((File)jdkPath) && this.isJdkCompatible(jdk2 = this.createJdk(jdkPath), preferredVersion)) {
                return jdk2;
            }
            if (!SystemInfo.isLinux) continue;
            for (File child : FileUtil.notNullize((File[])jdkPath.listFiles())) {
                Sdk jdk3;
                if (!child.isDirectory() || !JdkUtil.checkForJdk((File)child) || !this.isJdkCompatible(jdk3 = this.myJdks.createJdk(child.getPath()), preferredVersion)) continue;
                return jdk3;
            }
        }
        return null;
    }

    @NotNull
    private static List<File> getPotentialJdkPaths() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        ArrayList jdkPaths = Lists.newArrayList((Iterable)javaSdk.suggestHomePaths());
        jdkPaths.add(SystemProperties.getJavaHome());
        jdkPaths.add(0, System.getenv("JDK_HOME"));
        ArrayList virtualFiles = Lists.newArrayListWithCapacity((int)jdkPaths.size());
        for (String jdkPath : jdkPaths) {
            File javaHome;
            if (jdkPath == null || !(javaHome = new File(jdkPath)).isDirectory()) continue;
            virtualFiles.add(javaHome);
        }
        ArrayList arrayList = virtualFiles;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    public boolean isJdkCompatible(@Nullable Sdk jdk) {
        return this.isJdkCompatible(jdk, MIN_JDK_VERSION);
    }

    @Contract(value="null, _ -> false")
    public boolean isJdkCompatible(@Nullable Sdk jdk, @Nullable JavaSdkVersion preferredVersion) {
        if (jdk == null) {
            return false;
        }
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (preferredVersion == null) {
            return true;
        }
        JavaSdkVersion jdkVersion = JavaSdk.getInstance().getVersion(jdk);
        if (jdkVersion == null) {
            return false;
        }
        return this.isJdkVersionCompatible(preferredVersion, jdkVersion);
    }

    @VisibleForTesting
    boolean isJdkVersionCompatible(@NotNull JavaSdkVersion preferredVersion, @NotNull JavaSdkVersion jdkVersion) {
        if (preferredVersion == null) {
            IdeSdks.$$$reportNull$$$0(31);
        }
        if (jdkVersion == null) {
            IdeSdks.$$$reportNull$$$0(32);
        }
        return jdkVersion.compareTo((Enum)preferredVersion) >= 0 && jdkVersion.compareTo((Enum)MAX_JDK_VERSION) <= 0;
    }

    @NotNull
    public List<Sdk> getEligibleAndroidSdks() {
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            if (!sdk.getName().startsWith("Android ") || AndroidPlatform.getInstance(sdk) == null) continue;
            sdks.add(sdk);
        }
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    public boolean hasConfiguredAndroidSdk() {
        return this.getAndroidSdkPath() != null;
    }

    @Nullable
    private Sdk createJdk(@NotNull File homeDirectory) {
        if (homeDirectory == null) {
            IdeSdks.$$$reportNull$$$0(34);
        }
        return this.myJdks.createJdk(homeDirectory.getPath());
    }

    public boolean isJdk7Supported(@Nullable AndroidSdkData sdkData) {
        if (sdkData != null) {
            Revision revision;
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(Jdks.class);
            LocalPackage info = sdkData.getSdkHandler().getLocalPackage("platform-tools", (ProgressIndicator)progress);
            if (info != null && (revision = info.getVersion()).getMajor() >= 19) {
                JavaSdkVersion version2;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version2 = jdk.getVersion(sdk)) != null && version2.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    return true;
                }
            }
        }
        return false;
    }

    @TestOnly
    public static void removeJdksOn(@NotNull Disposable disposable) {
        if (disposable == null) {
            IdeSdks.$$$reportNull$$$0(35);
        }
        Disposer.register((Disposable)disposable, () -> WriteAction.run(() -> {
            for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
        }));
    }

    @Nullable
    public File validateJdkPath(@NotNull File file) {
        File macPath;
        if (file == null) {
            IdeSdks.$$$reportNull$$$0(36);
        }
        File possiblePath = null;
        if (JdkUtil.checkForJdk((File)file)) {
            possiblePath = file;
        } else if (SystemInfo.isMac && (macPath = new File(file, MAC_JDK_CONTENT_PATH)).isDirectory() && JdkUtil.checkForJdk((File)macPath)) {
            possiblePath = macPath;
        }
        if (((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue() || IdeSdks.isJdkSameVersion(possiblePath, this.getRunningVersionOrDefault())) {
            return possiblePath;
        }
        return null;
    }

    @NotNull
    public JavaSdkVersion getRunningVersionOrDefault() {
        JavaSdkVersion currentlyRunning;
        String versionString = System.getProperty("java.version");
        if (versionString != null && (currentlyRunning = JavaSdkVersion.fromVersionString((String)versionString)) != null) {
            JavaSdkVersion javaSdkVersion = currentlyRunning;
            if (javaSdkVersion == null) {
                IdeSdks.$$$reportNull$$$0(37);
            }
            return javaSdkVersion;
        }
        JavaSdkVersion embeddedVersion = Jdks.getInstance().findVersion(this.myEmbeddedDistributionPaths.getEmbeddedJdkPath());
        JavaSdkVersion javaSdkVersion = embeddedVersion != null ? embeddedVersion : DEFAULT_JDK_VERSION;
        if (javaSdkVersion == null) {
            IdeSdks.$$$reportNull$$$0(38);
        }
        return javaSdkVersion;
    }

    @Contract(value="null, _ -> false")
    public static boolean isJdkSameVersion(@Nullable File jdkLocation, @NotNull JavaSdkVersion expectedVersion) {
        if (expectedVersion == null) {
            IdeSdks.$$$reportNull$$$0(39);
        }
        if (jdkLocation == null) {
            return false;
        }
        JavaSdkVersion version2 = Jdks.getInstance().findVersion(jdkLocation);
        return version2 != null && version2.compareTo((Enum)expectedVersion) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/IdeSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedDistributionPaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPackage";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdkPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredVersion";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkVersion";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/IdeSdks";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setAndroidSdkPath";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndroidSdkPerAndroidTarget";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getPotentialJdkPaths";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getEligibleAndroidSdks";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningVersionOrDefault";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificLocalPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSpecificLocalPackage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setJdkPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setJdkOfAndroidSdks";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setAndroidSdkPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "afterAndroidSdkPathUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidAndroidSdkPath";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAndroidSdkPerAndroidTarget";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doesIdeAndroidSdkExist";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doGetJdkFromPath";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isJdkVersionCompatible";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeJdksOn";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "validateJdkPath";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isJdkSameVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 39: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AndroidSdkEventListener {
        public static final ExtensionPointName<AndroidSdkEventListener> EP_NAME = ExtensionPointName.create((String)"com.android.ide.sdkEventListener");

        public void afterSdkPathChange(@NotNull File var1, @NotNull Project var2);
    }
}

