/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.ui;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.DeploymentService;
import com.android.tools.idea.run.deployable.Deployable;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.XDebugSession;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(BaseAction.class);
    public static final Key<Boolean> SHOW_APPLY_CHANGES_UI = Key.create((String)"android.deploy.ApplyChanges.ShowUI");
    @NotNull
    protected final String myName;
    @NotNull
    protected final Icon myIcon;
    @NotNull
    private final SwapInfo.SwapType mySwapType;
    @NotNull
    private final String myDescription;

    public BaseAction(@NotNull String name, @NotNull SwapInfo.SwapType swapType, @NotNull Icon icon2, @NotNull String description) {
        if (name == null) {
            BaseAction.$$$reportNull$$$0(0);
        }
        if (swapType == null) {
            BaseAction.$$$reportNull$$$0(1);
        }
        if (icon2 == null) {
            BaseAction.$$$reportNull$$$0(2);
        }
        if (description == null) {
            BaseAction.$$$reportNull$$$0(3);
        }
        super(name, description, icon2);
        this.myName = name;
        this.mySwapType = swapType;
        this.myIcon = icon2;
        this.myDescription = description;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BaseAction.$$$reportNull$$$0(4);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null || !CommonAndroidUtil.getInstance().isAndroidProject(project)) {
            presentation.setVisible(false);
            return;
        }
        DisableMessage disableMessage = BaseAction.getDisableMessage(project);
        if (disableMessage == null) {
            presentation.setVisible(true);
            presentation.setEnabled(true);
            presentation.setText(this.myName);
            presentation.setDescription(this.myDescription);
        } else {
            this.disableAction(presentation, disableMessage);
        }
    }

    @Nullable
    public static DisableMessage getDisableMessage(@NotNull Project project) {
        RunnerAndConfigurationSettings configSettings;
        if (project == null) {
            BaseAction.$$$reportNull$$$0(5);
        }
        if ((configSettings = RunManager.getInstance((Project)project).getSelectedConfiguration()) == null) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "no configuration selected", "there is no configuration selected");
        }
        RunConfiguration selectedRunConfig = configSettings.getConfiguration();
        if (!BaseAction.isApplyChangesRelevant(selectedRunConfig)) {
            return new DisableMessage(DisableMessage.DisableMode.INVISIBLE, "unsupported configuration", "the selected configuration is not supported");
        }
        if (BaseAction.isExecutorStarting(project, selectedRunConfig)) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "building and/or launching", "the selected configuration is currently building and/or launching");
        }
        DeployableProvider deployableProvider = DeploymentService.getInstance(project).getDeployableProvider();
        if (deployableProvider == null) {
            return new DisableMessage(DisableMessage.DisableMode.DISABLED, "no deployment provider", "there is no deployment provider specified");
        }
        if (!deployableProvider.isDependentOnUserInput()) {
            try {
                Deployable deployable = deployableProvider.getDeployable();
                if (deployable == null) {
                    return new DisableMessage(DisableMessage.DisableMode.DISABLED, "selected device is invalid", "the selected device is not valid");
                }
                if (!deployable.isOnline()) {
                    if (deployable.isUnauthorized()) {
                        return new DisableMessage(DisableMessage.DisableMode.DISABLED, "device not authorized", "the selected device is not authorized");
                    }
                    return new DisableMessage(DisableMessage.DisableMode.DISABLED, "device not connected", "the selected device is not connected");
                }
                Future<AndroidVersion> versionFuture = deployable.getVersion();
                if (!versionFuture.isDone()) {
                    return new DisableMessage(DisableMessage.DisableMode.DISABLED, "unknown device API level", "its API level is currently unknown");
                }
                if (versionFuture.get().getApiLevel() < 26) {
                    return new DisableMessage(DisableMessage.DisableMode.DISABLED, "incompatible device API level", "its API level is lower than 26");
                }
                if (deployable.searchClientsForPackage().isEmpty()) {
                    return new DisableMessage(DisableMessage.DisableMode.DISABLED, "app not detected", "the app is not yet running or not debuggable");
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Throwable)ex);
                return new DisableMessage(DisableMessage.DisableMode.DISABLED, "update interrupted", "its status update was interrupted");
            }
            catch (ExecutionException ex) {
                LOG.warn((Throwable)ex);
                return new DisableMessage(DisableMessage.DisableMode.DISABLED, "unknown device API level", "its API level could not be determined");
            }
            catch (Exception ex) {
                LOG.warn((Throwable)ex);
                return new DisableMessage(DisableMessage.DisableMode.DISABLED, "unexpected exception", "an unexpected exception was thrown: " + ex.toString());
            }
        }
        return null;
    }

    private static boolean isApplyChangesRelevant(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            BaseAction.$$$reportNull$$$0(6);
        }
        if (runConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase configBase = (RunConfigurationBase)runConfiguration;
            return (Boolean)configBase.putUserDataIfAbsent(SHOW_APPLY_CHANGES_UI, (Object)false);
        }
        return false;
    }

    private static boolean isExecutorStarting(@NotNull Project project, @NotNull RunConfiguration runConfiguration) {
        if (project == null) {
            BaseAction.$$$reportNull$$$0(7);
        }
        if (runConfiguration == null) {
            BaseAction.$$$reportNull$$$0(8);
        }
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            ProgramRunner programRunner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConfiguration);
            if (programRunner == null || !ExecutionManager.getInstance((Project)project).isStarting(executor.getId(), programRunner.getRunnerId())) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Executor executor;
        Project project;
        if (e == null) {
            BaseAction.$$$reportNull$$$0(9);
        }
        if ((project = e.getProject()) == null) {
            LOG.warn(this.myName + " action performed with no project");
            return;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (settings == null) {
            LOG.warn(this.myName + " action could not locate current run config settings");
            return;
        }
        ProcessHandler handler = BaseAction.findRunningProcessHandler(project, settings.getConfiguration());
        Executor executor2 = executor = handler == null ? DefaultRunExecutor.getRunExecutorInstance() : BaseAction.getExecutor(handler, DefaultRunExecutor.getRunExecutorInstance());
        if (executor == null) {
            LOG.warn(this.myName + " action could not identify executor of existing running application");
            return;
        }
        ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.create((Executor)executor, (RunConfiguration)settings.getConfiguration());
        ExecutionEnvironment env = builder2.activeTarget().dataContext(e.getDataContext()).build();
        env.putUserData(SwapInfo.SWAP_INFO_KEY, (Object)new SwapInfo(this.mySwapType, handler));
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    @Nullable
    protected static ProcessHandler findRunningProcessHandler(@NotNull Project project, @NotNull RunConfiguration runConfiguration) {
        Deployable deployable;
        if (project == null) {
            BaseAction.$$$reportNull$$$0(10);
        }
        if (runConfiguration == null) {
            BaseAction.$$$reportNull$$$0(11);
        }
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            SwappableProcessHandler extension = (SwappableProcessHandler)handler.getCopyableUserData(SwappableProcessHandler.EXTENSION_KEY);
            if (extension == null || !extension.isRunningWith(runConfiguration, ExecutionTargetManager.getActiveTarget((Project)project)) || !handler.isStartNotified() || handler.isProcessTerminating() || handler.isProcessTerminated()) continue;
            return handler;
        }
        DeployableProvider deployableProvider = DeploymentService.getInstance(project).getDeployableProvider();
        if (deployableProvider == null || deployableProvider.isDependentOnUserInput()) {
            return null;
        }
        try {
            deployable = deployableProvider.getDeployable();
            if (deployable == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        for (DebuggerSession session : DebuggerManagerEx.getInstanceEx((Project)project).getSessions()) {
            XDebugSession debugSession;
            String debuggerPort = session.getProcess().getConnection().getAddress().trim();
            Client remoteDebuggedClient = deployable.searchClientsForPackage().stream().filter(client -> Integer.toString(client.getDebuggerListenPort()).equals(debuggerPort)).findAny().orElse(null);
            if (remoteDebuggedClient == null || (debugSession = session.getXDebugSession()) == null || debugSession.isStopped()) continue;
            return debugSession.getRunContentDescriptor().getProcessHandler();
        }
        return null;
    }

    @Nullable
    protected static Executor getExecutor(@NotNull ProcessHandler processHandler, @Nullable Executor defaultExecutor) {
        if (processHandler == null) {
            BaseAction.$$$reportNull$$$0(12);
        }
        if (processHandler instanceof RemoteDebugProcessHandler) {
            return DefaultDebugExecutor.getDebugExecutorInstance();
        }
        SwappableProcessHandler extension = (SwappableProcessHandler)processHandler.getCopyableUserData(SwappableProcessHandler.EXTENSION_KEY);
        return processHandler.isProcessTerminated() || processHandler.isProcessTerminating() || extension == null ? defaultExecutor : extension.getExecutor();
    }

    protected void disableAction(@NotNull Presentation presentation, @NotNull DisableMessage disableMessage) {
        if (presentation == null) {
            BaseAction.$$$reportNull$$$0(13);
        }
        if (disableMessage == null) {
            BaseAction.$$$reportNull$$$0(14);
        }
        if (!presentation.isVisible()) {
            return;
        }
        presentation.setVisible(disableMessage.myDisableMode != DisableMessage.DisableMode.INVISIBLE);
        presentation.setEnabled(false);
        presentation.setText(String.format("%s (disabled: %s)", this.myName, disableMessage.myTooltip));
        presentation.setDescription(String.format("%s is disabled for this device because %s.", this.myName, disableMessage.myDescription));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "swapType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disableMessage";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/ui/BaseAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDisableMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplyChangesRelevant";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isExecutorStarting";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findRunningProcessHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getExecutor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "disableAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class DisableMessage {
        @NotNull
        private final DisableMode myDisableMode;
        @NotNull
        private final String myTooltip;
        @NotNull
        private final String myDescription;

        public DisableMessage(@NotNull DisableMode disableMode, @NotNull String tooltip, @NotNull String description) {
            if (disableMode == null) {
                DisableMessage.$$$reportNull$$$0(0);
            }
            if (tooltip == null) {
                DisableMessage.$$$reportNull$$$0(1);
            }
            if (description == null) {
                DisableMessage.$$$reportNull$$$0(2);
            }
            this.myDisableMode = disableMode;
            this.myTooltip = tooltip;
            this.myDescription = description;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                DisableMessage.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disableMode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tooltip";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/ui/BaseAction$DisableMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/ui/BaseAction$DisableMessage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum DisableMode {
            INVISIBLE,
            DISABLED;

        }
    }
}

