/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.InstallOptions;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DeployTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(DeployTask.class);
    private static final String ID = "DEPLOY";
    private final String[] userInstallOptions;

    public DeployTask(@NotNull Project project, @NotNull Map<String, List<File>> packages, String userInstallOptions, Computable<String> installPathProvider) {
        if (project == null) {
            DeployTask.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            DeployTask.$$$reportNull$$$0(1);
        }
        super(project, packages, false, installPathProvider);
        if (userInstallOptions != null && !userInstallOptions.isEmpty()) {
            userInstallOptions = userInstallOptions.trim();
            this.userInstallOptions = userInstallOptions.split("\\s");
        } else {
            this.userInstallOptions = new String[0];
        }
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    protected Deployer.Result perform(IDevice device, Deployer deployer, String applicationId2, List<File> files2) throws DeployerException {
        InstallOptions.Builder options = InstallOptions.builder().setAllowDebuggable();
        if (device.supportsFeature(IDevice.HardwareFeature.EMBEDDED)) {
            options.setGrantAllPermissions();
        }
        if (device.getVersion().isGreaterOrEqualThan(28)) {
            options.setInstallFullApk();
        }
        if (this.userInstallOptions != null) {
            options.setUserInstallOptions(this.userInstallOptions);
        }
        LOG.info("Installing application: " + applicationId2);
        Deployer.InstallMode installMode = Deployer.InstallMode.DELTA;
        if (!((Boolean)StudioFlags.DELTA_INSTALL.get()).booleanValue()) {
            installMode = Deployer.InstallMode.FULL;
        }
        return deployer.install(applicationId2, DeployTask.getPathsToInstall(files2), options.build(), installMode);
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Install";
    }

    @Override
    @NotNull
    public String getFailureTitle() {
        return "Installation did not succeed.";
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "App restart successful without requiring a re-install.";
        }
        String string = "App restart successful without re-installing the following APK(s): " + skippedApkList.stream().collect(Collectors.joining(", "));
        if (string == null) {
            DeployTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/DeployTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/DeployTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSkippedApkInstallMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

