/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AndroidDeepLinkLaunchTask
implements LaunchTask {
    private static final String ID = "LAUNCH_DEEP_LINK";
    @NotNull
    private final String myDeepLink;
    @NotNull
    StartActivityFlagsProvider myStartActivityFlagsProvider;

    public AndroidDeepLinkLaunchTask(@NotNull String deepLink, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        if (deepLink == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(0);
        }
        if (startActivityFlagsProvider == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(1);
        }
        this.myDeepLink = deepLink;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching URL";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public LaunchResult run(@NotNull Executor executor, @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (executor == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(2);
        }
        if (device == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(3);
        }
        if (launchStatus == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(4);
        }
        if (printer == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(5);
        }
        printer.stdout("Launching deeplink: " + this.myDeepLink + ".\n");
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.APP_INDEXING).setKind(AndroidStudioEvent.EventKind.APP_INDEXING_DEEP_LINK_LAUNCHED));
        ShellCommandLauncher.execute("setprop log.tag.AppIndexApi VERBOSE", device, launchStatus, printer, 5L, TimeUnit.SECONDS);
        String command = AndroidDeepLinkLaunchTask.getLaunchDeepLinkCommand(this.myDeepLink, this.myStartActivityFlagsProvider.getFlags(device));
        boolean successful = ShellCommandLauncher.execute(command, device, launchStatus, printer, 5L, TimeUnit.SECONDS);
        return successful ? LaunchResult.success() : LaunchResult.error("", this.getDescription());
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public static String getLaunchDeepLinkCommand(@NotNull String deepLink, @NotNull String extraFlags) {
        if (deepLink == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(6);
        }
        if (extraFlags == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(7);
        }
        String string = "am start -a android.intent.action.VIEW -c android.intent.category.BROWSABLE -d " + AndroidDeepLinkLaunchTask.singleQuoteShell(deepLink) + (String)(extraFlags.isEmpty() ? "" : " " + extraFlags);
        if (string == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String singleQuoteShell(@NotNull String literal) {
        if (literal == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(9);
        }
        String string = "'" + literal.replace("'", "'\\''") + "'";
        if (string == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepLink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startActivityFlagsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraFlags";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchDeepLinkCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "singleQuoteShell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchDeepLinkCommand";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "singleQuoteShell";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

