/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.DeployTargetConfigurableWrapper;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.RunConfigurationEditorContext;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class DeploymentTargetOptions {
    @NotNull
    private final List<DeployTargetProvider> myProviders;
    @NotNull
    private final Map<String, DeployTargetConfigurableWrapper> myIdToConfigurableMap;
    @NotNull
    private final Component mySeparator;
    @NotNull
    private final Component myTargetLabel;
    @NotNull
    private final JComboBox<DeployTargetProvider> myTargetComboBox;
    @NotNull
    private final CardLayoutPanel<Configurable, Configurable, JComponent> myCardLayoutPanel;

    DeploymentTargetOptions(@NotNull List<DeployTargetProvider> providers2, @NotNull AndroidRunConfigurationEditor editor2, @NotNull Project project) {
        if (providers2 == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(2);
        }
        this.myProviders = providers2;
        this.myIdToConfigurableMap = this.newIdToConfigurableMap(editor2, project);
        this.mySeparator = new TitledSeparator("Deployment Target Options");
        this.myTargetLabel = new JBLabel("Target:");
        this.myTargetComboBox = this.newTargetComboBox();
        this.myCardLayoutPanel = new ConfigurableCardPanel();
    }

    @NotNull
    private Map<String, DeployTargetConfigurableWrapper> newIdToConfigurableMap(@NotNull AndroidRunConfigurationEditor editor2, @NotNull Project project) {
        if (editor2 == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(4);
        }
        RunConfigurationEditorContext context = new RunConfigurationEditorContext(editor2.getModuleSelector(), editor2.getModuleComboBox());
        Map<String, DeployTargetConfigurableWrapper> map2 = this.myProviders.stream().collect(Collectors.toMap(DeployTargetProvider::getId, provider2 -> new DeployTargetConfigurableWrapper(project, (Disposable)editor2, context, (DeployTargetProvider)provider2)));
        if (map2 == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    private JComboBox<DeployTargetProvider> newTargetComboBox() {
        ComboBox comboBox = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(this.myProviders));
        comboBox.setRenderer(SimpleListCellRenderer.create((String)"", o -> o.getDisplayName()));
        comboBox.addActionListener(arg_0 -> this.lambda$newTargetComboBox$2((JComboBox)comboBox, arg_0));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(6);
        }
        return comboBox2;
    }

    void addTo(@NotNull Container container) {
        if (container == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(7);
        }
        container.add(this.mySeparator, DeploymentTargetOptions.newSeparatorConstraints());
        container.add(this.myTargetLabel, DeploymentTargetOptions.newTargetLabelConstraints());
        container.add(this.myTargetComboBox, DeploymentTargetOptions.newTargetComboBoxConstraints());
        container.add((Component)this.myCardLayoutPanel, DeploymentTargetOptions.newCardLayoutPanelConstraints());
    }

    @NotNull
    private static Object newSeparatorConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(3);
        constraints.setColSpan(3);
        constraints.setVSizePolicy(0);
        constraints.setFill(1);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(8);
        }
        return gridConstraints;
    }

    @NotNull
    private static Object newTargetLabelConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(4);
        constraints.setVSizePolicy(0);
        constraints.setHSizePolicy(0);
        constraints.setFill(1);
        constraints.setIndent(2);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(9);
        }
        return gridConstraints;
    }

    @NotNull
    private static Object newTargetComboBoxConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(4);
        constraints.setColumn(1);
        constraints.setFill(1);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(10);
        }
        return gridConstraints;
    }

    @NotNull
    private static Object newCardLayoutPanelConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setRow(5);
        constraints.setColSpan(3);
        constraints.setFill(3);
        constraints.setIndent(4);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(11);
        }
        return gridConstraints;
    }

    void resetFrom(@NotNull AndroidRunConfigurationBase configuration) {
        if (configuration == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(12);
        }
        DeployTargetContext context = configuration.getDeployTargetContext();
        this.myTargetComboBox.setSelectedItem(context.getCurrentDeployTargetProvider());
        int id = configuration.hashCode();
        this.myProviders.forEach(provider2 -> this.myIdToConfigurableMap.get(provider2.getId()).resetFrom(context.getDeployTargetState((DeployTargetProvider)provider2), id));
    }

    void applyTo(@NotNull AndroidRunConfigurationBase configuration) {
        if (configuration == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(13);
        }
        DeployTargetContext context = configuration.getDeployTargetContext();
        context.setTargetSelectionMode((DeployTargetProvider)Objects.requireNonNull(this.myTargetComboBox.getSelectedItem()));
        int id = configuration.hashCode();
        this.myProviders.forEach(provider2 -> this.myIdToConfigurableMap.get(provider2.getId()).applyTo(context.getDeployTargetState((DeployTargetProvider)provider2), id));
    }

    @NotNull
    @VisibleForTesting
    JComboBox getTargetComboBox() {
        JComboBox<DeployTargetProvider> jComboBox = this.myTargetComboBox;
        if (jComboBox == null) {
            DeploymentTargetOptions.$$$reportNull$$$0(14);
        }
        return jComboBox;
    }

    private /* synthetic */ void lambda$newTargetComboBox$2(JComboBox comboBox, ActionEvent event) {
        DeployTargetProvider provider2 = (DeployTargetProvider)comboBox.getSelectedItem();
        if (provider2 != null) {
            this.myCardLayoutPanel.select((Object)this.myIdToConfigurableMap.get(provider2.getId()), true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/DeploymentTargetOptions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/DeploymentTargetOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdToConfigurableMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newTargetComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newSeparatorConstraints";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newTargetLabelConstraints";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newTargetComboBoxConstraints";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newCardLayoutPanelConstraints";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newIdToConfigurableMap";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resetFrom";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

