/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerConfigurable;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.google.common.collect.Maps;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidDebuggerPanel {
    private final AndroidDebuggerContext myAndroidDebuggerContext;
    private JPanel myPanel;
    private JComboBox<AndroidDebugger> myDebuggerType;
    private JPanel myOptionPanel;
    private JComponent myOptionComponent;
    private final Map<String, AndroidDebuggerConfigurable<AndroidDebuggerState>> myConfigurables;

    public AndroidDebuggerPanel(@NotNull RunConfiguration runConfiguration, @NotNull AndroidDebuggerContext androidDebuggerContext) {
        if (runConfiguration == null) {
            AndroidDebuggerPanel.$$$reportNull$$$0(0);
        }
        if (androidDebuggerContext == null) {
            AndroidDebuggerPanel.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myConfigurables = Maps.newHashMap();
        this.myAndroidDebuggerContext = androidDebuggerContext;
        this.myDebuggerType.setModel((ComboBoxModel<AndroidDebugger>)new CollectionComboBoxModel(this.myAndroidDebuggerContext.getAndroidDebuggers()));
        this.myDebuggerType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AndroidDebugger androidDebugger = (AndroidDebugger)AndroidDebuggerPanel.this.myDebuggerType.getSelectedItem();
                if (androidDebugger != null) {
                    AndroidDebuggerPanel.this.switchDebugOption(androidDebugger);
                }
            }
        });
        this.myDebuggerType.setRenderer((ListCellRenderer<AndroidDebugger>)SimpleListCellRenderer.create((String)"", AndroidDebugger::getDisplayName));
        for (AndroidDebugger androidDebugger : this.myAndroidDebuggerContext.getAndroidDebuggers()) {
            AndroidDebuggerConfigurable configurable = androidDebugger.createConfigurable(runConfiguration);
            configurable.resetFrom(this.myAndroidDebuggerContext.getAndroidDebuggerState(androidDebugger.getId()));
            this.myConfigurables.put(androidDebugger.getId(), configurable);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    private void switchDebugOption(@NotNull AndroidDebugger<AndroidDebuggerState> androidDebugger) {
        if (androidDebugger == null) {
            AndroidDebuggerPanel.$$$reportNull$$$0(2);
        }
        if (this.myOptionComponent != null) {
            this.myOptionPanel.remove(this.myOptionComponent);
            this.myOptionComponent = null;
        }
        AndroidDebuggerConfigurable<AndroidDebuggerState> configurable = this.getConfigurable(androidDebugger);
        configurable.resetFrom((AndroidDebuggerState)this.myAndroidDebuggerContext.getAndroidDebuggerState(androidDebugger.getId()));
        this.myOptionComponent = configurable.getComponent();
        if (this.myOptionComponent != null) {
            this.myOptionPanel.add(this.myOptionComponent);
        }
    }

    public void resetFrom(@NotNull AndroidDebuggerContext androidDebuggerContext) {
        AndroidDebugger debugOption;
        if (androidDebuggerContext == null) {
            AndroidDebuggerPanel.$$$reportNull$$$0(3);
        }
        if ((debugOption = androidDebuggerContext.getAndroidDebugger()) != null) {
            this.myDebuggerType.setSelectedItem(debugOption);
            this.switchDebugOption(debugOption);
        }
    }

    public void applyTo(@NotNull AndroidDebuggerContext androidDebuggerContext) {
        if (androidDebuggerContext == null) {
            AndroidDebuggerPanel.$$$reportNull$$$0(4);
        }
        AndroidDebugger androidDebugger = (AndroidDebugger)this.myDebuggerType.getSelectedItem();
        androidDebuggerContext.setDebuggerType(androidDebugger.getId());
        AndroidDebuggerConfigurable<AndroidDebuggerState> configurable = this.getConfigurable(androidDebugger);
        if (configurable != null) {
            configurable.applyTo((AndroidDebuggerState)this.myAndroidDebuggerContext.getAndroidDebuggerState(androidDebugger.getId()));
        }
    }

    @Nullable
    AndroidDebuggerConfigurable<AndroidDebuggerState> getConfigurable(@NotNull AndroidDebugger<AndroidDebuggerState> androidDebugger) {
        if (androidDebugger == null) {
            AndroidDebuggerPanel.$$$reportNull$$$0(5);
        }
        return this.myConfigurables.get(androidDebugger.getId());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidDebuggerContext";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidDebugger";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/editor/AndroidDebuggerPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "switchDebugOption";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resetFrom";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOptionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Debug type:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myDebuggerType = jComboBox;
        jComboBox.setEditable(false);
        ((Component)jComboBox).setEnabled(true);
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

