/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.emulator.SnapshotOuterClass;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevicesTask
implements AsyncSupplier<Collection<VirtualDevice>> {
    private final boolean mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    @NotNull
    private final FileSystem myFileSystem;
    @Nullable
    private final LaunchCompatibilityChecker myChecker;

    VirtualDevicesTask(boolean selectDeviceSnapshotComboBoxSnapshotsEnabled, @NotNull FileSystem fileSystem, @Nullable LaunchCompatibilityChecker checker) {
        if (fileSystem == null) {
            VirtualDevicesTask.$$$reportNull$$$0(0);
        }
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
        this.myFileSystem = fileSystem;
        this.myChecker = checker;
    }

    @Override
    @NotNull
    public ListenableFuture<Collection<VirtualDevice>> get() {
        ListenableFuture listenableFuture = MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService()).submit(this::getVirtualDevices);
        if (listenableFuture == null) {
            VirtualDevicesTask.$$$reportNull$$$0(1);
        }
        return listenableFuture;
    }

    @NotNull
    private Collection<VirtualDevice> getVirtualDevices() {
        Stream avds = AvdManagerConnection.getDefaultAvdManagerConnection().getAvds(false).stream();
        Collection devices2 = !this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled ? (Collection)avds.map(avd -> this.newDisconnectedDevice((AvdInfo)avd, null)).collect(Collectors.toList()) : (Collection)avds.flatMap(this::newDisconnectedDevices).collect(Collectors.toList());
        Collection collection2 = devices2;
        if (collection2 == null) {
            VirtualDevicesTask.$$$reportNull$$$0(2);
        }
        return collection2;
    }

    @NotNull
    private Stream<VirtualDevice> newDisconnectedDevices(@NotNull AvdInfo device) {
        if (device == null) {
            VirtualDevicesTask.$$$reportNull$$$0(3);
        }
        Stream.Builder<VirtualDevice> builder2 = Stream.builder().add(this.newDisconnectedDevice(device, null));
        this.getSnapshots(device).stream().map(snapshot -> this.newDisconnectedDevice(device, (Snapshot)snapshot)).forEach(builder2::add);
        Stream<VirtualDevice> stream = builder2.build();
        if (stream == null) {
            VirtualDevicesTask.$$$reportNull$$$0(4);
        }
        return stream;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private Collection<Snapshot> getSnapshots(@NotNull AvdInfo device) {
        Collection collection2;
        Stream<Path> stream;
        Path snapshots;
        block13: {
            if (device == null) {
                VirtualDevicesTask.$$$reportNull$$$0(5);
            }
            if (!Files.isDirectory(snapshots = this.myFileSystem.getPath(device.getDataFolderPath(), "snapshots"), new LinkOption[0])) {
                ImmutableList immutableList = ImmutableList.of();
                if (immutableList == null) {
                    VirtualDevicesTask.$$$reportNull$$$0(6);
                }
                return immutableList;
            }
            stream = Files.list(snapshots);
            Collector collector = ImmutableList.toImmutableList();
            collection2 = (Collection)stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(this::getSnapshot).filter(Objects::nonNull).sorted().collect(collector);
            if (stream == null) break block13;
            stream.close();
        }
        Collection collection3 = collection2;
        if (collection3 == null) {
            VirtualDevicesTask.$$$reportNull$$$0(7);
        }
        return collection3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Logger.getInstance(VirtualDevicesTask.class).warn(snapshots.toString(), (Throwable)exception);
                    ImmutableList immutableList = ImmutableList.of();
                    if (immutableList == null) {
                        VirtualDevicesTask.$$$reportNull$$$0(8);
                    }
                    return immutableList;
                }
            }
        }
    }

    @Nullable
    @VisibleForTesting
    Snapshot getSnapshot(@NotNull Path snapshotDirectory) {
        Snapshot snapshot;
        block10: {
            if (snapshotDirectory == null) {
                VirtualDevicesTask.$$$reportNull$$$0(9);
            }
            Path snapshotProtocolBuffer = snapshotDirectory.resolve("snapshot.pb");
            Path snapshotDirectoryName = snapshotDirectory.getFileName();
            if (!Files.exists(snapshotProtocolBuffer, new LinkOption[0])) {
                return new Snapshot(snapshotDirectoryName, this.myFileSystem);
            }
            InputStream in = Files.newInputStream(snapshotProtocolBuffer, new OpenOption[0]);
            try {
                snapshot = this.getSnapshot(SnapshotOuterClass.Snapshot.parseFrom(in), snapshotDirectoryName);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Logger.getInstance(VirtualDevicesTask.class).warn(snapshotDirectory.toString(), (Throwable)exception);
                    return null;
                }
            }
            in.close();
        }
        return snapshot;
    }

    @Nullable
    @VisibleForTesting
    Snapshot getSnapshot(@NotNull SnapshotOuterClass.Snapshot snapshot, @NotNull Path snapshotDirectory) {
        if (snapshot == null) {
            VirtualDevicesTask.$$$reportNull$$$0(10);
        }
        if (snapshotDirectory == null) {
            VirtualDevicesTask.$$$reportNull$$$0(11);
        }
        if (snapshot.getImagesCount() == 0) {
            return null;
        }
        String name = snapshot.getLogicalName();
        if (name.isEmpty()) {
            return new Snapshot(snapshotDirectory, this.myFileSystem);
        }
        return new Snapshot(snapshotDirectory, name);
    }

    @NotNull
    private VirtualDevice newDisconnectedDevice(@NotNull AvdInfo avd, @Nullable Snapshot snapshot) {
        if (avd == null) {
            VirtualDevicesTask.$$$reportNull$$$0(12);
        }
        LaunchableAndroidDevice device = new LaunchableAndroidDevice(avd);
        VirtualDevice.Builder builder2 = new VirtualDevice.Builder().setName(AvdManagerConnection.getAvdDisplayName(avd)).setKey(new Key(avd.getName(), snapshot)).setAndroidDevice(device).setSnapshot(snapshot);
        if (this.myChecker == null) {
            VirtualDevice virtualDevice = builder2.build();
            if (virtualDevice == null) {
                VirtualDevicesTask.$$$reportNull$$$0(13);
            }
            return virtualDevice;
        }
        LaunchCompatibility compatibility = this.myChecker.validate(device);
        VirtualDevice virtualDevice = builder2.setValid(!compatibility.isCompatible().equals((Object)ThreeState.NO)).setValidityReason(compatibility.getReason()).build();
        if (virtualDevice == null) {
            VirtualDevicesTask.$$$reportNull$$$0(14);
        }
        return virtualDevice;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/VirtualDevicesTask";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/VirtualDevicesTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualDevices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisconnectedDevices";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisconnectedDevice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newDisconnectedDevices";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshots";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newDisconnectedDevice";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

