/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceComparator;
import com.android.tools.idea.run.deployment.PhysicalDevice;
import com.android.tools.idea.run.deployment.Snapshot;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

final class SelectDeploymentTargetsDialogTableModel
extends AbstractTableModel {
    static final int SELECTED_MODEL_COLUMN_INDEX = 0;
    static final int TYPE_MODEL_COLUMN_INDEX = 1;
    private static final int DEVICE_MODEL_COLUMN_INDEX = 2;
    private static final int SERIAL_NUMBER_MODEL_COLUMN_INDEX = 3;
    private static final int SNAPSHOT_MODEL_COLUMN_INDEX = 4;
    private static final int ISSUE_MODEL_COLUMN_INDEX = 5;
    @NotNull
    private final List<Device> myDevices;
    @NotNull
    private final JTable myTable;
    @NotNull
    private final Multiset<String> myDeviceNameMultiset;

    SelectDeploymentTargetsDialogTableModel(@NotNull List<Device> devices2, @NotNull JTable table2) {
        if (devices2 == null) {
            SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(0);
        }
        if (table2 == null) {
            SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(1);
        }
        this.myDevices = devices2;
        this.myDevices.sort(new DeviceComparator());
        this.myTable = table2;
        this.myDeviceNameMultiset = (Multiset)devices2.stream().map(Device::getName).collect(Collectors.toCollection(() -> HashMultiset.create((int)this.myDevices.size())));
    }

    @NotNull
    Device getDeviceAt(int modelRowIndex) {
        Device device = this.myDevices.get(modelRowIndex);
        if (device == null) {
            SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(2);
        }
        return device;
    }

    @Override
    public int getRowCount() {
        return this.myDevices.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    @NotNull
    public String getColumnName(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return "";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Device";
            }
            case 3: {
                return "Serial Number";
            }
            case 4: {
                return "Snapshot";
            }
            case 5: {
                return "Issue";
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Icon.class;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return Object.class;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @Override
    @NotNull
    public Object getValueAt(int modelRowIndex, int modelColumnIndex) {
        switch (modelColumnIndex) {
            case 0: {
                Boolean bl = this.myTable.isRowSelected(this.myTable.convertRowIndexToView(modelRowIndex));
                if (bl == null) {
                    SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(3);
                }
                return bl;
            }
            case 1: {
                Icon icon2 = this.myDevices.get(modelRowIndex).getIcon();
                if (icon2 == null) {
                    SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(4);
                }
                return icon2;
            }
            case 2: {
                String string = this.myDevices.get(modelRowIndex).getName();
                if (string == null) {
                    SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(5);
                }
                return string;
            }
            case 3: {
                return this.getSerialNumber(this.myDevices.get(modelRowIndex));
            }
            case 4: {
                Snapshot snapshot = this.myDevices.get(modelRowIndex).getSnapshot();
                String string = snapshot == null ? "" : ((Object)snapshot).toString();
                if (string == null) {
                    SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(6);
                }
                return string;
            }
            case 5: {
                String string = Strings.nullToEmpty((String)this.myDevices.get(modelRowIndex).getValidityReason());
                if (string == null) {
                    SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        throw new AssertionError(modelColumnIndex);
    }

    @NotNull
    private Object getSerialNumber(@NotNull Device device) {
        if (device == null) {
            SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(8);
        }
        if (!(device instanceof PhysicalDevice)) {
            return "";
        }
        if (this.myDeviceNameMultiset.count((Object)device.getName()) != 1) {
            String string = device.getKey().getDeviceKey();
            if (string == null) {
                SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(9);
            }
            return string;
        }
        return "";
    }

    @Override
    public void setValueAt(@NotNull Object value2, int modelRowIndex, int modelColumnIndex) {
        if (value2 == null) {
            SelectDeploymentTargetsDialogTableModel.$$$reportNull$$$0(10);
        }
        int viewRowIndex = this.myTable.convertRowIndexToView(modelRowIndex);
        if (((Boolean)value2).booleanValue()) {
            this.myTable.addRowSelectionInterval(viewRowIndex, viewRowIndex);
        } else {
            this.myTable.removeRowSelectionInterval(viewRowIndex, viewRowIndex);
        }
        this.fireTableCellUpdated(modelRowIndex, modelColumnIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/SelectDeploymentTargetsDialogTableModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/SelectDeploymentTargetsDialogTableModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceAt";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerialNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSerialNumber";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

