/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotExecutionTargetProvider;
import com.android.tools.idea.run.deployment.DeviceComparator;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.Heading;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Popup;
import com.android.tools.idea.run.deployment.RunOnMultipleDevicesAction;
import com.android.tools.idea.run.deployment.SelectDeviceAction;
import com.android.tools.idea.run.deployment.SnapshotActionGroup;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceAndSnapshotComboBoxAction
extends ComboBoxAction {
    @VisibleForTesting
    static final String SELECTED_DEVICE = "DeviceAndSnapshotComboBoxAction.selectedDevice";
    private static final String SELECTION_TIME = "DeviceAndSnapshotComboBoxAction.selectionTime";
    public static final com.intellij.openapi.util.Key<Boolean> DEPLOYS_TO_LOCAL_DEVICE = com.intellij.openapi.util.Key.create((String)"DeviceAndSnapshotComboBoxAction.deploysToLocalDevice");
    private final Supplier<Boolean> mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    private final Function<Project, AsyncDevicesGetter> myDevicesGetterGetter;
    @NotNull
    private final Function<Project, PropertiesComponent> myGetProperties;
    private final AnAction myRunOnMultipleDevicesAction;
    private final AnAction myOpenAvdManagerAction;
    private final Clock myClock;

    private DeviceAndSnapshotComboBoxAction() {
        this(() -> (Boolean)StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED.get(), project -> (AsyncDevicesGetter)ServiceManager.getService((Project)project, AsyncDevicesGetter.class), PropertiesComponent::getInstance, Clock.systemDefaultZone());
    }

    @VisibleForTesting
    public DeviceAndSnapshotComboBoxAction(@NotNull Supplier<Boolean> selectDeviceSnapshotComboBoxSnapshotsEnabled, @NotNull Function<Project, AsyncDevicesGetter> devicesGetterGetter, @NotNull Function<Project, PropertiesComponent> getProperties2, @NotNull Clock clock) {
        if (selectDeviceSnapshotComboBoxSnapshotsEnabled == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(0);
        }
        if (devicesGetterGetter == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(1);
        }
        if (getProperties2 == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(2);
        }
        if (clock == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(3);
        }
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
        this.myDevicesGetterGetter = devicesGetterGetter;
        this.myGetProperties = getProperties2;
        this.myRunOnMultipleDevicesAction = new RunOnMultipleDevicesAction();
        this.myOpenAvdManagerAction = ActionManager.getInstance().getAction("Android.RunAndroidAvdManager");
        this.myClock = clock;
    }

    boolean areSnapshotsEnabled() {
        return this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.get();
    }

    @NotNull
    @VisibleForTesting
    final AnAction getRunOnMultipleDevicesAction() {
        AnAction anAction = this.myRunOnMultipleDevicesAction;
        if (anAction == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(4);
        }
        return anAction;
    }

    @NotNull
    @VisibleForTesting
    final AnAction getOpenAvdManagerAction() {
        AnAction anAction = this.myOpenAvdManagerAction;
        if (anAction == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(5);
        }
        return anAction;
    }

    @NotNull
    List<Device> getDevices(@NotNull Project project) {
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(6);
        }
        List<Device> devices2 = this.myDevicesGetterGetter.apply(project).get();
        devices2.sort(new DeviceComparator());
        List<Device> list = devices2;
        if (list == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    final Device getSelectedDevice(@NotNull Project project) {
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(8);
        }
        return this.getSelectedDevice(project, this.getDevices(project));
    }

    @Nullable
    private Device getSelectedDevice(@NotNull Project project, @NotNull List<Device> devices2) {
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(9);
        }
        if (devices2 == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(10);
        }
        if (devices2.isEmpty()) {
            return null;
        }
        PropertiesComponent properties = this.myGetProperties.apply(project);
        String keyAsString = properties.getValue(SELECTED_DEVICE);
        Key key = keyAsString == null ? null : new Key(keyAsString);
        Optional<Device> optionalSelectedDevice = devices2.stream().filter(device -> device.getKey().equals(key)).findFirst();
        if (!optionalSelectedDevice.isPresent()) {
            return devices2.get(0);
        }
        Device selectedDevice = optionalSelectedDevice.get();
        Optional<Device> optionalConnectedDevice = devices2.stream().filter(Device::isConnected).findFirst();
        if (optionalConnectedDevice.isPresent()) {
            Device connectedDevice = optionalConnectedDevice.get();
            Instant connectionTime = connectedDevice.getConnectionTime();
            assert (connectionTime != null) : "connected device \"" + connectedDevice + "\" has a null connection time";
            if (DeviceAndSnapshotComboBoxAction.getSelectionTime(selectedDevice, properties).isBefore(connectionTime)) {
                return connectedDevice;
            }
        }
        return selectedDevice;
    }

    @NotNull
    private static Instant getSelectionTime(@NotNull Device device, @NotNull PropertiesComponent properties) {
        String time2;
        if (device == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(11);
        }
        if (properties == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(12);
        }
        if ((time2 = properties.getValue(SELECTION_TIME)) == null) {
            Logger.getInstance(DeviceAndSnapshotComboBoxAction.class).warn("selected device \"" + device + "\" has a null selection time string");
            Instant instant = Instant.MIN;
            if (instant == null) {
                DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(13);
            }
            return instant;
        }
        Instant instant = Instant.parse(time2);
        if (instant == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(14);
        }
        return instant;
    }

    final void setSelectedDevice(@NotNull Project project, @Nullable Device selectedDevice) {
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(15);
        }
        PropertiesComponent properties = this.myGetProperties.apply(project);
        if (selectedDevice == null) {
            properties.unsetValue(SELECTED_DEVICE);
            properties.unsetValue(SELECTION_TIME);
        } else {
            properties.setValue(SELECTED_DEVICE, selectedDevice.getKey().toString());
            properties.setValue(SELECTION_TIME, this.myClock.instant().toString());
        }
        DeviceAndSnapshotComboBoxAction.updateExecutionTargetManager(project, selectedDevice);
    }

    @NotNull
    public final JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(16);
        }
        if (place == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(17);
        }
        JPanel panel2 = new JPanel(null);
        GroupLayout layout2 = new GroupLayout(panel2);
        ComboBoxAction.ComboBoxButton button2 = this.createComboBoxButton(presentation);
        GroupLayout.SequentialGroup horizontalGroup = layout2.createSequentialGroup().addComponent((Component)button2, 0, -1, Short.MAX_VALUE).addGap(JBUI.scale((int)3));
        GroupLayout.ParallelGroup verticalGroup = layout2.createParallelGroup().addComponent((Component)button2);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout2);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    @NotNull
    protected final ComboBoxAction.ComboBoxButton createComboBoxButton(@NotNull Presentation presentation) {
        if (presentation == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(19);
        }
        ComboBoxAction.ComboBoxButton button2 = new ComboBoxAction.ComboBoxButton(presentation){

            protected JBPopup createPopup(@NotNull Runnable runnable2) {
                if (runnable2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DataContext context = this.getDataContext();
                return new Popup((ActionGroup)DeviceAndSnapshotComboBoxAction.this.createPopupActionGroup((JComponent)((Object)this), context), context, runnable2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/android/tools/idea/run/deployment/DeviceAndSnapshotComboBoxAction$1", "createPopup"));
            }
        };
        button2.setName("deviceAndSnapshotComboBoxButton");
        ComboBoxAction.ComboBoxButton comboBoxButton = button2;
        if (comboBoxButton == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(20);
        }
        return comboBoxButton;
    }

    protected final boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    protected final DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2) {
        if (button2 == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(21);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected final DefaultActionGroup createPopupActionGroup(@NotNull JComponent button2, @NotNull DataContext context) {
        if (button2 == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(22);
        }
        if (context == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(23);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        Project project = (Project)context.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        Collection<AnAction> actions2 = this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.get() != false ? this.newSelectDeviceActionsIncludeSnapshots(project) : this.newSelectDeviceActions(project);
        group2.addAll(actions2);
        if (!actions2.isEmpty()) {
            group2.addSeparator();
        }
        group2.add(this.myRunOnMultipleDevicesAction);
        group2.add(this.myOpenAvdManagerAction);
        AnAction action2 = ActionManager.getInstance().getAction("DeveloperServices.ConnectionAssistant");
        if (action2 == null) {
            DefaultActionGroup defaultActionGroup = group2;
            if (defaultActionGroup == null) {
                DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(24);
            }
            return defaultActionGroup;
        }
        group2.addSeparator();
        group2.add(action2);
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(25);
        }
        return defaultActionGroup;
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceActions(@NotNull Project project) {
        boolean disconnectedDevicesPresent;
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(26);
        }
        Map<Boolean, List<Device>> connectednessToDeviceMap = this.getDevices(project).stream().collect(Collectors.groupingBy(Device::isConnected));
        Collection connectedDevices = connectednessToDeviceMap.getOrDefault(true, Collections.emptyList());
        Collection disconnectedDevices = connectednessToDeviceMap.getOrDefault(false, Collections.emptyList());
        boolean connectedDevicesPresent = !connectedDevices.isEmpty();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(connectedDevices.size() + disconnectedDevices.size() + 3);
        if (connectedDevicesPresent) {
            actions2.add(new Heading("Running devices"));
        }
        connectedDevices.stream().map(device -> SelectDeviceAction.newSelectDeviceAction(this, project, device)).forEach(actions2::add);
        boolean bl = disconnectedDevicesPresent = !disconnectedDevices.isEmpty();
        if (connectedDevicesPresent && disconnectedDevicesPresent) {
            actions2.add((AnAction)Separator.create());
        }
        if (disconnectedDevicesPresent) {
            actions2.add(new Heading("Available devices"));
        }
        disconnectedDevices.stream().map(device -> SelectDeviceAction.newSelectDeviceAction(this, project, device)).forEach(actions2::add);
        ArrayList<AnAction> arrayList = actions2;
        if (arrayList == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceActionsIncludeSnapshots(@NotNull Project project) {
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(28);
        }
        ListMultimap<String, Device> multimap = this.getDeviceKeyToDeviceMultimap(project);
        Set deviceKeys = multimap.keySet();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(deviceKeys.size() + 1);
        if (!deviceKeys.isEmpty()) {
            actions2.add(new Heading("Available devices"));
        }
        deviceKeys.stream().map(arg_0 -> multimap.get(arg_0)).map(devices2 -> this.newAction((List<Device>)devices2, project)).forEach(actions2::add);
        ArrayList<AnAction> arrayList = actions2;
        if (arrayList == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @NotNull
    private ListMultimap<String, Device> getDeviceKeyToDeviceMultimap(@NotNull Project project) {
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(30);
        }
        List<Device> devices2 = this.myDevicesGetterGetter.apply(project).get();
        Collector collector = Multimaps.toMultimap(device -> device.getKey().getDeviceKey(), device -> device, () -> DeviceAndSnapshotComboBoxAction.buildListMultimap(devices2.size()));
        ListMultimap listMultimap = (ListMultimap)devices2.stream().collect(collector);
        if (listMultimap == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(31);
        }
        return listMultimap;
    }

    @NotNull
    private static ListMultimap<String, Device> buildListMultimap(int expectedKeyCount) {
        ListMultimap listMultimap = MultimapBuilder.hashKeys((int)expectedKeyCount).arrayListValues().build();
        if (listMultimap == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(32);
        }
        return listMultimap;
    }

    @NotNull
    private AnAction newAction(@NotNull List<Device> devices2, @NotNull Project project) {
        if (devices2 == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(33);
        }
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(34);
        }
        if (devices2.size() == 1) {
            AnAction anAction = SelectDeviceAction.newSelectDeviceAction(this, project, devices2.get(0));
            if (anAction == null) {
                DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(35);
            }
            return anAction;
        }
        return new SnapshotActionGroup(devices2, this, project);
    }

    public final void update(@NotNull AnActionEvent event) {
        if (event == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(36);
        }
        Presentation presentation = event.getPresentation();
        Project project = event.getProject();
        if (project == null) {
            presentation.setVisible(false);
            return;
        }
        if (!AndroidUtils.hasAndroidFacets(project)) {
            presentation.setVisible(false);
            return;
        }
        DeviceAndSnapshotComboBoxAction.updatePresentation(presentation, RunManager.getInstance((Project)project).getSelectedConfiguration());
        List<Device> devices2 = this.getDevices(project);
        Device device = this.getSelectedDevice(project, devices2);
        if (event.getPlace().equals("MainMenu")) {
            presentation.setIcon(null);
            presentation.setText("Select Device...");
        } else if (devices2.isEmpty()) {
            presentation.setIcon(null);
            presentation.setText("No Devices");
        } else {
            assert (device != null);
            presentation.setIcon(device.getIcon());
            presentation.setText(DeviceAndSnapshotComboBoxAction.getText(device, devices2, this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.get()), false);
        }
        DeviceAndSnapshotComboBoxAction.updateExecutionTargetManager(project, device);
    }

    @VisibleForTesting
    static void updatePresentation(@NotNull Presentation presentation, @Nullable RunnerAndConfigurationSettings settings) {
        Boolean deploysToLocalDevice;
        if (presentation == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(37);
        }
        if (settings == null) {
            presentation.setDescription("Add a run/debug configuration");
            presentation.setEnabled(false);
            return;
        }
        RunConfiguration configuration = settings.getConfiguration();
        if (configuration instanceof UserDataHolder && (deploysToLocalDevice = (Boolean)((UserDataHolder)configuration).getUserData(DEPLOYS_TO_LOCAL_DEVICE)) != null && deploysToLocalDevice.booleanValue()) {
            presentation.setDescription(Presentation.NULL_STRING);
            presentation.setEnabled(true);
            return;
        }
        if (!(configuration instanceof AndroidRunConfiguration) && !(configuration instanceof AndroidTestRunConfiguration)) {
            presentation.setDescription("Not applicable for the \"" + configuration.getName() + "\" configuration");
            presentation.setEnabled(false);
            return;
        }
        presentation.setDescription(Presentation.NULL_STRING);
        presentation.setEnabled(true);
    }

    @NotNull
    @VisibleForTesting
    static String getText(@NotNull Device device, @NotNull Collection<Device> devices2, boolean snapshotsEnabled) {
        boolean anotherDeviceHasSameName;
        if (device == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(38);
        }
        if (devices2 == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(39);
        }
        String string = Devices.getText(device, (anotherDeviceHasSameName = Devices.containsAnotherDeviceWithSameName(devices2, device)) ? device.getKey() : null, snapshotsEnabled ? device.getSnapshot() : null);
        if (string == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(40);
        }
        return string;
    }

    private static void updateExecutionTargetManager(@NotNull Project project, @Nullable Device device) {
        if (project == null) {
            DeviceAndSnapshotComboBoxAction.$$$reportNull$$$0(41);
        }
        ExecutionTarget target = ExecutionTargetManager.getInstance((Project)project).getActiveTarget();
        if (device == null && target == DefaultExecutionTarget.INSTANCE || target instanceof DeviceAndSnapshotExecutionTargetProvider.Target && Objects.equals(device, ((DeviceAndSnapshotExecutionTargetProvider.Target)target).getDevice())) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings settings = runManager.getSelectedConfiguration();
            if (settings == null || runManager.findSettings(settings.getConfiguration()) == null) {
                return;
            }
            ExecutionTargetManager manager = ExecutionTargetManager.getInstance((Project)project);
            for (ExecutionTarget availableTarget : manager.getTargetsFor(settings.getConfiguration())) {
                if (!(availableTarget instanceof DeviceAndSnapshotExecutionTargetProvider.Target)) continue;
                manager.setActiveTarget(availableTarget);
                break;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectDeviceSnapshotComboBoxSnapshotsEnabled";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devicesGetterGetter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clock";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/DeviceAndSnapshotComboBoxAction";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 11: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 16: 
            case 19: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/DeviceAndSnapshotComboBoxAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunOnMultipleDevicesAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenAvdManagerAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionTime";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createComboBoxButton";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "newSelectDeviceActions";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "newSelectDeviceActionsIncludeSnapshots";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceKeyToDeviceMultimap";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "buildListMultimap";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "newAction";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 40: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDevices";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedDevice";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectionTime";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedDevice";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createComboBoxButton";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "newSelectDeviceActions";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "newSelectDeviceActionsIncludeSnapshots";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceKeyToDeviceMultimap";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "newAction";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "updateExecutionTargetManager";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

